/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the grouping recommendation you have accepted to include in your application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptGroupingRecommendationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<AcceptGroupingRecommendationEntry.Builder, AcceptGroupingRecommendationEntry> {
    private static final SdkField<String> GROUPING_RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupingRecommendationId").getter(getter(AcceptGroupingRecommendationEntry::groupingRecommendationId))
            .setter(setter(Builder::groupingRecommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingRecommendationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GROUPING_RECOMMENDATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupingRecommendationId;

    private AcceptGroupingRecommendationEntry(BuilderImpl builder) {
        this.groupingRecommendationId = builder.groupingRecommendationId;
    }

    /**
     * <p>
     * Indicates the identifier of the grouping recommendation.
     * </p>
     * 
     * @return Indicates the identifier of the grouping recommendation.
     */
    public final String groupingRecommendationId() {
        return groupingRecommendationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupingRecommendationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptGroupingRecommendationEntry)) {
            return false;
        }
        AcceptGroupingRecommendationEntry other = (AcceptGroupingRecommendationEntry) obj;
        return Objects.equals(groupingRecommendationId(), other.groupingRecommendationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptGroupingRecommendationEntry").add("GroupingRecommendationId", groupingRecommendationId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupingRecommendationId":
            return Optional.ofNullable(clazz.cast(groupingRecommendationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptGroupingRecommendationEntry, T> g) {
        return obj -> g.apply((AcceptGroupingRecommendationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceptGroupingRecommendationEntry> {
        /**
         * <p>
         * Indicates the identifier of the grouping recommendation.
         * </p>
         * 
         * @param groupingRecommendationId
         *        Indicates the identifier of the grouping recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingRecommendationId(String groupingRecommendationId);
    }

    static final class BuilderImpl implements Builder {
        private String groupingRecommendationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptGroupingRecommendationEntry model) {
            groupingRecommendationId(model.groupingRecommendationId);
        }

        public final String getGroupingRecommendationId() {
            return groupingRecommendationId;
        }

        public final void setGroupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
        }

        @Override
        public final Builder groupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
            return this;
        }

        @Override
        public AcceptGroupingRecommendationEntry build() {
            return new AcceptGroupingRecommendationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
