/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a resource identifier for the drifted resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceIdentifier.Builder, ResourceIdentifier> {
    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField
            .<LogicalResourceId> builder(MarshallingType.SDK_POJO).memberName("logicalResourceId")
            .getter(getter(ResourceIdentifier::logicalResourceId)).setter(setter(Builder::logicalResourceId))
            .constructor(LogicalResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ResourceIdentifier::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final LogicalResourceId logicalResourceId;

    private final String resourceType;

    private ResourceIdentifier(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * Logical identifier of the drifted resource.
     * </p>
     * 
     * @return Logical identifier of the drifted resource.
     */
    public final LogicalResourceId logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * Type of the drifted resource.
     * </p>
     * 
     * @return Type of the drifted resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier) obj;
        return Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceIdentifier").add("LogicalResourceId", logicalResourceId())
                .add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdentifier, T> g) {
        return obj -> g.apply((ResourceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceIdentifier> {
        /**
         * <p>
         * Logical identifier of the drifted resource.
         * </p>
         * 
         * @param logicalResourceId
         *        Logical identifier of the drifted resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(LogicalResourceId logicalResourceId);

        /**
         * <p>
         * Logical identifier of the drifted resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogicalResourceId.Builder} avoiding the
         * need to create one manually via {@link LogicalResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogicalResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #logicalResourceId(LogicalResourceId)}.
         * 
         * @param logicalResourceId
         *        a consumer that will call methods on {@link LogicalResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicalResourceId(LogicalResourceId)
         */
        default Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return logicalResourceId(LogicalResourceId.builder().applyMutation(logicalResourceId).build());
        }

        /**
         * <p>
         * Type of the drifted resource.
         * </p>
         * 
         * @param resourceType
         *        Type of the drifted resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private LogicalResourceId logicalResourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            logicalResourceId(model.logicalResourceId);
            resourceType(model.resourceType);
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return logicalResourceId != null ? logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
