/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.resiliencehub.internal.ResiliencehubServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.resiliencehub.model.AcceptResourceGroupingRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.AcceptResourceGroupingRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.AccessDeniedException;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.ConflictException;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppInputSourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppInputSourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResourceGroupingRecommendationTaskRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResourceGroupingRecommendationTaskResponse;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.InternalServerException;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentComplianceDriftsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentComplianceDriftsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentResourceDriftsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentResourceDriftsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionAppComponentsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionAppComponentsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListResourceGroupingRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResourceGroupingRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.RejectResourceGroupingRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.RejectResourceGroupingRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubException;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.resiliencehub.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.StartResourceGroupingRecommendationTaskRequest;
import software.amazon.awssdk.services.resiliencehub.model.StartResourceGroupingRecommendationTaskResponse;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ThrottlingException;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.ValidationException;
import software.amazon.awssdk.services.resiliencehub.transform.AcceptResourceGroupingRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.AddDraftAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.BatchUpdateRecommendationStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateRecommendationTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppInputSourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteRecommendationTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionResourcesResolutionStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeDraftAppVersionResourcesImportStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeResourceGroupingRecommendationTaskRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ImportResourcesToDraftAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAlarmRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppAssessmentComplianceDriftsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppAssessmentResourceDriftsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppComponentCompliancesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppComponentRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppInputSourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionAppComponentsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListRecommendationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListResiliencyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListResourceGroupingRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListSopRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListSuggestedResiliencyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListTestRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListUnsupportedAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.PublishAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.PutDraftAppVersionTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.RejectResourceGroupingRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.RemoveDraftAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ResolveAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.StartAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.StartResourceGroupingRecommendationTaskRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ResiliencehubAsyncClient}.
 *
 * @see ResiliencehubAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultResiliencehubAsyncClient implements ResiliencehubAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultResiliencehubAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultResiliencehubAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts the resource grouping recommendations suggested by Resilience Hub for your application.
     * </p>
     *
     * @param acceptResourceGroupingRecommendationsRequest
     * @return A Java Future containing the result of the AcceptResourceGroupingRecommendations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.AcceptResourceGroupingRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AcceptResourceGroupingRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptResourceGroupingRecommendationsResponse> acceptResourceGroupingRecommendations(
            AcceptResourceGroupingRecommendationsRequest acceptResourceGroupingRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptResourceGroupingRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptResourceGroupingRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptResourceGroupingRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptResourceGroupingRecommendationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AcceptResourceGroupingRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptResourceGroupingRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptResourceGroupingRecommendationsRequest, AcceptResourceGroupingRecommendationsResponse>()
                            .withOperationName("AcceptResourceGroupingRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptResourceGroupingRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptResourceGroupingRecommendationsRequest));
            CompletableFuture<AcceptResourceGroupingRecommendationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the source of resource-maps to the draft version of an application. During assessment, Resilience Hub will
     * use these resource-maps to resolve the latest physical ID for each resource in the application template. For more
     * information about different types of resources supported by Resilience Hub and how to add them in your
     * application, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/how-app-manage.html">Step
     * 2: How is your application managed?</a> in the Resilience Hub User Guide.
     * </p>
     *
     * @param addDraftAppVersionResourceMappingsRequest
     * @return A Java Future containing the result of the AddDraftAppVersionResourceMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.AddDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AddDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddDraftAppVersionResourceMappingsResponse> addDraftAppVersionResourceMappings(
            AddDraftAppVersionResourceMappingsRequest addDraftAppVersionResourceMappingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addDraftAppVersionResourceMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addDraftAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddDraftAppVersionResourceMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddDraftAppVersionResourceMappingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AddDraftAppVersionResourceMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddDraftAppVersionResourceMappingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddDraftAppVersionResourceMappingsRequest, AddDraftAppVersionResourceMappingsResponse>()
                            .withOperationName("AddDraftAppVersionResourceMappings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddDraftAppVersionResourceMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addDraftAppVersionResourceMappingsRequest));
            CompletableFuture<AddDraftAppVersionResourceMappingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables you to include or exclude one or more operational recommendations.
     * </p>
     *
     * @param batchUpdateRecommendationStatusRequest
     * @return A Java Future containing the result of the BatchUpdateRecommendationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.BatchUpdateRecommendationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/BatchUpdateRecommendationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateRecommendationStatusResponse> batchUpdateRecommendationStatus(
            BatchUpdateRecommendationStatusRequest batchUpdateRecommendationStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateRecommendationStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateRecommendationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateRecommendationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateRecommendationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchUpdateRecommendationStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateRecommendationStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateRecommendationStatusRequest, BatchUpdateRecommendationStatusResponse>()
                            .withOperationName("BatchUpdateRecommendationStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchUpdateRecommendationStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchUpdateRecommendationStatusRequest));
            CompletableFuture<BatchUpdateRecommendationStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Resilience Hub application. An Resilience Hub application is a collection of Amazon Web Services
     * resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience
     * Hub application, you provide an application name, resources from one or more CloudFormation stacks, Resource
     * Groups, Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you
     * can also add resources that are located on Amazon Elastic Kubernetes Service (Amazon EKS) clusters as optional
     * resources. For more information about the number of resources supported per application, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub">Service quotas</a>.
     * </p>
     * <p>
     * After you create an Resilience Hub application, you publish it so that you can run a resiliency assessment on it.
     * You can then use recommendations from the assessment to improve resiliency by running another assessment,
     * comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO)
     * and recovery point objective (RPO).
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>().withOperationName("CreateApp")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAppRequest));
            CompletableFuture<CreateAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Application Component in the Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this Application Component for running
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </note>
     *
     * @param createAppVersionAppComponentRequest
     * @return A Java Future containing the result of the CreateAppVersionAppComponent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.CreateAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppVersionAppComponentResponse> createAppVersionAppComponent(
            CreateAppVersionAppComponentRequest createAppVersionAppComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppVersionAppComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppVersionAppComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAppVersionAppComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppVersionAppComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppVersionAppComponentRequest, CreateAppVersionAppComponentResponse>()
                            .withOperationName("CreateAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAppVersionAppComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAppVersionAppComponentRequest));
            CompletableFuture<CreateAppVersionAppComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a resource to the Resilience Hub application and assigns it to the specified Application Components. If you
     * specify a new Application Component, Resilience Hub will automatically create the Application Component.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * This action has no effect outside Resilience Hub.
     * </p>
     * </li>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this resource for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * To update application version with new <code>physicalResourceID</code>, you must call
     * <code>ResolveAppVersionResources</code> API.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createAppVersionResourceRequest
     * @return A Java Future containing the result of the CreateAppVersionResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.CreateAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppVersionResourceResponse> createAppVersionResource(
            CreateAppVersionResourceRequest createAppVersionResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppVersionResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAppVersionResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppVersionResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppVersionResourceRequest, CreateAppVersionResourceResponse>()
                            .withOperationName("CreateAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAppVersionResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAppVersionResourceRequest));
            CompletableFuture<CreateAppVersionResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new recommendation template for the Resilience Hub application.
     * </p>
     *
     * @param createRecommendationTemplateRequest
     * @return A Java Future containing the result of the CreateRecommendationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.CreateRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRecommendationTemplateResponse> createRecommendationTemplate(
            CreateRecommendationTemplateRequest createRecommendationTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRecommendationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRecommendationTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRecommendationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRecommendationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRecommendationTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRecommendationTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRecommendationTemplateRequest, CreateRecommendationTemplateResponse>()
                            .withOperationName("CreateRecommendationTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRecommendationTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRecommendationTemplateRequest));
            CompletableFuture<CreateRecommendationTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a resiliency policy for an application.
     * </p>
     * <note>
     * <p>
     * Resilience Hub allows you to provide a value of zero for <code>rtoInSecs</code> and <code>rpoInSecs</code> of
     * your resiliency policy. But, while assessing your application, the lowest possible assessment result is near
     * zero. Hence, if you provide value zero for <code>rtoInSecs</code> and <code>rpoInSecs</code>, the estimated
     * workload RTO and estimated workload RPO result will be near zero and the <b>Compliance status</b> for your
     * application will be set to <b>Policy breached</b>.
     * </p>
     * </note>
     *
     * @param createResiliencyPolicyRequest
     * @return A Java Future containing the result of the CreateResiliencyPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.CreateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResiliencyPolicyResponse> createResiliencyPolicy(
            CreateResiliencyPolicyRequest createResiliencyPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResiliencyPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResiliencyPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResiliencyPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResiliencyPolicyRequest, CreateResiliencyPolicyResponse>()
                            .withOperationName("CreateResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResiliencyPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResiliencyPolicyRequest));
            CompletableFuture<CreateResiliencyPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Resilience Hub application. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>().withOperationName("DeleteApp")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAppRequest));
            CompletableFuture<DeleteAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Resilience Hub application assessment. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppAssessmentRequest
     * @return A Java Future containing the result of the DeleteAppAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DeleteAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppAssessmentResponse> deleteAppAssessment(
            DeleteAppAssessmentRequest deleteAppAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAppAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppAssessmentRequest, DeleteAppAssessmentResponse>()
                            .withOperationName("DeleteAppAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAppAssessmentRequest));
            CompletableFuture<DeleteAppAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the input source and all of its imported resources from the Resilience Hub application.
     * </p>
     *
     * @param deleteAppInputSourceRequest
     * @return A Java Future containing the result of the DeleteAppInputSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DeleteAppInputSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppInputSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppInputSourceResponse> deleteAppInputSource(
            DeleteAppInputSourceRequest deleteAppInputSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppInputSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppInputSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppInputSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppInputSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAppInputSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppInputSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppInputSourceRequest, DeleteAppInputSourceResponse>()
                            .withOperationName("DeleteAppInputSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppInputSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAppInputSourceRequest));
            CompletableFuture<DeleteAppInputSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Application Component from the Resilience Hub application.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this Application Component for running
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * You will not be able to delete an Application Component if it has resources associated with it.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteAppVersionAppComponentRequest
     * @return A Java Future containing the result of the DeleteAppVersionAppComponent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DeleteAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppVersionAppComponentResponse> deleteAppVersionAppComponent(
            DeleteAppVersionAppComponentRequest deleteAppVersionAppComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppVersionAppComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppVersionAppComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAppVersionAppComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppVersionAppComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppVersionAppComponentRequest, DeleteAppVersionAppComponentResponse>()
                            .withOperationName("DeleteAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppVersionAppComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAppVersionAppComponentRequest));
            CompletableFuture<DeleteAppVersionAppComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource from the Resilience Hub application.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You can only delete a manually added resource. To exclude non-manually added resources, use the
     * <code>UpdateAppVersionResource</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * This action has no effect outside Resilience Hub.
     * </p>
     * </li>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this resource for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteAppVersionResourceRequest
     * @return A Java Future containing the result of the DeleteAppVersionResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DeleteAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppVersionResourceResponse> deleteAppVersionResource(
            DeleteAppVersionResourceRequest deleteAppVersionResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppVersionResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAppVersionResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppVersionResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppVersionResourceRequest, DeleteAppVersionResourceResponse>()
                            .withOperationName("DeleteAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppVersionResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAppVersionResourceRequest));
            CompletableFuture<DeleteAppVersionResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteRecommendationTemplateRequest
     * @return A Java Future containing the result of the DeleteRecommendationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DeleteRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRecommendationTemplateResponse> deleteRecommendationTemplate(
            DeleteRecommendationTemplateRequest deleteRecommendationTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRecommendationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRecommendationTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommendationTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRecommendationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRecommendationTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRecommendationTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommendationTemplateRequest, DeleteRecommendationTemplateResponse>()
                            .withOperationName("DeleteRecommendationTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRecommendationTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRecommendationTemplateRequest));
            CompletableFuture<DeleteRecommendationTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteResiliencyPolicyRequest
     * @return A Java Future containing the result of the DeleteResiliencyPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DeleteResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResiliencyPolicyResponse> deleteResiliencyPolicy(
            DeleteResiliencyPolicyRequest deleteResiliencyPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResiliencyPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResiliencyPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResiliencyPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResiliencyPolicyRequest, DeleteResiliencyPolicyResponse>()
                            .withOperationName("DeleteResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResiliencyPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResiliencyPolicyRequest));
            CompletableFuture<DeleteResiliencyPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an Resilience Hub application.
     * </p>
     *
     * @param describeAppRequest
     * @return A Java Future containing the result of the DescribeApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppResponse> describeApp(DescribeAppRequest describeAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppRequest, DescribeAppResponse>()
                            .withOperationName("DescribeApp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppRequest));
            CompletableFuture<DescribeAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an assessment for an Resilience Hub application.
     * </p>
     *
     * @param describeAppAssessmentRequest
     * @return A Java Future containing the result of the DescribeAppAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppAssessmentResponse> describeAppAssessment(
            DescribeAppAssessmentRequest describeAppAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAppAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppAssessmentRequest, DescribeAppAssessmentResponse>()
                            .withOperationName("DescribeAppAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppAssessmentRequest));
            CompletableFuture<DescribeAppAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the Resilience Hub application version.
     * </p>
     *
     * @param describeAppVersionRequest
     * @return A Java Future containing the result of the DescribeAppVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppVersionResponse> describeAppVersion(DescribeAppVersionRequest describeAppVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAppVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionRequest, DescribeAppVersionResponse>()
                            .withOperationName("DescribeAppVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppVersionRequest));
            CompletableFuture<DescribeAppVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an Application Component in the Resilience Hub application.
     * </p>
     *
     * @param describeAppVersionAppComponentRequest
     * @return A Java Future containing the result of the DescribeAppVersionAppComponent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppVersionAppComponentResponse> describeAppVersionAppComponent(
            DescribeAppVersionAppComponentRequest describeAppVersionAppComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAppVersionAppComponentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionAppComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAppVersionAppComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppVersionAppComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionAppComponentRequest, DescribeAppVersionAppComponentResponse>()
                            .withOperationName("DescribeAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppVersionAppComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppVersionAppComponentRequest));
            CompletableFuture<DescribeAppVersionAppComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a resource of the Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * This API accepts only one of the following parameters to describe the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resourceName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logicalResourceId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>physicalResourceId</code> (Along with <code>physicalResourceId</code>, you can also provide
     * <code>awsAccountId</code>, and <code>awsRegion</code>)
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeAppVersionResourceRequest
     * @return A Java Future containing the result of the DescribeAppVersionResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppVersionResourceResponse> describeAppVersionResource(
            DescribeAppVersionResourceRequest describeAppVersionResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAppVersionResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppVersionResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionResourceRequest, DescribeAppVersionResourceResponse>()
                            .withOperationName("DescribeAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppVersionResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppVersionResourceRequest));
            CompletableFuture<DescribeAppVersionResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the resolution status for the specified resolution identifier for an application version. If
     * <code>resolutionId</code> is not specified, the current resolution status is returned.
     * </p>
     *
     * @param describeAppVersionResourcesResolutionStatusRequest
     * @return A Java Future containing the result of the DescribeAppVersionResourcesResolutionStatus operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeAppVersionResourcesResolutionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResourcesResolutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppVersionResourcesResolutionStatusResponse> describeAppVersionResourcesResolutionStatus(
            DescribeAppVersionResourcesResolutionStatusRequest describeAppVersionResourcesResolutionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeAppVersionResourcesResolutionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAppVersionResourcesResolutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionResourcesResolutionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppVersionResourcesResolutionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAppVersionResourcesResolutionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppVersionResourcesResolutionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionResourcesResolutionStatusRequest, DescribeAppVersionResourcesResolutionStatusResponse>()
                            .withOperationName("DescribeAppVersionResourcesResolutionStatus")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppVersionResourcesResolutionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppVersionResourcesResolutionStatusRequest));
            CompletableFuture<DescribeAppVersionResourcesResolutionStatusResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes details about an Resilience Hub application.
     * </p>
     *
     * @param describeAppVersionTemplateRequest
     * @return A Java Future containing the result of the DescribeAppVersionTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppVersionTemplateResponse> describeAppVersionTemplate(
            DescribeAppVersionTemplateRequest describeAppVersionTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppVersionTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppVersionTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAppVersionTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppVersionTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionTemplateRequest, DescribeAppVersionTemplateResponse>()
                            .withOperationName("DescribeAppVersionTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppVersionTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppVersionTemplateRequest));
            CompletableFuture<DescribeAppVersionTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of importing resources to an application version.
     * </p>
     * <note>
     * <p>
     * If you get a 404 error with <code>ResourceImportStatusNotFoundAppMetadataException</code>, you must call
     * <code>importResourcesToDraftAppVersion</code> after creating the application and before calling
     * <code>describeDraftAppVersionResourcesImportStatus</code> to obtain the status.
     * </p>
     * </note>
     *
     * @param describeDraftAppVersionResourcesImportStatusRequest
     * @return A Java Future containing the result of the DescribeDraftAppVersionResourcesImportStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeDraftAppVersionResourcesImportStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeDraftAppVersionResourcesImportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDraftAppVersionResourcesImportStatusResponse> describeDraftAppVersionResourcesImportStatus(
            DescribeDraftAppVersionResourcesImportStatusRequest describeDraftAppVersionResourcesImportStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeDraftAppVersionResourcesImportStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDraftAppVersionResourcesImportStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDraftAppVersionResourcesImportStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDraftAppVersionResourcesImportStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDraftAppVersionResourcesImportStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDraftAppVersionResourcesImportStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDraftAppVersionResourcesImportStatusRequest, DescribeDraftAppVersionResourcesImportStatusResponse>()
                            .withOperationName("DescribeDraftAppVersionResourcesImportStatus")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDraftAppVersionResourcesImportStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDraftAppVersionResourcesImportStatusRequest));
            CompletableFuture<DescribeDraftAppVersionResourcesImportStatusResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a specified resiliency policy for an Resilience Hub application. The returned policy object includes
     * creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
     * </p>
     *
     * @param describeResiliencyPolicyRequest
     * @return A Java Future containing the result of the DescribeResiliencyPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResiliencyPolicyResponse> describeResiliencyPolicy(
            DescribeResiliencyPolicyRequest describeResiliencyPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResiliencyPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResiliencyPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeResiliencyPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResiliencyPolicyRequest, DescribeResiliencyPolicyResponse>()
                            .withOperationName("DescribeResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResiliencyPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResiliencyPolicyRequest));
            CompletableFuture<DescribeResiliencyPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the resource grouping recommendation tasks run by Resilience Hub for your application.
     * </p>
     *
     * @param describeResourceGroupingRecommendationTaskRequest
     * @return A Java Future containing the result of the DescribeResourceGroupingRecommendationTask operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.DescribeResourceGroupingRecommendationTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResourceGroupingRecommendationTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourceGroupingRecommendationTaskResponse> describeResourceGroupingRecommendationTask(
            DescribeResourceGroupingRecommendationTaskRequest describeResourceGroupingRecommendationTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeResourceGroupingRecommendationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeResourceGroupingRecommendationTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourceGroupingRecommendationTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourceGroupingRecommendationTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeResourceGroupingRecommendationTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeResourceGroupingRecommendationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourceGroupingRecommendationTaskRequest, DescribeResourceGroupingRecommendationTaskResponse>()
                            .withOperationName("DescribeResourceGroupingRecommendationTask")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResourceGroupingRecommendationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResourceGroupingRecommendationTaskRequest));
            CompletableFuture<DescribeResourceGroupingRecommendationTaskResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports resources to Resilience Hub application draft version from different input sources. For more information
     * about the input sources supported by Resilience Hub, see <a
     * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html">Discover the structure
     * and describe your Resilience Hub application</a>.
     * </p>
     *
     * @param importResourcesToDraftAppVersionRequest
     * @return A Java Future containing the result of the ImportResourcesToDraftAppVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ImportResourcesToDraftAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportResourcesToDraftAppVersionResponse> importResourcesToDraftAppVersion(
            ImportResourcesToDraftAppVersionRequest importResourcesToDraftAppVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importResourcesToDraftAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                importResourcesToDraftAppVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportResourcesToDraftAppVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportResourcesToDraftAppVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ImportResourcesToDraftAppVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportResourcesToDraftAppVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportResourcesToDraftAppVersionRequest, ImportResourcesToDraftAppVersionResponse>()
                            .withOperationName("ImportResourcesToDraftAppVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportResourcesToDraftAppVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importResourcesToDraftAppVersionRequest));
            CompletableFuture<ImportResourcesToDraftAppVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the alarm recommendations for an Resilience Hub application.
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     * @return A Java Future containing the result of the ListAlarmRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAlarmRecommendationsResponse> listAlarmRecommendations(
            ListAlarmRecommendationsRequest listAlarmRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAlarmRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAlarmRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAlarmRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAlarmRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAlarmRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAlarmRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAlarmRecommendationsRequest, ListAlarmRecommendationsResponse>()
                            .withOperationName("ListAlarmRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAlarmRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAlarmRecommendationsRequest));
            CompletableFuture<ListAlarmRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Indicates the list of compliance drifts that were detected while running an assessment.
     * </p>
     *
     * @param listAppAssessmentComplianceDriftsRequest
     * @return A Java Future containing the result of the ListAppAssessmentComplianceDrifts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppAssessmentComplianceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessmentComplianceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppAssessmentComplianceDriftsResponse> listAppAssessmentComplianceDrifts(
            ListAppAssessmentComplianceDriftsRequest listAppAssessmentComplianceDriftsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppAssessmentComplianceDriftsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppAssessmentComplianceDriftsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppAssessmentComplianceDrifts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppAssessmentComplianceDriftsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAppAssessmentComplianceDriftsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppAssessmentComplianceDriftsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppAssessmentComplianceDriftsRequest, ListAppAssessmentComplianceDriftsResponse>()
                            .withOperationName("ListAppAssessmentComplianceDrifts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppAssessmentComplianceDriftsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppAssessmentComplianceDriftsRequest));
            CompletableFuture<ListAppAssessmentComplianceDriftsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Indicates the list of resource drifts that were detected while running an assessment.
     * </p>
     *
     * @param listAppAssessmentResourceDriftsRequest
     * @return A Java Future containing the result of the ListAppAssessmentResourceDrifts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppAssessmentResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessmentResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppAssessmentResourceDriftsResponse> listAppAssessmentResourceDrifts(
            ListAppAssessmentResourceDriftsRequest listAppAssessmentResourceDriftsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppAssessmentResourceDriftsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppAssessmentResourceDriftsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppAssessmentResourceDrifts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppAssessmentResourceDriftsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppAssessmentResourceDriftsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppAssessmentResourceDriftsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppAssessmentResourceDriftsRequest, ListAppAssessmentResourceDriftsResponse>()
                            .withOperationName("ListAppAssessmentResourceDrifts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppAssessmentResourceDriftsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppAssessmentResourceDriftsRequest));
            CompletableFuture<ListAppAssessmentResourceDriftsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the assessments for an Resilience Hub application. You can use request parameters to refine the results for
     * the response object.
     * </p>
     *
     * @param listAppAssessmentsRequest
     * @return A Java Future containing the result of the ListAppAssessments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppAssessmentsResponse> listAppAssessments(ListAppAssessmentsRequest listAppAssessmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppAssessmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppAssessmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppAssessments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppAssessmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppAssessmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppAssessmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppAssessmentsRequest, ListAppAssessmentsResponse>()
                            .withOperationName("ListAppAssessments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppAssessmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppAssessmentsRequest));
            CompletableFuture<ListAppAssessmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the compliances for an Resilience Hub Application Component.
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     * @return A Java Future containing the result of the ListAppComponentCompliances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppComponentCompliancesResponse> listAppComponentCompliances(
            ListAppComponentCompliancesRequest listAppComponentCompliancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppComponentCompliancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppComponentCompliancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppComponentCompliances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppComponentCompliancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppComponentCompliancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppComponentCompliancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppComponentCompliancesRequest, ListAppComponentCompliancesResponse>()
                            .withOperationName("ListAppComponentCompliances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppComponentCompliancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppComponentCompliancesRequest));
            CompletableFuture<ListAppComponentCompliancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the recommendations for an Resilience Hub Application Component.
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     * @return A Java Future containing the result of the ListAppComponentRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppComponentRecommendationsResponse> listAppComponentRecommendations(
            ListAppComponentRecommendationsRequest listAppComponentRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppComponentRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppComponentRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppComponentRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppComponentRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppComponentRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppComponentRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppComponentRecommendationsRequest, ListAppComponentRecommendationsResponse>()
                            .withOperationName("ListAppComponentRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppComponentRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppComponentRecommendationsRequest));
            CompletableFuture<ListAppComponentRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the input sources of the Resilience Hub application. For more information about the input sources
     * supported by Resilience Hub, see <a
     * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html">Discover the structure
     * and describe your Resilience Hub application</a>.
     * </p>
     *
     * @param listAppInputSourcesRequest
     * @return A Java Future containing the result of the ListAppInputSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppInputSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppInputSources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppInputSourcesResponse> listAppInputSources(
            ListAppInputSourcesRequest listAppInputSourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppInputSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppInputSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppInputSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppInputSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppInputSourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppInputSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppInputSourcesRequest, ListAppInputSourcesResponse>()
                            .withOperationName("ListAppInputSources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppInputSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppInputSourcesRequest));
            CompletableFuture<ListAppInputSourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the Application Components in the Resilience Hub application.
     * </p>
     *
     * @param listAppVersionAppComponentsRequest
     * @return A Java Future containing the result of the ListAppVersionAppComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppVersionAppComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionAppComponents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppVersionAppComponentsResponse> listAppVersionAppComponents(
            ListAppVersionAppComponentsRequest listAppVersionAppComponentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionAppComponentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionAppComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionAppComponents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppVersionAppComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppVersionAppComponentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppVersionAppComponentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionAppComponentsRequest, ListAppVersionAppComponentsResponse>()
                            .withOperationName("ListAppVersionAppComponents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppVersionAppComponentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppVersionAppComponentsRequest));
            CompletableFuture<ListAppVersionAppComponentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     * @return A Java Future containing the result of the ListAppVersionResourceMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppVersionResourceMappingsResponse> listAppVersionResourceMappings(
            ListAppVersionResourceMappingsRequest listAppVersionResourceMappingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionResourceMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionResourceMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppVersionResourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppVersionResourceMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppVersionResourceMappingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionResourceMappingsRequest, ListAppVersionResourceMappingsResponse>()
                            .withOperationName("ListAppVersionResourceMappings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppVersionResourceMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppVersionResourceMappingsRequest));
            CompletableFuture<ListAppVersionResourceMappingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the resources in an Resilience Hub application.
     * </p>
     *
     * @param listAppVersionResourcesRequest
     * @return A Java Future containing the result of the ListAppVersionResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppVersionResourcesResponse> listAppVersionResources(
            ListAppVersionResourcesRequest listAppVersionResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppVersionResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppVersionResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionResourcesRequest, ListAppVersionResourcesResponse>()
                            .withOperationName("ListAppVersionResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppVersionResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppVersionResourcesRequest));
            CompletableFuture<ListAppVersionResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     *
     * @param listAppVersionsRequest
     * @return A Java Future containing the result of the ListAppVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppVersionsResponse> listAppVersions(ListAppVersionsRequest listAppVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAppVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionsRequest, ListAppVersionsResponse>()
                            .withOperationName("ListAppVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAppVersionsRequest));
            CompletableFuture<ListAppVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     * <note>
     * <p>
     * You can filter applications using only one filter at a time or without using any filter. If you try to filter
     * applications using multiple filters, you will get the following error:
     * </p>
     * <p>
     * <code>An error occurred (ValidationException) when calling the ListApps operation: Only one filter is supported for this operation.</code>
     * </p>
     * </note>
     *
     * @param listAppsRequest
     * @return A Java Future containing the result of the ListApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAppsResponse> listApps(ListAppsRequest listAppsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAppsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAppsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAppsRequest, ListAppsResponse>().withOperationName("ListApps")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAppsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAppsRequest));
            CompletableFuture<ListAppsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     * @return A Java Future containing the result of the ListRecommendationTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecommendationTemplatesResponse> listRecommendationTemplates(
            ListRecommendationTemplatesRequest listRecommendationTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecommendationTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendationTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommendationTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecommendationTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecommendationTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecommendationTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecommendationTemplatesRequest, ListRecommendationTemplatesResponse>()
                            .withOperationName("ListRecommendationTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRecommendationTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRecommendationTemplatesRequest));
            CompletableFuture<ListRecommendationTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     * @return A Java Future containing the result of the ListResiliencyPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResiliencyPoliciesResponse> listResiliencyPolicies(
            ListResiliencyPoliciesRequest listResiliencyPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResiliencyPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResiliencyPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResiliencyPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResiliencyPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResiliencyPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResiliencyPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResiliencyPoliciesRequest, ListResiliencyPoliciesResponse>()
                            .withOperationName("ListResiliencyPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResiliencyPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResiliencyPoliciesRequest));
            CompletableFuture<ListResiliencyPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resource grouping recommendations suggested by Resilience Hub for your application.
     * </p>
     *
     * @param listResourceGroupingRecommendationsRequest
     * @return A Java Future containing the result of the ListResourceGroupingRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListResourceGroupingRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResourceGroupingRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceGroupingRecommendationsResponse> listResourceGroupingRecommendations(
            ListResourceGroupingRecommendationsRequest listResourceGroupingRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceGroupingRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourceGroupingRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceGroupingRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceGroupingRecommendationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListResourceGroupingRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceGroupingRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceGroupingRecommendationsRequest, ListResourceGroupingRecommendationsResponse>()
                            .withOperationName("ListResourceGroupingRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceGroupingRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceGroupingRecommendationsRequest));
            CompletableFuture<ListResourceGroupingRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     *
     * @param listSopRecommendationsRequest
     * @return A Java Future containing the result of the ListSopRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSopRecommendationsResponse> listSopRecommendations(
            ListSopRecommendationsRequest listSopRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSopRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSopRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSopRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSopRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSopRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSopRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSopRecommendationsRequest, ListSopRecommendationsResponse>()
                            .withOperationName("ListSopRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSopRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSopRecommendationsRequest));
            CompletableFuture<ListSopRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     * @return A Java Future containing the result of the ListSuggestedResiliencyPolicies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSuggestedResiliencyPoliciesResponse> listSuggestedResiliencyPolicies(
            ListSuggestedResiliencyPoliciesRequest listSuggestedResiliencyPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSuggestedResiliencyPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSuggestedResiliencyPoliciesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSuggestedResiliencyPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSuggestedResiliencyPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSuggestedResiliencyPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSuggestedResiliencyPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSuggestedResiliencyPoliciesRequest, ListSuggestedResiliencyPoliciesResponse>()
                            .withOperationName("ListSuggestedResiliencyPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSuggestedResiliencyPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSuggestedResiliencyPoliciesRequest));
            CompletableFuture<ListSuggestedResiliencyPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags for your resources in your Resilience Hub applications.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     *
     * @param listTestRecommendationsRequest
     * @return A Java Future containing the result of the ListTestRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTestRecommendationsResponse> listTestRecommendations(
            ListTestRecommendationsRequest listTestRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTestRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTestRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTestRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTestRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTestRecommendationsRequest, ListTestRecommendationsResponse>()
                            .withOperationName("ListTestRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTestRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTestRecommendationsRequest));
            CompletableFuture<ListTestRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     * @return A Java Future containing the result of the ListUnsupportedAppVersionResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUnsupportedAppVersionResourcesResponse> listUnsupportedAppVersionResources(
            ListUnsupportedAppVersionResourcesRequest listUnsupportedAppVersionResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUnsupportedAppVersionResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listUnsupportedAppVersionResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUnsupportedAppVersionResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUnsupportedAppVersionResourcesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListUnsupportedAppVersionResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUnsupportedAppVersionResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUnsupportedAppVersionResourcesRequest, ListUnsupportedAppVersionResourcesResponse>()
                            .withOperationName("ListUnsupportedAppVersionResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUnsupportedAppVersionResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUnsupportedAppVersionResourcesRequest));
            CompletableFuture<ListUnsupportedAppVersionResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Publishes a new version of a specific Resilience Hub application.
     * </p>
     *
     * @param publishAppVersionRequest
     * @return A Java Future containing the result of the PublishAppVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.PublishAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PublishAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PublishAppVersionResponse> publishAppVersion(PublishAppVersionRequest publishAppVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(publishAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishAppVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishAppVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PublishAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PublishAppVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PublishAppVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PublishAppVersionRequest, PublishAppVersionResponse>()
                            .withOperationName("PublishAppVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PublishAppVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(publishAppVersionRequest));
            CompletableFuture<PublishAppVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates the app template for an Resilience Hub application draft version.
     * </p>
     *
     * @param putDraftAppVersionTemplateRequest
     * @return A Java Future containing the result of the PutDraftAppVersionTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.PutDraftAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PutDraftAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutDraftAppVersionTemplateResponse> putDraftAppVersionTemplate(
            PutDraftAppVersionTemplateRequest putDraftAppVersionTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDraftAppVersionTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDraftAppVersionTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDraftAppVersionTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDraftAppVersionTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutDraftAppVersionTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDraftAppVersionTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDraftAppVersionTemplateRequest, PutDraftAppVersionTemplateResponse>()
                            .withOperationName("PutDraftAppVersionTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDraftAppVersionTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putDraftAppVersionTemplateRequest));
            CompletableFuture<PutDraftAppVersionTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Rejects resource grouping recommendations.
     * </p>
     *
     * @param rejectResourceGroupingRecommendationsRequest
     * @return A Java Future containing the result of the RejectResourceGroupingRecommendations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.RejectResourceGroupingRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RejectResourceGroupingRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RejectResourceGroupingRecommendationsResponse> rejectResourceGroupingRecommendations(
            RejectResourceGroupingRecommendationsRequest rejectResourceGroupingRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectResourceGroupingRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                rejectResourceGroupingRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectResourceGroupingRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectResourceGroupingRecommendationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RejectResourceGroupingRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectResourceGroupingRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectResourceGroupingRecommendationsRequest, RejectResourceGroupingRecommendationsResponse>()
                            .withOperationName("RejectResourceGroupingRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RejectResourceGroupingRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectResourceGroupingRecommendationsRequest));
            CompletableFuture<RejectResourceGroupingRecommendationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes resource mappings from a draft application version.
     * </p>
     *
     * @param removeDraftAppVersionResourceMappingsRequest
     * @return A Java Future containing the result of the RemoveDraftAppVersionResourceMappings operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.RemoveDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RemoveDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveDraftAppVersionResourceMappingsResponse> removeDraftAppVersionResourceMappings(
            RemoveDraftAppVersionResourceMappingsRequest removeDraftAppVersionResourceMappingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeDraftAppVersionResourceMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeDraftAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveDraftAppVersionResourceMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveDraftAppVersionResourceMappingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RemoveDraftAppVersionResourceMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveDraftAppVersionResourceMappingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveDraftAppVersionResourceMappingsRequest, RemoveDraftAppVersionResourceMappingsResponse>()
                            .withOperationName("RemoveDraftAppVersionResourceMappings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveDraftAppVersionResourceMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeDraftAppVersionResourceMappingsRequest));
            CompletableFuture<RemoveDraftAppVersionResourceMappingsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resolves the resources for an application version.
     * </p>
     *
     * @param resolveAppVersionResourcesRequest
     * @return A Java Future containing the result of the ResolveAppVersionResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.ResolveAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ResolveAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResolveAppVersionResourcesResponse> resolveAppVersionResources(
            ResolveAppVersionResourcesRequest resolveAppVersionResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resolveAppVersionResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resolveAppVersionResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResolveAppVersionResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResolveAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResolveAppVersionResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResolveAppVersionResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResolveAppVersionResourcesRequest, ResolveAppVersionResourcesResponse>()
                            .withOperationName("ResolveAppVersionResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResolveAppVersionResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resolveAppVersionResourcesRequest));
            CompletableFuture<ResolveAppVersionResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new application assessment for an application.
     * </p>
     *
     * @param startAppAssessmentRequest
     * @return A Java Future containing the result of the StartAppAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.StartAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAppAssessmentResponse> startAppAssessment(StartAppAssessmentRequest startAppAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAppAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAppAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAppAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAppAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAppAssessmentRequest, StartAppAssessmentResponse>()
                            .withOperationName("StartAppAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartAppAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startAppAssessmentRequest));
            CompletableFuture<StartAppAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts grouping recommendation task.
     * </p>
     *
     * @param startResourceGroupingRecommendationTaskRequest
     * @return A Java Future containing the result of the StartResourceGroupingRecommendationTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.StartResourceGroupingRecommendationTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartResourceGroupingRecommendationTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartResourceGroupingRecommendationTaskResponse> startResourceGroupingRecommendationTask(
            StartResourceGroupingRecommendationTaskRequest startResourceGroupingRecommendationTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startResourceGroupingRecommendationTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startResourceGroupingRecommendationTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartResourceGroupingRecommendationTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartResourceGroupingRecommendationTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartResourceGroupingRecommendationTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartResourceGroupingRecommendationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartResourceGroupingRecommendationTaskRequest, StartResourceGroupingRecommendationTaskResponse>()
                            .withOperationName("StartResourceGroupingRecommendationTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartResourceGroupingRecommendationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startResourceGroupingRecommendationTaskRequest));
            CompletableFuture<StartResourceGroupingRecommendationTaskResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     *
     * @param updateAppRequest
     * @return A Java Future containing the result of the UpdateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.UpdateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAppResponse> updateApp(UpdateAppRequest updateAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAppRequest, UpdateAppResponse>().withOperationName("UpdateApp")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAppRequest));
            CompletableFuture<UpdateAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Resilience Hub application version.
     * </p>
     * <note>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this information for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </note>
     *
     * @param updateAppVersionRequest
     * @return A Java Future containing the result of the UpdateAppVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.UpdateAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAppVersionResponse> updateAppVersion(UpdateAppVersionRequest updateAppVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAppVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAppVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAppVersionRequest, UpdateAppVersionResponse>()
                            .withOperationName("UpdateAppVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAppVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAppVersionRequest));
            CompletableFuture<UpdateAppVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Application Component in the Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this Application Component for running
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </note>
     *
     * @param updateAppVersionAppComponentRequest
     * @return A Java Future containing the result of the UpdateAppVersionAppComponent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.UpdateAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAppVersionAppComponentResponse> updateAppVersionAppComponent(
            UpdateAppVersionAppComponentRequest updateAppVersionAppComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppVersionAppComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppVersionAppComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAppVersionAppComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAppVersionAppComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAppVersionAppComponentRequest, UpdateAppVersionAppComponentResponse>()
                            .withOperationName("UpdateAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAppVersionAppComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAppVersionAppComponentRequest));
            CompletableFuture<UpdateAppVersionAppComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the resource details in the Resilience Hub application.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * This action has no effect outside Resilience Hub.
     * </p>
     * </li>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this resource for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * To update application version with new <code>physicalResourceID</code>, you must call
     * <code>ResolveAppVersionResources</code> API.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateAppVersionResourceRequest
     * @return A Java Future containing the result of the UpdateAppVersionResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ServiceQuotaExceededException This exception occurs when you have exceeded your service quota. To
     *         perform the requested action, remove some of the relevant resources, or use Service Quotas to request a
     *         service quota increase.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.UpdateAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAppVersionResourceResponse> updateAppVersionResource(
            UpdateAppVersionResourceRequest updateAppVersionResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppVersionResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAppVersionResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAppVersionResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAppVersionResourceRequest, UpdateAppVersionResourceResponse>()
                            .withOperationName("UpdateAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAppVersionResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAppVersionResourceRequest));
            CompletableFuture<UpdateAppVersionResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a resiliency policy.
     * </p>
     * <note>
     * <p>
     * Resilience Hub allows you to provide a value of zero for <code>rtoInSecs</code> and <code>rpoInSecs</code> of
     * your resiliency policy. But, while assessing your application, the lowest possible assessment result is near
     * zero. Hence, if you provide value zero for <code>rtoInSecs</code> and <code>rpoInSecs</code>, the estimated
     * workload RTO and estimated workload RPO result will be near zero and the <b>Compliance status</b> for your
     * application will be set to <b>Policy breached</b>.
     * </p>
     * </note>
     *
     * @param updateResiliencyPolicyRequest
     * @return A Java Future containing the result of the UpdateResiliencyPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Resilience Hub
     *         service.</li>
     *         <li>ResourceNotFoundException This exception occurs when the specified resource could not be found.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful write is detected.
     *         This generally occurs when the previous write did not have time to propagate to the host serving the
     *         current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>ThrottlingException This exception occurs when you have exceeded the limit on the number of requests
     *         per second.</li>
     *         <li>ValidationException This exception occurs when a request is not valid.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResiliencehubException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ResiliencehubAsyncClient.UpdateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResiliencyPolicyResponse> updateResiliencyPolicy(
            UpdateResiliencyPolicyRequest updateResiliencyPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResiliencyPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResiliencyPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResiliencyPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResiliencyPolicyRequest, UpdateResiliencyPolicyResponse>()
                            .withOperationName("UpdateResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResiliencyPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResiliencyPolicyRequest));
            CompletableFuture<UpdateResiliencyPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ResiliencehubServiceClientConfiguration serviceClientConfiguration() {
        return new ResiliencehubServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ResiliencehubException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ResiliencehubServiceClientConfigurationBuilder serviceConfigBuilder = new ResiliencehubServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
