/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the resource that will be grouped in the recommended Application Component (AppComponent).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupingResource implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupingResource.Builder, GroupingResource> {
    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField
            .<LogicalResourceId> builder(MarshallingType.SDK_POJO).memberName("logicalResourceId")
            .getter(getter(GroupingResource::logicalResourceId)).setter(setter(Builder::logicalResourceId))
            .constructor(LogicalResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()).build();

    private static final SdkField<PhysicalResourceId> PHYSICAL_RESOURCE_ID_FIELD = SdkField
            .<PhysicalResourceId> builder(MarshallingType.SDK_POJO).memberName("physicalResourceId")
            .getter(getter(GroupingResource::physicalResourceId)).setter(setter(Builder::physicalResourceId))
            .constructor(PhysicalResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(GroupingResource::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(GroupingResource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<String>> SOURCE_APP_COMPONENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceAppComponentIds")
            .getter(getter(GroupingResource::sourceAppComponentIds))
            .setter(setter(Builder::sourceAppComponentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAppComponentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_RESOURCE_ID_FIELD,
            PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD, SOURCE_APP_COMPONENT_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LogicalResourceId logicalResourceId;

    private final PhysicalResourceId physicalResourceId;

    private final String resourceName;

    private final String resourceType;

    private final List<String> sourceAppComponentIds;

    private GroupingResource(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.sourceAppComponentIds = builder.sourceAppComponentIds;
    }

    /**
     * <p>
     * Indicates the logical identifier of the resource.
     * </p>
     * 
     * @return Indicates the logical identifier of the resource.
     */
    public final LogicalResourceId logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * Indicates the physical identifier of the resource.
     * </p>
     * 
     * @return Indicates the physical identifier of the resource.
     */
    public final PhysicalResourceId physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * Indicates the resource name.
     * </p>
     * 
     * @return Indicates the resource name.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * Indicates the resource type.
     * </p>
     * 
     * @return Indicates the resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAppComponentIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceAppComponentIds() {
        return sourceAppComponentIds != null && !(sourceAppComponentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the identifier of the source AppComponents in which the resources were previously grouped into.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAppComponentIds} method.
     * </p>
     * 
     * @return Indicates the identifier of the source AppComponents in which the resources were previously grouped into.
     */
    public final List<String> sourceAppComponentIds() {
        return sourceAppComponentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAppComponentIds() ? sourceAppComponentIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingResource)) {
            return false;
        }
        GroupingResource other = (GroupingResource) obj;
        return Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceName(), other.resourceName()) && Objects.equals(resourceType(), other.resourceType())
                && hasSourceAppComponentIds() == other.hasSourceAppComponentIds()
                && Objects.equals(sourceAppComponentIds(), other.sourceAppComponentIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupingResource").add("LogicalResourceId", logicalResourceId())
                .add("PhysicalResourceId", physicalResourceId()).add("ResourceName", resourceName())
                .add("ResourceType", resourceType())
                .add("SourceAppComponentIds", hasSourceAppComponentIds() ? sourceAppComponentIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "physicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "sourceAppComponentIds":
            return Optional.ofNullable(clazz.cast(sourceAppComponentIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupingResource, T> g) {
        return obj -> g.apply((GroupingResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupingResource> {
        /**
         * <p>
         * Indicates the logical identifier of the resource.
         * </p>
         * 
         * @param logicalResourceId
         *        Indicates the logical identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(LogicalResourceId logicalResourceId);

        /**
         * <p>
         * Indicates the logical identifier of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogicalResourceId.Builder} avoiding the
         * need to create one manually via {@link LogicalResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogicalResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #logicalResourceId(LogicalResourceId)}.
         * 
         * @param logicalResourceId
         *        a consumer that will call methods on {@link LogicalResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicalResourceId(LogicalResourceId)
         */
        default Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return logicalResourceId(LogicalResourceId.builder().applyMutation(logicalResourceId).build());
        }

        /**
         * <p>
         * Indicates the physical identifier of the resource.
         * </p>
         * 
         * @param physicalResourceId
         *        Indicates the physical identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(PhysicalResourceId physicalResourceId);

        /**
         * <p>
         * Indicates the physical identifier of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalResourceId.Builder} avoiding the
         * need to create one manually via {@link PhysicalResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #physicalResourceId(PhysicalResourceId)}.
         * 
         * @param physicalResourceId
         *        a consumer that will call methods on {@link PhysicalResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalResourceId(PhysicalResourceId)
         */
        default Builder physicalResourceId(Consumer<PhysicalResourceId.Builder> physicalResourceId) {
            return physicalResourceId(PhysicalResourceId.builder().applyMutation(physicalResourceId).build());
        }

        /**
         * <p>
         * Indicates the resource name.
         * </p>
         * 
         * @param resourceName
         *        Indicates the resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * Indicates the resource type.
         * </p>
         * 
         * @param resourceType
         *        Indicates the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Indicates the identifier of the source AppComponents in which the resources were previously grouped into.
         * </p>
         * 
         * @param sourceAppComponentIds
         *        Indicates the identifier of the source AppComponents in which the resources were previously grouped
         *        into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAppComponentIds(Collection<String> sourceAppComponentIds);

        /**
         * <p>
         * Indicates the identifier of the source AppComponents in which the resources were previously grouped into.
         * </p>
         * 
         * @param sourceAppComponentIds
         *        Indicates the identifier of the source AppComponents in which the resources were previously grouped
         *        into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAppComponentIds(String... sourceAppComponentIds);
    }

    static final class BuilderImpl implements Builder {
        private LogicalResourceId logicalResourceId;

        private PhysicalResourceId physicalResourceId;

        private String resourceName;

        private String resourceType;

        private List<String> sourceAppComponentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupingResource model) {
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
            sourceAppComponentIds(model.sourceAppComponentIds);
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return logicalResourceId != null ? logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final PhysicalResourceId.Builder getPhysicalResourceId() {
            return physicalResourceId != null ? physicalResourceId.toBuilder() : null;
        }

        public final void setPhysicalResourceId(PhysicalResourceId.BuilderImpl physicalResourceId) {
            this.physicalResourceId = physicalResourceId != null ? physicalResourceId.build() : null;
        }

        @Override
        public final Builder physicalResourceId(PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getSourceAppComponentIds() {
            if (sourceAppComponentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceAppComponentIds;
        }

        public final void setSourceAppComponentIds(Collection<String> sourceAppComponentIds) {
            this.sourceAppComponentIds = String255ListCopier.copy(sourceAppComponentIds);
        }

        @Override
        public final Builder sourceAppComponentIds(Collection<String> sourceAppComponentIds) {
            this.sourceAppComponentIds = String255ListCopier.copy(sourceAppComponentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAppComponentIds(String... sourceAppComponentIds) {
            sourceAppComponentIds(Arrays.asList(sourceAppComponentIds));
            return this;
        }

        @Override
        public GroupingResource build() {
            return new GroupingResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
