/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its
 * resources, and running an assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionModel implements SdkPojo, Serializable, ToCopyableBuilder<PermissionModel.Builder, PermissionModel> {
    private static final SdkField<List<String>> CROSS_ACCOUNT_ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("crossAccountRoleArns")
            .getter(getter(PermissionModel::crossAccountRoleArns))
            .setter(setter(Builder::crossAccountRoleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRoleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INVOKER_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invokerRoleName").getter(getter(PermissionModel::invokerRoleName))
            .setter(setter(Builder::invokerRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokerRoleName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PermissionModel::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_ROLE_ARNS_FIELD,
            INVOKER_ROLE_NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> crossAccountRoleArns;

    private final String invokerRoleName;

    private final String type;

    private PermissionModel(BuilderImpl builder) {
        this.crossAccountRoleArns = builder.crossAccountRoleArns;
        this.invokerRoleName = builder.invokerRoleName;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossAccountRoleArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCrossAccountRoleArns() {
        return crossAccountRoleArns != null && !(crossAccountRoleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used for
     * querying purposes while importing resources and assessing your application.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * These ARNs are required only when your resources are in other accounts and you have different role name in these
     * accounts. Else, the invoker role name will be used in the other accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role in the
     * primary account.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossAccountRoleArns} method.
     * </p>
     * 
     * @return Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used for
     *         querying purposes while importing resources and assessing your application.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         These ARNs are required only when your resources are in other accounts and you have different role name
     *         in these accounts. Else, the invoker role name will be used in the other accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role in
     *         the primary account.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final List<String> crossAccountRoleArns() {
        return crossAccountRoleArns;
    }

    /**
     * <p>
     * Existing Amazon Web Services IAM role name in the primary Amazon Web Services account that will be assumed by
     * Resilience Hub Service Principle to obtain a read-only access to your application resources while running an
     * assessment.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have <code>iam:passRole</code> permission for this role while creating or updating the application.
     * </p>
     * </li>
     * <li>
     * <p>
     * Currently, <code>invokerRoleName</code> accepts only <code>[A-Za-z0-9_+=,.@-]</code> characters.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return Existing Amazon Web Services IAM role name in the primary Amazon Web Services account that will be
     *         assumed by Resilience Hub Service Principle to obtain a read-only access to your application resources
     *         while running an assessment.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         You must have <code>iam:passRole</code> permission for this role while creating or updating the
     *         application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Currently, <code>invokerRoleName</code> accepts only <code>[A-Za-z0-9_+=,.@-]</code> characters.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String invokerRoleName() {
        return invokerRoleName;
    }

    /**
     * <p>
     * Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing role in
     * your Amazon Web Services account, or by using the credentials of the current IAM user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PermissionModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing
     *         role in your Amazon Web Services account, or by using the credentials of the current IAM user.
     * @see PermissionModelType
     */
    public final PermissionModelType type() {
        return PermissionModelType.fromValue(type);
    }

    /**
     * <p>
     * Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing role in
     * your Amazon Web Services account, or by using the credentials of the current IAM user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PermissionModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing
     *         role in your Amazon Web Services account, or by using the credentials of the current IAM user.
     * @see PermissionModelType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossAccountRoleArns() ? crossAccountRoleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(invokerRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionModel)) {
            return false;
        }
        PermissionModel other = (PermissionModel) obj;
        return hasCrossAccountRoleArns() == other.hasCrossAccountRoleArns()
                && Objects.equals(crossAccountRoleArns(), other.crossAccountRoleArns())
                && Objects.equals(invokerRoleName(), other.invokerRoleName())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionModel")
                .add("CrossAccountRoleArns", hasCrossAccountRoleArns() ? crossAccountRoleArns() : null)
                .add("InvokerRoleName", invokerRoleName()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crossAccountRoleArns":
            return Optional.ofNullable(clazz.cast(crossAccountRoleArns()));
        case "invokerRoleName":
            return Optional.ofNullable(clazz.cast(invokerRoleName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionModel, T> g) {
        return obj -> g.apply((PermissionModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionModel> {
        /**
         * <p>
         * Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used for
         * querying purposes while importing resources and assessing your application.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * These ARNs are required only when your resources are in other accounts and you have different role name in
         * these accounts. Else, the invoker role name will be used in the other accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role in the
         * primary account.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param crossAccountRoleArns
         *        Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used
         *        for querying purposes while importing resources and assessing your application.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        These ARNs are required only when your resources are in other accounts and you have different role
         *        name in these accounts. Else, the invoker role name will be used in the other accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role
         *        in the primary account.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRoleArns(Collection<String> crossAccountRoleArns);

        /**
         * <p>
         * Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used for
         * querying purposes while importing resources and assessing your application.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * These ARNs are required only when your resources are in other accounts and you have different role name in
         * these accounts. Else, the invoker role name will be used in the other accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role in the
         * primary account.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param crossAccountRoleArns
         *        Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used
         *        for querying purposes while importing resources and assessing your application.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        These ARNs are required only when your resources are in other accounts and you have different role
         *        name in these accounts. Else, the invoker role name will be used in the other accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role
         *        in the primary account.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRoleArns(String... crossAccountRoleArns);

        /**
         * <p>
         * Existing Amazon Web Services IAM role name in the primary Amazon Web Services account that will be assumed by
         * Resilience Hub Service Principle to obtain a read-only access to your application resources while running an
         * assessment.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * You must have <code>iam:passRole</code> permission for this role while creating or updating the application.
         * </p>
         * </li>
         * <li>
         * <p>
         * Currently, <code>invokerRoleName</code> accepts only <code>[A-Za-z0-9_+=,.@-]</code> characters.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param invokerRoleName
         *        Existing Amazon Web Services IAM role name in the primary Amazon Web Services account that will be
         *        assumed by Resilience Hub Service Principle to obtain a read-only access to your application resources
         *        while running an assessment.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        You must have <code>iam:passRole</code> permission for this role while creating or updating the
         *        application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Currently, <code>invokerRoleName</code> accepts only <code>[A-Za-z0-9_+=,.@-]</code> characters.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokerRoleName(String invokerRoleName);

        /**
         * <p>
         * Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing role
         * in your Amazon Web Services account, or by using the credentials of the current IAM user.
         * </p>
         * 
         * @param type
         *        Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing
         *        role in your Amazon Web Services account, or by using the credentials of the current IAM user.
         * @see PermissionModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionModelType
         */
        Builder type(String type);

        /**
         * <p>
         * Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing role
         * in your Amazon Web Services account, or by using the credentials of the current IAM user.
         * </p>
         * 
         * @param type
         *        Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing
         *        role in your Amazon Web Services account, or by using the credentials of the current IAM user.
         * @see PermissionModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionModelType
         */
        Builder type(PermissionModelType type);
    }

    static final class BuilderImpl implements Builder {
        private List<String> crossAccountRoleArns = DefaultSdkAutoConstructList.getInstance();

        private String invokerRoleName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionModel model) {
            crossAccountRoleArns(model.crossAccountRoleArns);
            invokerRoleName(model.invokerRoleName);
            type(model.type);
        }

        public final Collection<String> getCrossAccountRoleArns() {
            if (crossAccountRoleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return crossAccountRoleArns;
        }

        public final void setCrossAccountRoleArns(Collection<String> crossAccountRoleArns) {
            this.crossAccountRoleArns = IamRoleArnListCopier.copy(crossAccountRoleArns);
        }

        @Override
        public final Builder crossAccountRoleArns(Collection<String> crossAccountRoleArns) {
            this.crossAccountRoleArns = IamRoleArnListCopier.copy(crossAccountRoleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountRoleArns(String... crossAccountRoleArns) {
            crossAccountRoleArns(Arrays.asList(crossAccountRoleArns));
            return this;
        }

        public final String getInvokerRoleName() {
            return invokerRoleName;
        }

        public final void setInvokerRoleName(String invokerRoleName) {
            this.invokerRoleName = invokerRoleName;
        }

        @Override
        public final Builder invokerRoleName(String invokerRoleName) {
            this.invokerRoleName = invokerRoleName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PermissionModelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public PermissionModel build() {
            return new PermissionModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
