/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the rejected grouping recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectGroupingRecommendationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<RejectGroupingRecommendationEntry.Builder, RejectGroupingRecommendationEntry> {
    private static final SdkField<String> GROUPING_RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupingRecommendationId").getter(getter(RejectGroupingRecommendationEntry::groupingRecommendationId))
            .setter(setter(Builder::groupingRecommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingRecommendationId").build())
            .build();

    private static final SdkField<String> REJECTION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rejectionReason").getter(getter(RejectGroupingRecommendationEntry::rejectionReasonAsString))
            .setter(setter(Builder::rejectionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GROUPING_RECOMMENDATION_ID_FIELD, REJECTION_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupingRecommendationId;

    private final String rejectionReason;

    private RejectGroupingRecommendationEntry(BuilderImpl builder) {
        this.groupingRecommendationId = builder.groupingRecommendationId;
        this.rejectionReason = builder.rejectionReason;
    }

    /**
     * <p>
     * Indicates the identifier of the grouping recommendation.
     * </p>
     * 
     * @return Indicates the identifier of the grouping recommendation.
     */
    public final String groupingRecommendationId() {
        return groupingRecommendationId;
    }

    /**
     * <p>
     * Indicates the reason you had selected while rejecting a grouping recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rejectionReason}
     * will return {@link GroupingRecommendationRejectionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rejectionReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason you had selected while rejecting a grouping recommendation.
     * @see GroupingRecommendationRejectionReason
     */
    public final GroupingRecommendationRejectionReason rejectionReason() {
        return GroupingRecommendationRejectionReason.fromValue(rejectionReason);
    }

    /**
     * <p>
     * Indicates the reason you had selected while rejecting a grouping recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rejectionReason}
     * will return {@link GroupingRecommendationRejectionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rejectionReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason you had selected while rejecting a grouping recommendation.
     * @see GroupingRecommendationRejectionReason
     */
    public final String rejectionReasonAsString() {
        return rejectionReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupingRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectGroupingRecommendationEntry)) {
            return false;
        }
        RejectGroupingRecommendationEntry other = (RejectGroupingRecommendationEntry) obj;
        return Objects.equals(groupingRecommendationId(), other.groupingRecommendationId())
                && Objects.equals(rejectionReasonAsString(), other.rejectionReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectGroupingRecommendationEntry").add("GroupingRecommendationId", groupingRecommendationId())
                .add("RejectionReason", rejectionReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupingRecommendationId":
            return Optional.ofNullable(clazz.cast(groupingRecommendationId()));
        case "rejectionReason":
            return Optional.ofNullable(clazz.cast(rejectionReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectGroupingRecommendationEntry, T> g) {
        return obj -> g.apply((RejectGroupingRecommendationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RejectGroupingRecommendationEntry> {
        /**
         * <p>
         * Indicates the identifier of the grouping recommendation.
         * </p>
         * 
         * @param groupingRecommendationId
         *        Indicates the identifier of the grouping recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingRecommendationId(String groupingRecommendationId);

        /**
         * <p>
         * Indicates the reason you had selected while rejecting a grouping recommendation.
         * </p>
         * 
         * @param rejectionReason
         *        Indicates the reason you had selected while rejecting a grouping recommendation.
         * @see GroupingRecommendationRejectionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingRecommendationRejectionReason
         */
        Builder rejectionReason(String rejectionReason);

        /**
         * <p>
         * Indicates the reason you had selected while rejecting a grouping recommendation.
         * </p>
         * 
         * @param rejectionReason
         *        Indicates the reason you had selected while rejecting a grouping recommendation.
         * @see GroupingRecommendationRejectionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingRecommendationRejectionReason
         */
        Builder rejectionReason(GroupingRecommendationRejectionReason rejectionReason);
    }

    static final class BuilderImpl implements Builder {
        private String groupingRecommendationId;

        private String rejectionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectGroupingRecommendationEntry model) {
            groupingRecommendationId(model.groupingRecommendationId);
            rejectionReason(model.rejectionReason);
        }

        public final String getGroupingRecommendationId() {
            return groupingRecommendationId;
        }

        public final void setGroupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
        }

        @Override
        public final Builder groupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
            return this;
        }

        public final String getRejectionReason() {
            return rejectionReason;
        }

        public final void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @Override
        public final Builder rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        @Override
        public final Builder rejectionReason(GroupingRecommendationRejectionReason rejectionReason) {
            this.rejectionReason(rejectionReason == null ? null : rejectionReason.toString());
            return this;
        }

        @Override
        public RejectGroupingRecommendationEntry build() {
            return new RejectGroupingRecommendationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
