/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.resiliencehub.model.PermissionModelType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionModel> {
    private static final SdkField<List<String>> CROSS_ACCOUNT_ROLE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crossAccountRoleArns").getter(PermissionModel.getter(PermissionModel::crossAccountRoleArns)).setter(PermissionModel.setter(Builder::crossAccountRoleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRoleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INVOKER_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invokerRoleName").getter(PermissionModel.getter(PermissionModel::invokerRoleName)).setter(PermissionModel.setter(Builder::invokerRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokerRoleName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(PermissionModel.getter(PermissionModel::typeAsString)).setter(PermissionModel.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_ROLE_ARNS_FIELD, INVOKER_ROLE_NAME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("crossAccountRoleArns", CROSS_ACCOUNT_ROLE_ARNS_FIELD);
            this.put("invokerRoleName", INVOKER_ROLE_NAME_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> crossAccountRoleArns;
    private final String invokerRoleName;
    private final String type;

    private PermissionModel(BuilderImpl builder) {
        this.crossAccountRoleArns = builder.crossAccountRoleArns;
        this.invokerRoleName = builder.invokerRoleName;
        this.type = builder.type;
    }

    public final boolean hasCrossAccountRoleArns() {
        return this.crossAccountRoleArns != null && !(this.crossAccountRoleArns instanceof SdkAutoConstructList);
    }

    public final List<String> crossAccountRoleArns() {
        return this.crossAccountRoleArns;
    }

    public final String invokerRoleName() {
        return this.invokerRoleName;
    }

    public final PermissionModelType type() {
        return PermissionModelType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossAccountRoleArns() ? this.crossAccountRoleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.invokerRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionModel)) {
            return false;
        }
        PermissionModel other = (PermissionModel)obj;
        return this.hasCrossAccountRoleArns() == other.hasCrossAccountRoleArns() && Objects.equals(this.crossAccountRoleArns(), other.crossAccountRoleArns()) && Objects.equals(this.invokerRoleName(), other.invokerRoleName()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionModel").add("CrossAccountRoleArns", this.hasCrossAccountRoleArns() ? this.crossAccountRoleArns() : null).add("InvokerRoleName", (Object)this.invokerRoleName()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crossAccountRoleArns": {
                return Optional.ofNullable(clazz.cast(this.crossAccountRoleArns()));
            }
            case "invokerRoleName": {
                return Optional.ofNullable(clazz.cast(this.invokerRoleName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PermissionModel, T> g) {
        return obj -> g.apply((PermissionModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> crossAccountRoleArns = DefaultSdkAutoConstructList.getInstance();
        private String invokerRoleName;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionModel model) {
            this.crossAccountRoleArns(model.crossAccountRoleArns);
            this.invokerRoleName(model.invokerRoleName);
            this.type(model.type);
        }

        public final Collection<String> getCrossAccountRoleArns() {
            if (this.crossAccountRoleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crossAccountRoleArns;
        }

        public final void setCrossAccountRoleArns(Collection<String> crossAccountRoleArns) {
            this.crossAccountRoleArns = IamRoleArnListCopier.copy(crossAccountRoleArns);
        }

        @Override
        public final Builder crossAccountRoleArns(Collection<String> crossAccountRoleArns) {
            this.crossAccountRoleArns = IamRoleArnListCopier.copy(crossAccountRoleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountRoleArns(String ... crossAccountRoleArns) {
            this.crossAccountRoleArns(Arrays.asList(crossAccountRoleArns));
            return this;
        }

        public final String getInvokerRoleName() {
            return this.invokerRoleName;
        }

        public final void setInvokerRoleName(String invokerRoleName) {
            this.invokerRoleName = invokerRoleName;
        }

        @Override
        public final Builder invokerRoleName(String invokerRoleName) {
            this.invokerRoleName = invokerRoleName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PermissionModelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public PermissionModel build() {
            return new PermissionModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionModel> {
        public Builder crossAccountRoleArns(Collection<String> var1);

        public Builder crossAccountRoleArns(String ... var1);

        public Builder invokerRoleName(String var1);

        public Builder type(String var1);

        public Builder type(PermissionModelType var1);
    }
}

