/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ArnListCopier;
import software.amazon.awssdk.services.resiliencehub.model.EksSource;
import software.amazon.awssdk.services.resiliencehub.model.EksSourceListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResourceImportStrategyType;
import software.amazon.awssdk.services.resiliencehub.model.TerraformSource;
import software.amazon.awssdk.services.resiliencehub.model.TerraformSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportResourcesToDraftAppVersionRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, ImportResourcesToDraftAppVersionRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ImportResourcesToDraftAppVersionRequest.getter(ImportResourcesToDraftAppVersionRequest::appArn)).setter(ImportResourcesToDraftAppVersionRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<EksSource>> EKS_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eksSources").getter(ImportResourcesToDraftAppVersionRequest.getter(ImportResourcesToDraftAppVersionRequest::eksSources)).setter(ImportResourcesToDraftAppVersionRequest.setter(Builder::eksSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMPORT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importStrategy").getter(ImportResourcesToDraftAppVersionRequest.getter(ImportResourcesToDraftAppVersionRequest::importStrategyAsString)).setter(ImportResourcesToDraftAppVersionRequest.setter(Builder::importStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStrategy").build()}).build();
    private static final SdkField<List<String>> SOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceArns").getter(ImportResourcesToDraftAppVersionRequest.getter(ImportResourcesToDraftAppVersionRequest::sourceArns)).setter(ImportResourcesToDraftAppVersionRequest.setter(Builder::sourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TerraformSource>> TERRAFORM_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("terraformSources").getter(ImportResourcesToDraftAppVersionRequest.getter(ImportResourcesToDraftAppVersionRequest::terraformSources)).setter(ImportResourcesToDraftAppVersionRequest.setter(Builder::terraformSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TerraformSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, EKS_SOURCES_FIELD, IMPORT_STRATEGY_FIELD, SOURCE_ARNS_FIELD, TERRAFORM_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("eksSources", EKS_SOURCES_FIELD);
            this.put("importStrategy", IMPORT_STRATEGY_FIELD);
            this.put("sourceArns", SOURCE_ARNS_FIELD);
            this.put("terraformSources", TERRAFORM_SOURCES_FIELD);
        }
    });
    private final String appArn;
    private final List<EksSource> eksSources;
    private final String importStrategy;
    private final List<String> sourceArns;
    private final List<TerraformSource> terraformSources;

    private ImportResourcesToDraftAppVersionRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.eksSources = builder.eksSources;
        this.importStrategy = builder.importStrategy;
        this.sourceArns = builder.sourceArns;
        this.terraformSources = builder.terraformSources;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasEksSources() {
        return this.eksSources != null && !(this.eksSources instanceof SdkAutoConstructList);
    }

    public final List<EksSource> eksSources() {
        return this.eksSources;
    }

    public final ResourceImportStrategyType importStrategy() {
        return ResourceImportStrategyType.fromValue(this.importStrategy);
    }

    public final String importStrategyAsString() {
        return this.importStrategy;
    }

    public final boolean hasSourceArns() {
        return this.sourceArns != null && !(this.sourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> sourceArns() {
        return this.sourceArns;
    }

    public final boolean hasTerraformSources() {
        return this.terraformSources != null && !(this.terraformSources instanceof SdkAutoConstructList);
    }

    public final List<TerraformSource> terraformSources() {
        return this.terraformSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEksSources() ? this.eksSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.importStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceArns() ? this.sourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerraformSources() ? this.terraformSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourcesToDraftAppVersionRequest)) {
            return false;
        }
        ImportResourcesToDraftAppVersionRequest other = (ImportResourcesToDraftAppVersionRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && this.hasEksSources() == other.hasEksSources() && Objects.equals(this.eksSources(), other.eksSources()) && Objects.equals(this.importStrategyAsString(), other.importStrategyAsString()) && this.hasSourceArns() == other.hasSourceArns() && Objects.equals(this.sourceArns(), other.sourceArns()) && this.hasTerraformSources() == other.hasTerraformSources() && Objects.equals(this.terraformSources(), other.terraformSources());
    }

    public final String toString() {
        return ToString.builder((String)"ImportResourcesToDraftAppVersionRequest").add("AppArn", (Object)this.appArn()).add("EksSources", this.hasEksSources() ? this.eksSources() : null).add("ImportStrategy", (Object)this.importStrategyAsString()).add("SourceArns", this.hasSourceArns() ? this.sourceArns() : null).add("TerraformSources", this.hasTerraformSources() ? this.terraformSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "eksSources": {
                return Optional.ofNullable(clazz.cast(this.eksSources()));
            }
            case "importStrategy": {
                return Optional.ofNullable(clazz.cast(this.importStrategyAsString()));
            }
            case "sourceArns": {
                return Optional.ofNullable(clazz.cast(this.sourceArns()));
            }
            case "terraformSources": {
                return Optional.ofNullable(clazz.cast(this.terraformSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportResourcesToDraftAppVersionRequest, T> g) {
        return obj -> g.apply((ImportResourcesToDraftAppVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private List<EksSource> eksSources = DefaultSdkAutoConstructList.getInstance();
        private String importStrategy;
        private List<String> sourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<TerraformSource> terraformSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourcesToDraftAppVersionRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.eksSources(model.eksSources);
            this.importStrategy(model.importStrategy);
            this.sourceArns(model.sourceArns);
            this.terraformSources(model.terraformSources);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<EksSource.Builder> getEksSources() {
            List<EksSource.Builder> result = EksSourceListCopier.copyToBuilder(this.eksSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEksSources(Collection<EksSource.BuilderImpl> eksSources) {
            this.eksSources = EksSourceListCopier.copyFromBuilder(eksSources);
        }

        @Override
        public final Builder eksSources(Collection<EksSource> eksSources) {
            this.eksSources = EksSourceListCopier.copy(eksSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksSources(EksSource ... eksSources) {
            this.eksSources(Arrays.asList(eksSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksSources(Consumer<EksSource.Builder> ... eksSources) {
            this.eksSources(Stream.of(eksSources).map(c -> (EksSource)((EksSource.Builder)EksSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImportStrategy() {
            return this.importStrategy;
        }

        public final void setImportStrategy(String importStrategy) {
            this.importStrategy = importStrategy;
        }

        @Override
        public final Builder importStrategy(String importStrategy) {
            this.importStrategy = importStrategy;
            return this;
        }

        @Override
        public final Builder importStrategy(ResourceImportStrategyType importStrategy) {
            this.importStrategy(importStrategy == null ? null : importStrategy.toString());
            return this;
        }

        public final Collection<String> getSourceArns() {
            if (this.sourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceArns;
        }

        public final void setSourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
        }

        @Override
        public final Builder sourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceArns(String ... sourceArns) {
            this.sourceArns(Arrays.asList(sourceArns));
            return this;
        }

        public final List<TerraformSource.Builder> getTerraformSources() {
            List<TerraformSource.Builder> result = TerraformSourceListCopier.copyToBuilder(this.terraformSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerraformSources(Collection<TerraformSource.BuilderImpl> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copyFromBuilder(terraformSources);
        }

        @Override
        public final Builder terraformSources(Collection<TerraformSource> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copy(terraformSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(TerraformSource ... terraformSources) {
            this.terraformSources(Arrays.asList(terraformSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(Consumer<TerraformSource.Builder> ... terraformSources) {
            this.terraformSources(Stream.of(terraformSources).map(c -> (TerraformSource)((TerraformSource.Builder)TerraformSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportResourcesToDraftAppVersionRequest build() {
            return new ImportResourcesToDraftAppVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportResourcesToDraftAppVersionRequest> {
        public Builder appArn(String var1);

        public Builder eksSources(Collection<EksSource> var1);

        public Builder eksSources(EksSource ... var1);

        public Builder eksSources(Consumer<EksSource.Builder> ... var1);

        public Builder importStrategy(String var1);

        public Builder importStrategy(ResourceImportStrategyType var1);

        public Builder sourceArns(Collection<String> var1);

        public Builder sourceArns(String ... var1);

        public Builder terraformSources(Collection<TerraformSource> var1);

        public Builder terraformSources(TerraformSource ... var1);

        public Builder terraformSources(Consumer<TerraformSource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

