/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.FailedGroupingRecommendationEntriesCopier;
import software.amazon.awssdk.services.resiliencehub.model.FailedGroupingRecommendationEntry;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectResourceGroupingRecommendationsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, RejectResourceGroupingRecommendationsResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(RejectResourceGroupingRecommendationsResponse.getter(RejectResourceGroupingRecommendationsResponse::appArn)).setter(RejectResourceGroupingRecommendationsResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<FailedGroupingRecommendationEntry>> FAILED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedEntries").getter(RejectResourceGroupingRecommendationsResponse.getter(RejectResourceGroupingRecommendationsResponse::failedEntries)).setter(RejectResourceGroupingRecommendationsResponse.setter(Builder::failedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedGroupingRecommendationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, FAILED_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("failedEntries", FAILED_ENTRIES_FIELD);
        }
    });
    private final String appArn;
    private final List<FailedGroupingRecommendationEntry> failedEntries;

    private RejectResourceGroupingRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.failedEntries = builder.failedEntries;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasFailedEntries() {
        return this.failedEntries != null && !(this.failedEntries instanceof SdkAutoConstructList);
    }

    public final List<FailedGroupingRecommendationEntry> failedEntries() {
        return this.failedEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedEntries() ? this.failedEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectResourceGroupingRecommendationsResponse)) {
            return false;
        }
        RejectResourceGroupingRecommendationsResponse other = (RejectResourceGroupingRecommendationsResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && this.hasFailedEntries() == other.hasFailedEntries() && Objects.equals(this.failedEntries(), other.failedEntries());
    }

    public final String toString() {
        return ToString.builder((String)"RejectResourceGroupingRecommendationsResponse").add("AppArn", (Object)this.appArn()).add("FailedEntries", this.hasFailedEntries() ? this.failedEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "failedEntries": {
                return Optional.ofNullable(clazz.cast(this.failedEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RejectResourceGroupingRecommendationsResponse, T> g) {
        return obj -> g.apply((RejectResourceGroupingRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private List<FailedGroupingRecommendationEntry> failedEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RejectResourceGroupingRecommendationsResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.failedEntries(model.failedEntries);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<FailedGroupingRecommendationEntry.Builder> getFailedEntries() {
            List<FailedGroupingRecommendationEntry.Builder> result = FailedGroupingRecommendationEntriesCopier.copyToBuilder(this.failedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedEntries(Collection<FailedGroupingRecommendationEntry.BuilderImpl> failedEntries) {
            this.failedEntries = FailedGroupingRecommendationEntriesCopier.copyFromBuilder(failedEntries);
        }

        @Override
        public final Builder failedEntries(Collection<FailedGroupingRecommendationEntry> failedEntries) {
            this.failedEntries = FailedGroupingRecommendationEntriesCopier.copy(failedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(FailedGroupingRecommendationEntry ... failedEntries) {
            this.failedEntries(Arrays.asList(failedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(Consumer<FailedGroupingRecommendationEntry.Builder> ... failedEntries) {
            this.failedEntries(Stream.of(failedEntries).map(c -> (FailedGroupingRecommendationEntry)((FailedGroupingRecommendationEntry.Builder)FailedGroupingRecommendationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RejectResourceGroupingRecommendationsResponse build() {
            return new RejectResourceGroupingRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RejectResourceGroupingRecommendationsResponse> {
        public Builder appArn(String var1);

        public Builder failedEntries(Collection<FailedGroupingRecommendationEntry> var1);

        public Builder failedEntries(FailedGroupingRecommendationEntry ... var1);

        public Builder failedEntries(Consumer<FailedGroupingRecommendationEntry.Builder> ... var1);
    }
}

