/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyPoliciesCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSuggestedResiliencyPoliciesResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListSuggestedResiliencyPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSuggestedResiliencyPoliciesResponse.getter(ListSuggestedResiliencyPoliciesResponse::nextToken)).setter(ListSuggestedResiliencyPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResiliencyPolicy>> RESILIENCY_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resiliencyPolicies").getter(ListSuggestedResiliencyPoliciesResponse.getter(ListSuggestedResiliencyPoliciesResponse::resiliencyPolicies)).setter(ListSuggestedResiliencyPoliciesResponse.setter(Builder::resiliencyPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResiliencyPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESILIENCY_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("resiliencyPolicies", RESILIENCY_POLICIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<ResiliencyPolicy> resiliencyPolicies;

    private ListSuggestedResiliencyPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resiliencyPolicies = builder.resiliencyPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResiliencyPolicies() {
        return this.resiliencyPolicies != null && !(this.resiliencyPolicies instanceof SdkAutoConstructList);
    }

    public final List<ResiliencyPolicy> resiliencyPolicies() {
        return this.resiliencyPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResiliencyPolicies() ? this.resiliencyPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuggestedResiliencyPoliciesResponse)) {
            return false;
        }
        ListSuggestedResiliencyPoliciesResponse other = (ListSuggestedResiliencyPoliciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResiliencyPolicies() == other.hasResiliencyPolicies() && Objects.equals(this.resiliencyPolicies(), other.resiliencyPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"ListSuggestedResiliencyPoliciesResponse").add("NextToken", (Object)this.nextToken()).add("ResiliencyPolicies", this.hasResiliencyPolicies() ? this.resiliencyPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resiliencyPolicies": {
                return Optional.ofNullable(clazz.cast(this.resiliencyPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSuggestedResiliencyPoliciesResponse, T> g) {
        return obj -> g.apply((ListSuggestedResiliencyPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResiliencyPolicy> resiliencyPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuggestedResiliencyPoliciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resiliencyPolicies(model.resiliencyPolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResiliencyPolicy.Builder> getResiliencyPolicies() {
            List<ResiliencyPolicy.Builder> result = ResiliencyPoliciesCopier.copyToBuilder(this.resiliencyPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResiliencyPolicies(Collection<ResiliencyPolicy.BuilderImpl> resiliencyPolicies) {
            this.resiliencyPolicies = ResiliencyPoliciesCopier.copyFromBuilder(resiliencyPolicies);
        }

        @Override
        public final Builder resiliencyPolicies(Collection<ResiliencyPolicy> resiliencyPolicies) {
            this.resiliencyPolicies = ResiliencyPoliciesCopier.copy(resiliencyPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resiliencyPolicies(ResiliencyPolicy ... resiliencyPolicies) {
            this.resiliencyPolicies(Arrays.asList(resiliencyPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resiliencyPolicies(Consumer<ResiliencyPolicy.Builder> ... resiliencyPolicies) {
            this.resiliencyPolicies(Stream.of(resiliencyPolicies).map(c -> (ResiliencyPolicy)((ResiliencyPolicy.Builder)ResiliencyPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSuggestedResiliencyPoliciesResponse build() {
            return new ListSuggestedResiliencyPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSuggestedResiliencyPoliciesResponse> {
        public Builder nextToken(String var1);

        public Builder resiliencyPolicies(Collection<ResiliencyPolicy> var1);

        public Builder resiliencyPolicies(ResiliencyPolicy ... var1);

        public Builder resiliencyPolicies(Consumer<ResiliencyPolicy.Builder> ... var1);
    }
}

