/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AdditionalInfoMapCopier;
import software.amazon.awssdk.services.resiliencehub.model.AppComponentNameListCopier;
import software.amazon.awssdk.services.resiliencehub.model.LogicalResourceId;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppVersionResourceRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, CreateAppVersionResourceRequest> {
    private static final SdkField<Map<String, List<String>>> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalInfo").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::additionalInfo)).setter(CreateAppVersionResourceRequest.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::appArn)).setter(CreateAppVersionResourceRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<String>> APP_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appComponents").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::appComponents)).setter(CreateAppVersionResourceRequest.setter(Builder::appComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::awsAccountId)).setter(CreateAppVersionResourceRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::awsRegion)).setter(CreateAppVersionResourceRequest.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::clientToken)).setter(CreateAppVersionResourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicalResourceId").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::logicalResourceId)).setter(CreateAppVersionResourceRequest.setter(Builder::logicalResourceId)).constructor(LogicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("physicalResourceId").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::physicalResourceId)).setter(CreateAppVersionResourceRequest.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::resourceName)).setter(CreateAppVersionResourceRequest.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(CreateAppVersionResourceRequest.getter(CreateAppVersionResourceRequest::resourceType)).setter(CreateAppVersionResourceRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_INFO_FIELD, APP_ARN_FIELD, APP_COMPONENTS_FIELD, AWS_ACCOUNT_ID_FIELD, AWS_REGION_FIELD, CLIENT_TOKEN_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAppVersionResourceRequest.memberNameToFieldInitializer();
    private final Map<String, List<String>> additionalInfo;
    private final String appArn;
    private final List<String> appComponents;
    private final String awsAccountId;
    private final String awsRegion;
    private final String clientToken;
    private final LogicalResourceId logicalResourceId;
    private final String physicalResourceId;
    private final String resourceName;
    private final String resourceType;

    private CreateAppVersionResourceRequest(BuilderImpl builder) {
        super(builder);
        this.additionalInfo = builder.additionalInfo;
        this.appArn = builder.appArn;
        this.appComponents = builder.appComponents;
        this.awsAccountId = builder.awsAccountId;
        this.awsRegion = builder.awsRegion;
        this.clientToken = builder.clientToken;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
    }

    public final boolean hasAdditionalInfo() {
        return this.additionalInfo != null && !(this.additionalInfo instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> additionalInfo() {
        return this.additionalInfo;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasAppComponents() {
        return this.appComponents != null && !(this.appComponents instanceof SdkAutoConstructList);
    }

    public final List<String> appComponents() {
        return this.appComponents;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final LogicalResourceId logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInfo() ? this.additionalInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppComponents() ? this.appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppVersionResourceRequest)) {
            return false;
        }
        CreateAppVersionResourceRequest other = (CreateAppVersionResourceRequest)((Object)obj);
        return this.hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.appArn(), other.appArn()) && this.hasAppComponents() == other.hasAppComponents() && Objects.equals(this.appComponents(), other.appComponents()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppVersionResourceRequest").add("AdditionalInfo", this.hasAdditionalInfo() ? this.additionalInfo() : null).add("AppArn", (Object)this.appArn()).add("AppComponents", this.hasAppComponents() ? this.appComponents() : null).add("AwsAccountId", (Object)this.awsAccountId()).add("AwsRegion", (Object)this.awsRegion()).add("ClientToken", (Object)this.clientToken()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appComponents": {
                return Optional.ofNullable(clazz.cast(this.appComponents()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "logicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "physicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalInfo", ADDITIONAL_INFO_FIELD);
        map.put("appArn", APP_ARN_FIELD);
        map.put("appComponents", APP_COMPONENTS_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("logicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("physicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("resourceName", RESOURCE_NAME_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppVersionResourceRequest, T> g) {
        return obj -> g.apply((CreateAppVersionResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private Map<String, List<String>> additionalInfo = DefaultSdkAutoConstructMap.getInstance();
        private String appArn;
        private List<String> appComponents = DefaultSdkAutoConstructList.getInstance();
        private String awsAccountId;
        private String awsRegion;
        private String clientToken;
        private LogicalResourceId logicalResourceId;
        private String physicalResourceId;
        private String resourceName;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppVersionResourceRequest model) {
            super(model);
            this.additionalInfo(model.additionalInfo);
            this.appArn(model.appArn);
            this.appComponents(model.appComponents);
            this.awsAccountId(model.awsAccountId);
            this.awsRegion(model.awsRegion);
            this.clientToken(model.clientToken);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
        }

        public final Map<String, ? extends Collection<String>> getAdditionalInfo() {
            if (this.additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
            return this;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final Collection<String> getAppComponents() {
            if (this.appComponents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appComponents;
        }

        public final void setAppComponents(Collection<String> appComponents) {
            this.appComponents = AppComponentNameListCopier.copy(appComponents);
        }

        @Override
        public final Builder appComponents(Collection<String> appComponents) {
            this.appComponents = AppComponentNameListCopier.copy(appComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(String ... appComponents) {
            this.appComponents(Arrays.asList(appComponents));
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return this.logicalResourceId != null ? this.logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppVersionResourceRequest build() {
            return new CreateAppVersionResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppVersionResourceRequest> {
        public Builder additionalInfo(Map<String, ? extends Collection<String>> var1);

        public Builder appArn(String var1);

        public Builder appComponents(Collection<String> var1);

        public Builder appComponents(String ... var1);

        public Builder awsAccountId(String var1);

        public Builder awsRegion(String var1);

        public Builder clientToken(String var1);

        public Builder logicalResourceId(LogicalResourceId var1);

        default public Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return this.logicalResourceId((LogicalResourceId)((LogicalResourceId.Builder)LogicalResourceId.builder().applyMutation(logicalResourceId)).build());
        }

        public Builder physicalResourceId(String var1);

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

