/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the Amazon CloudWatch alarm detected while running an assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alarm implements SdkPojo, Serializable, ToCopyableBuilder<Alarm.Builder, Alarm> {
    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmArn").getter(getter(Alarm::alarmArn)).setter(setter(Builder::alarmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmArn").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(Alarm::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ALARM_ARN_FIELD, SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alarmArn;

    private final String source;

    private Alarm(BuilderImpl builder) {
        this.alarmArn = builder.alarmArn;
        this.source = builder.source;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
     */
    public final String alarmArn() {
        return alarmArn;
    }

    /**
     * <p>
     * Indicates the source of the Amazon CloudWatch alarm. That is, it indicates if the alarm was created using
     * Resilience Hub recommendation (<code>AwsResilienceHub</code>), or if you had created the alarm in Amazon
     * CloudWatch (<code>Customer</code>).
     * </p>
     * 
     * @return Indicates the source of the Amazon CloudWatch alarm. That is, it indicates if the alarm was created using
     *         Resilience Hub recommendation (<code>AwsResilienceHub</code>), or if you had created the alarm in Amazon
     *         CloudWatch (<code>Customer</code>).
     */
    public final String source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm) obj;
        return Objects.equals(alarmArn(), other.alarmArn()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Alarm").add("AlarmArn", alarmArn()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmArn":
            return Optional.ofNullable(clazz.cast(alarmArn()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alarmArn", ALARM_ARN_FIELD);
        map.put("source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Alarm, T> g) {
        return obj -> g.apply((Alarm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alarm> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
         * </p>
         * 
         * @param alarmArn
         *        Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmArn(String alarmArn);

        /**
         * <p>
         * Indicates the source of the Amazon CloudWatch alarm. That is, it indicates if the alarm was created using
         * Resilience Hub recommendation (<code>AwsResilienceHub</code>), or if you had created the alarm in Amazon
         * CloudWatch (<code>Customer</code>).
         * </p>
         * 
         * @param source
         *        Indicates the source of the Amazon CloudWatch alarm. That is, it indicates if the alarm was created
         *        using Resilience Hub recommendation (<code>AwsResilienceHub</code>), or if you had created the alarm
         *        in Amazon CloudWatch (<code>Customer</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);
    }

    static final class BuilderImpl implements Builder {
        private String alarmArn;

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            alarmArn(model.alarmArn);
            source(model.source);
        }

        public final String getAlarmArn() {
            return alarmArn;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public Alarm build() {
            return new Alarm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
