/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Version of an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AppVersionSummary.Builder, AppVersionSummary> {
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(AppVersionSummary::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(AppVersionSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Long> IDENTIFIER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("identifier")
            .getter(getter(AppVersionSummary::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(AppVersionSummary::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_VERSION_FIELD,
            CREATION_TIME_FIELD, IDENTIFIER_FIELD, VERSION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appVersion;

    private final Instant creationTime;

    private final Long identifier;

    private final String versionName;

    private AppVersionSummary(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.creationTime = builder.creationTime;
        this.identifier = builder.identifier;
        this.versionName = builder.versionName;
    }

    /**
     * <p>
     * Version of an application.
     * </p>
     * 
     * @return Version of an application.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * Creation time of the application version.
     * </p>
     * 
     * @return Creation time of the application version.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Identifier of the application version.
     * </p>
     * 
     * @return Identifier of the application version.
     */
    public final Long identifier() {
        return identifier;
    }

    /**
     * <p>
     * Name of the application version.
     * </p>
     * 
     * @return Name of the application version.
     */
    public final String versionName() {
        return versionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppVersionSummary)) {
            return false;
        }
        AppVersionSummary other = (AppVersionSummary) obj;
        return Objects.equals(appVersion(), other.appVersion()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(versionName(), other.versionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppVersionSummary").add("AppVersion", appVersion()).add("CreationTime", creationTime())
                .add("Identifier", identifier()).add("VersionName", versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppVersionSummary, T> g) {
        return obj -> g.apply((AppVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppVersionSummary> {
        /**
         * <p>
         * Version of an application.
         * </p>
         * 
         * @param appVersion
         *        Version of an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * Creation time of the application version.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Identifier of the application version.
         * </p>
         * 
         * @param identifier
         *        Identifier of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(Long identifier);

        /**
         * <p>
         * Name of the application version.
         * </p>
         * 
         * @param versionName
         *        Name of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);
    }

    static final class BuilderImpl implements Builder {
        private String appVersion;

        private Instant creationTime;

        private Long identifier;

        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppVersionSummary model) {
            appVersion(model.appVersion);
            creationTime(model.creationTime);
            identifier(model.identifier);
            versionName(model.versionName);
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(Long identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(Long identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        @Override
        public AppVersionSummary build() {
            return new AppVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
