/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of operational recommendations that were successfully included or excluded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateRecommendationStatusSuccessfulEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateRecommendationStatusSuccessfulEntry.Builder, BatchUpdateRecommendationStatusSuccessfulEntry> {
    private static final SdkField<String> APP_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentId").getter(getter(BatchUpdateRecommendationStatusSuccessfulEntry::appComponentId))
            .setter(setter(Builder::appComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentId").build()).build();

    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(BatchUpdateRecommendationStatusSuccessfulEntry::entryId))
            .setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<String> EXCLUDE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("excludeReason").getter(getter(BatchUpdateRecommendationStatusSuccessfulEntry::excludeReasonAsString))
            .setter(setter(Builder::excludeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeReason").build()).build();

    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excluded").getter(getter(BatchUpdateRecommendationStatusSuccessfulEntry::excluded))
            .setter(setter(Builder::excluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()).build();

    private static final SdkField<UpdateRecommendationStatusItem> ITEM_FIELD = SdkField
            .<UpdateRecommendationStatusItem> builder(MarshallingType.SDK_POJO).memberName("item")
            .getter(getter(BatchUpdateRecommendationStatusSuccessfulEntry::item)).setter(setter(Builder::item))
            .constructor(UpdateRecommendationStatusItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build()).build();

    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceId").getter(getter(BatchUpdateRecommendationStatusSuccessfulEntry::referenceId))
            .setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_ID_FIELD,
            ENTRY_ID_FIELD, EXCLUDE_REASON_FIELD, EXCLUDED_FIELD, ITEM_FIELD, REFERENCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appComponentId;

    private final String entryId;

    private final String excludeReason;

    private final Boolean excluded;

    private final UpdateRecommendationStatusItem item;

    private final String referenceId;

    private BatchUpdateRecommendationStatusSuccessfulEntry(BuilderImpl builder) {
        this.appComponentId = builder.appComponentId;
        this.entryId = builder.entryId;
        this.excludeReason = builder.excludeReason;
        this.excluded = builder.excluded;
        this.item = builder.item;
        this.referenceId = builder.referenceId;
    }

    /**
     * <p>
     * Indicates the identifier of an AppComponent.
     * </p>
     * 
     * @return Indicates the identifier of an AppComponent.
     */
    public final String appComponentId() {
        return appComponentId;
    }

    /**
     * <p>
     * An identifier for an entry in this batch that is used to communicate the result.
     * </p>
     * <note>
     * <p>
     * The <code>entryId</code>s of a batch request need to be unique within a request.
     * </p>
     * </note>
     * 
     * @return An identifier for an entry in this batch that is used to communicate the result.</p> <note>
     *         <p>
     *         The <code>entryId</code>s of a batch request need to be unique within a request.
     *         </p>
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * <p>
     * Indicates the reason for excluding an operational recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #excludeReason}
     * will return {@link ExcludeRecommendationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excludeReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for excluding an operational recommendation.
     * @see ExcludeRecommendationReason
     */
    public final ExcludeRecommendationReason excludeReason() {
        return ExcludeRecommendationReason.fromValue(excludeReason);
    }

    /**
     * <p>
     * Indicates the reason for excluding an operational recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #excludeReason}
     * will return {@link ExcludeRecommendationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excludeReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for excluding an operational recommendation.
     * @see ExcludeRecommendationReason
     */
    public final String excludeReasonAsString() {
        return excludeReason;
    }

    /**
     * <p>
     * Indicates if the operational recommendation was successfully excluded.
     * </p>
     * 
     * @return Indicates if the operational recommendation was successfully excluded.
     */
    public final Boolean excluded() {
        return excluded;
    }

    /**
     * <p>
     * The operational recommendation item.
     * </p>
     * 
     * @return The operational recommendation item.
     */
    public final UpdateRecommendationStatusItem item() {
        return item;
    }

    /**
     * <p>
     * Reference identifier of the operational recommendation.
     * </p>
     * 
     * @return Reference identifier of the operational recommendation.
     */
    public final String referenceId() {
        return referenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(excludeReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(excluded());
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRecommendationStatusSuccessfulEntry)) {
            return false;
        }
        BatchUpdateRecommendationStatusSuccessfulEntry other = (BatchUpdateRecommendationStatusSuccessfulEntry) obj;
        return Objects.equals(appComponentId(), other.appComponentId()) && Objects.equals(entryId(), other.entryId())
                && Objects.equals(excludeReasonAsString(), other.excludeReasonAsString())
                && Objects.equals(excluded(), other.excluded()) && Objects.equals(item(), other.item())
                && Objects.equals(referenceId(), other.referenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateRecommendationStatusSuccessfulEntry").add("AppComponentId", appComponentId())
                .add("EntryId", entryId()).add("ExcludeReason", excludeReasonAsString()).add("Excluded", excluded())
                .add("Item", item()).add("ReferenceId", referenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appComponentId":
            return Optional.ofNullable(clazz.cast(appComponentId()));
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "excludeReason":
            return Optional.ofNullable(clazz.cast(excludeReasonAsString()));
        case "excluded":
            return Optional.ofNullable(clazz.cast(excluded()));
        case "item":
            return Optional.ofNullable(clazz.cast(item()));
        case "referenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appComponentId", APP_COMPONENT_ID_FIELD);
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("excludeReason", EXCLUDE_REASON_FIELD);
        map.put("excluded", EXCLUDED_FIELD);
        map.put("item", ITEM_FIELD);
        map.put("referenceId", REFERENCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRecommendationStatusSuccessfulEntry, T> g) {
        return obj -> g.apply((BatchUpdateRecommendationStatusSuccessfulEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateRecommendationStatusSuccessfulEntry> {
        /**
         * <p>
         * Indicates the identifier of an AppComponent.
         * </p>
         * 
         * @param appComponentId
         *        Indicates the identifier of an AppComponent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentId(String appComponentId);

        /**
         * <p>
         * An identifier for an entry in this batch that is used to communicate the result.
         * </p>
         * <note>
         * <p>
         * The <code>entryId</code>s of a batch request need to be unique within a request.
         * </p>
         * </note>
         * 
         * @param entryId
         *        An identifier for an entry in this batch that is used to communicate the result.</p> <note>
         *        <p>
         *        The <code>entryId</code>s of a batch request need to be unique within a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * Indicates the reason for excluding an operational recommendation.
         * </p>
         * 
         * @param excludeReason
         *        Indicates the reason for excluding an operational recommendation.
         * @see ExcludeRecommendationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcludeRecommendationReason
         */
        Builder excludeReason(String excludeReason);

        /**
         * <p>
         * Indicates the reason for excluding an operational recommendation.
         * </p>
         * 
         * @param excludeReason
         *        Indicates the reason for excluding an operational recommendation.
         * @see ExcludeRecommendationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcludeRecommendationReason
         */
        Builder excludeReason(ExcludeRecommendationReason excludeReason);

        /**
         * <p>
         * Indicates if the operational recommendation was successfully excluded.
         * </p>
         * 
         * @param excluded
         *        Indicates if the operational recommendation was successfully excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excluded(Boolean excluded);

        /**
         * <p>
         * The operational recommendation item.
         * </p>
         * 
         * @param item
         *        The operational recommendation item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(UpdateRecommendationStatusItem item);

        /**
         * <p>
         * The operational recommendation item.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateRecommendationStatusItem.Builder}
         * avoiding the need to create one manually via {@link UpdateRecommendationStatusItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateRecommendationStatusItem.Builder#build()} is called
         * immediately and its result is passed to {@link #item(UpdateRecommendationStatusItem)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link UpdateRecommendationStatusItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(UpdateRecommendationStatusItem)
         */
        default Builder item(Consumer<UpdateRecommendationStatusItem.Builder> item) {
            return item(UpdateRecommendationStatusItem.builder().applyMutation(item).build());
        }

        /**
         * <p>
         * Reference identifier of the operational recommendation.
         * </p>
         * 
         * @param referenceId
         *        Reference identifier of the operational recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);
    }

    static final class BuilderImpl implements Builder {
        private String appComponentId;

        private String entryId;

        private String excludeReason;

        private Boolean excluded;

        private UpdateRecommendationStatusItem item;

        private String referenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRecommendationStatusSuccessfulEntry model) {
            appComponentId(model.appComponentId);
            entryId(model.entryId);
            excludeReason(model.excludeReason);
            excluded(model.excluded);
            item(model.item);
            referenceId(model.referenceId);
        }

        public final String getAppComponentId() {
            return appComponentId;
        }

        public final void setAppComponentId(String appComponentId) {
            this.appComponentId = appComponentId;
        }

        @Override
        public final Builder appComponentId(String appComponentId) {
            this.appComponentId = appComponentId;
            return this;
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getExcludeReason() {
            return excludeReason;
        }

        public final void setExcludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
        }

        @Override
        public final Builder excludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
            return this;
        }

        @Override
        public final Builder excludeReason(ExcludeRecommendationReason excludeReason) {
            this.excludeReason(excludeReason == null ? null : excludeReason.toString());
            return this;
        }

        public final Boolean getExcluded() {
            return excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final UpdateRecommendationStatusItem.Builder getItem() {
            return item != null ? item.toBuilder() : null;
        }

        public final void setItem(UpdateRecommendationStatusItem.BuilderImpl item) {
            this.item = item != null ? item.build() : null;
        }

        @Override
        public final Builder item(UpdateRecommendationStatusItem item) {
            this.item = item;
            return this;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public BatchUpdateRecommendationStatusSuccessfulEntry build() {
            return new BatchUpdateRecommendationStatusSuccessfulEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
