/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetricsExportResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<DescribeMetricsExportResponse.Builder, DescribeMetricsExportResponse> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(DescribeMetricsExportResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<S3Location> EXPORT_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("exportLocation").getter(getter(DescribeMetricsExportResponse::exportLocation))
            .setter(setter(Builder::exportLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportLocation").build()).build();

    private static final SdkField<String> METRICS_EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsExportId").getter(getter(DescribeMetricsExportResponse::metricsExportId))
            .setter(setter(Builder::metricsExportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsExportId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeMetricsExportResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            EXPORT_LOCATION_FIELD, METRICS_EXPORT_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String errorMessage;

    private final S3Location exportLocation;

    private final String metricsExportId;

    private final String status;

    private DescribeMetricsExportResponse(BuilderImpl builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.exportLocation = builder.exportLocation;
        this.metricsExportId = builder.metricsExportId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Explains the error that occurred while exporting the metrics.
     * </p>
     * 
     * @return Explains the error that occurred while exporting the metrics.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Specifies the name of the Amazon S3 bucket where the exported metrics is stored.
     * </p>
     * 
     * @return Specifies the name of the Amazon S3 bucket where the exported metrics is stored.
     */
    public final S3Location exportLocation() {
        return exportLocation;
    }

    /**
     * <p>
     * Identifier for the metrics export task.
     * </p>
     * 
     * @return Identifier for the metrics export task.
     */
    public final String metricsExportId() {
        return metricsExportId;
    }

    /**
     * <p>
     * Indicates the status of the metrics export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetricsExportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the metrics export task.
     * @see MetricsExportStatusType
     */
    public final MetricsExportStatusType status() {
        return MetricsExportStatusType.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the metrics export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetricsExportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the metrics export task.
     * @see MetricsExportStatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(exportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(metricsExportId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricsExportResponse)) {
            return false;
        }
        DescribeMetricsExportResponse other = (DescribeMetricsExportResponse) obj;
        return Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(exportLocation(), other.exportLocation())
                && Objects.equals(metricsExportId(), other.metricsExportId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetricsExportResponse").add("ErrorMessage", errorMessage())
                .add("ExportLocation", exportLocation()).add("MetricsExportId", metricsExportId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "exportLocation":
            return Optional.ofNullable(clazz.cast(exportLocation()));
        case "metricsExportId":
            return Optional.ofNullable(clazz.cast(metricsExportId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("exportLocation", EXPORT_LOCATION_FIELD);
        map.put("metricsExportId", METRICS_EXPORT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricsExportResponse, T> g) {
        return obj -> g.apply((DescribeMetricsExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetricsExportResponse> {
        /**
         * <p>
         * Explains the error that occurred while exporting the metrics.
         * </p>
         * 
         * @param errorMessage
         *        Explains the error that occurred while exporting the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Specifies the name of the Amazon S3 bucket where the exported metrics is stored.
         * </p>
         * 
         * @param exportLocation
         *        Specifies the name of the Amazon S3 bucket where the exported metrics is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportLocation(S3Location exportLocation);

        /**
         * <p>
         * Specifies the name of the Amazon S3 bucket where the exported metrics is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #exportLocation(S3Location)}.
         * 
         * @param exportLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportLocation(S3Location)
         */
        default Builder exportLocation(Consumer<S3Location.Builder> exportLocation) {
            return exportLocation(S3Location.builder().applyMutation(exportLocation).build());
        }

        /**
         * <p>
         * Identifier for the metrics export task.
         * </p>
         * 
         * @param metricsExportId
         *        Identifier for the metrics export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsExportId(String metricsExportId);

        /**
         * <p>
         * Indicates the status of the metrics export task.
         * </p>
         * 
         * @param status
         *        Indicates the status of the metrics export task.
         * @see MetricsExportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsExportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the metrics export task.
         * </p>
         * 
         * @param status
         *        Indicates the status of the metrics export task.
         * @see MetricsExportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsExportStatusType
         */
        Builder status(MetricsExportStatusType status);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String errorMessage;

        private S3Location exportLocation;

        private String metricsExportId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricsExportResponse model) {
            super(model);
            errorMessage(model.errorMessage);
            exportLocation(model.exportLocation);
            metricsExportId(model.metricsExportId);
            status(model.status);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final S3Location.Builder getExportLocation() {
            return exportLocation != null ? exportLocation.toBuilder() : null;
        }

        public final void setExportLocation(S3Location.BuilderImpl exportLocation) {
            this.exportLocation = exportLocation != null ? exportLocation.build() : null;
        }

        @Override
        public final Builder exportLocation(S3Location exportLocation) {
            this.exportLocation = exportLocation;
            return this;
        }

        public final String getMetricsExportId() {
            return metricsExportId;
        }

        public final void setMetricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
        }

        @Override
        public final Builder metricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetricsExportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeMetricsExportResponse build() {
            return new DescribeMetricsExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
