/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class DisruptionPolicyCopier {
    static Map<String, FailurePolicy> copy(Map<String, ? extends FailurePolicy> disruptionPolicyParam) {
        Map<String, FailurePolicy> map;
        if (disruptionPolicyParam == null || disruptionPolicyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, FailurePolicy> modifiableMap = new LinkedHashMap<>(disruptionPolicyParam.size());
            disruptionPolicyParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, FailurePolicy> copyFromBuilder(Map<String, ? extends FailurePolicy.Builder> disruptionPolicyParam) {
        Map<String, FailurePolicy> map;
        if (disruptionPolicyParam == null || disruptionPolicyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, FailurePolicy> modifiableMap = new LinkedHashMap<>(disruptionPolicyParam.size());
            disruptionPolicyParam.forEach((key, value) -> {
                FailurePolicy member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, FailurePolicy.Builder> copyToBuilder(Map<String, ? extends FailurePolicy> disruptionPolicyParam) {
        Map<String, FailurePolicy.Builder> map;
        if (disruptionPolicyParam == null || disruptionPolicyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, FailurePolicy.Builder> modifiableMap = new LinkedHashMap<>(disruptionPolicyParam.size());
            disruptionPolicyParam.forEach((key, value) -> {
                FailurePolicy.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, FailurePolicy> copyEnumToString(Map<DisruptionType, ? extends FailurePolicy> disruptionPolicyParam) {
        Map<String, FailurePolicy> map;
        if (disruptionPolicyParam == null || disruptionPolicyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, FailurePolicy> modifiableMap = new LinkedHashMap<>(disruptionPolicyParam.size());
            disruptionPolicyParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DisruptionType, FailurePolicy> copyStringToEnum(Map<String, ? extends FailurePolicy> disruptionPolicyParam) {
        Map<DisruptionType, FailurePolicy> map;
        if (disruptionPolicyParam == null || disruptionPolicyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DisruptionType, FailurePolicy> modifiableMap = new LinkedHashMap<>(disruptionPolicyParam.size());
            disruptionPolicyParam.forEach((key, value) -> {
                DisruptionType result = DisruptionType.fromValue(key);
                if (result != DisruptionType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
