/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input source of the namespace that is located on your Amazon Elastic Kubernetes Service cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksSourceClusterNamespace implements SdkPojo, Serializable,
        ToCopyableBuilder<EksSourceClusterNamespace.Builder, EksSourceClusterNamespace> {
    private static final SdkField<String> EKS_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eksClusterArn").getter(getter(EksSourceClusterNamespace::eksClusterArn))
            .setter(setter(Builder::eksClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterArn").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(EksSourceClusterNamespace::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_ARN_FIELD,
            NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eksClusterArn;

    private final String namespace;

    private EksSourceClusterNamespace(BuilderImpl builder) {
        this.eksClusterArn = builder.eksClusterArn;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN is: arn:
     * <code>aws</code>:eks:<code>region</code>:<code>account-id</code>:cluster/<code>cluster-name</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN is:
     *         arn:<code>aws</code>:eks:<code>region</code>:<code>account-id</code>:cluster/<code>cluster-name</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String eksClusterArn() {
        return eksClusterArn;
    }

    /**
     * <p>
     * Name of the namespace that is located on your Amazon Elastic Kubernetes Service cluster.
     * </p>
     * 
     * @return Name of the namespace that is located on your Amazon Elastic Kubernetes Service cluster.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksSourceClusterNamespace)) {
            return false;
        }
        EksSourceClusterNamespace other = (EksSourceClusterNamespace) obj;
        return Objects.equals(eksClusterArn(), other.eksClusterArn()) && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksSourceClusterNamespace").add("EksClusterArn", eksClusterArn()).add("Namespace", namespace())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eksClusterArn":
            return Optional.ofNullable(clazz.cast(eksClusterArn()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eksClusterArn", EKS_CLUSTER_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksSourceClusterNamespace, T> g) {
        return obj -> g.apply((EksSourceClusterNamespace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksSourceClusterNamespace> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN is: arn:
         * <code>aws</code>:eks:<code>region</code>:<code>account-id</code>:cluster/<code>cluster-name</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param eksClusterArn
         *        Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN
         *        is: arn:<code>aws</code>:eks:<code>region</code>:<code>account-id</code>:cluster/
         *        <code>cluster-name</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusterArn(String eksClusterArn);

        /**
         * <p>
         * Name of the namespace that is located on your Amazon Elastic Kubernetes Service cluster.
         * </p>
         * 
         * @param namespace
         *        Name of the namespace that is located on your Amazon Elastic Kubernetes Service cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private String eksClusterArn;

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(EksSourceClusterNamespace model) {
            eksClusterArn(model.eksClusterArn);
            namespace(model.namespace);
        }

        public final String getEksClusterArn() {
            return eksClusterArn;
        }

        public final void setEksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
        }

        @Override
        public final Builder eksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public EksSourceClusterNamespace build() {
            return new EksSourceClusterNamespace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
