/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the FIS experiment detected while running an assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Experiment implements SdkPojo, Serializable, ToCopyableBuilder<Experiment.Builder, Experiment> {
    private static final SdkField<String> EXPERIMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experimentArn").getter(getter(Experiment::experimentArn)).setter(setter(Builder::experimentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentArn").build()).build();

    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experimentTemplateId").getter(getter(Experiment::experimentTemplateId))
            .setter(setter(Builder::experimentTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplateId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ARN_FIELD,
            EXPERIMENT_TEMPLATE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String experimentArn;

    private final String experimentTemplateId;

    private Experiment(BuilderImpl builder) {
        this.experimentArn = builder.experimentArn;
        this.experimentTemplateId = builder.experimentTemplateId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the FIS experiment.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the FIS experiment.
     */
    public final String experimentArn() {
        return experimentArn;
    }

    /**
     * <p>
     * Identifier of the FIS experiment template.
     * </p>
     * 
     * @return Identifier of the FIS experiment template.
     */
    public final String experimentTemplateId() {
        return experimentTemplateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(experimentArn());
        hashCode = 31 * hashCode + Objects.hashCode(experimentTemplateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment) obj;
        return Objects.equals(experimentArn(), other.experimentArn())
                && Objects.equals(experimentTemplateId(), other.experimentTemplateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Experiment").add("ExperimentArn", experimentArn())
                .add("ExperimentTemplateId", experimentTemplateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "experimentArn":
            return Optional.ofNullable(clazz.cast(experimentArn()));
        case "experimentTemplateId":
            return Optional.ofNullable(clazz.cast(experimentTemplateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("experimentArn", EXPERIMENT_ARN_FIELD);
        map.put("experimentTemplateId", EXPERIMENT_TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Experiment, T> g) {
        return obj -> g.apply((Experiment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Experiment> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the FIS experiment.
         * </p>
         * 
         * @param experimentArn
         *        Amazon Resource Name (ARN) of the FIS experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentArn(String experimentArn);

        /**
         * <p>
         * Identifier of the FIS experiment template.
         * </p>
         * 
         * @param experimentTemplateId
         *        Identifier of the FIS experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentTemplateId(String experimentTemplateId);
    }

    static final class BuilderImpl implements Builder {
        private String experimentArn;

        private String experimentTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(Experiment model) {
            experimentArn(model.experimentArn);
            experimentTemplateId(model.experimentTemplateId);
        }

        public final String getExperimentArn() {
            return experimentArn;
        }

        public final void setExperimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
        }

        @Override
        public final Builder experimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
            return this;
        }

        public final String getExperimentTemplateId() {
            return experimentTemplateId;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        @Override
        public Experiment build() {
            return new Experiment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
