/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricsRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<ListMetricsRequest.Builder, ListMetricsRequest> {
    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField
            .<List<Condition>> builder(MarshallingType.LIST)
            .memberName("conditions")
            .getter(getter(ListMetricsRequest::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Condition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Condition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSource").getter(getter(ListMetricsRequest::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<List<Field>> FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(ListMetricsRequest::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListMetricsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMetricsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Sort>> SORTS_FIELD = SdkField
            .<List<Sort>> builder(MarshallingType.LIST)
            .memberName("sorts")
            .getter(getter(ListMetricsRequest::sorts))
            .setter(setter(Builder::sorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Sort> builder(MarshallingType.SDK_POJO)
                                            .constructor(Sort::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITIONS_FIELD,
            DATA_SOURCE_FIELD, FIELDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Condition> conditions;

    private final String dataSource;

    private final List<Field> fields;

    private final Integer maxResults;

    private final String nextToken;

    private final List<Sort> sorts;

    private ListMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.conditions = builder.conditions;
        this.dataSource = builder.dataSource;
        this.fields = builder.fields;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sorts = builder.sorts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the list of all the conditions that were applied on the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return Indicates the list of all the conditions that were applied on the metrics.
     */
    public final List<Condition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * Indicates the data source of the metrics.
     * </p>
     * 
     * @return Indicates the data source of the metrics.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the list of fields in the data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return Indicates the list of fields in the data source.
     */
    public final List<Field> fields() {
        return fields;
    }

    /**
     * <p>
     * Maximum number of results to include in the response. If more results exist than the specified
     * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * 
     * @return Maximum number of results to include in the response. If more results exist than the specified
     *         <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     *         retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Null, or the token from a previous call to get the next set of results.
     * </p>
     * 
     * @return Null, or the token from a previous call to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sorts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSorts() {
        return sorts != null && !(sorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) Indicates the order in which you want to sort the fields in the metrics. By default, the fields are
     * sorted in the ascending order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSorts} method.
     * </p>
     * 
     * @return (Optional) Indicates the order in which you want to sort the fields in the metrics. By default, the
     *         fields are sorted in the ascending order.
     */
    public final List<Sort> sorts() {
        return sorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSorts() ? sorts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsRequest)) {
            return false;
        }
        ListMetricsRequest other = (ListMetricsRequest) obj;
        return hasConditions() == other.hasConditions() && Objects.equals(conditions(), other.conditions())
                && Objects.equals(dataSource(), other.dataSource()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && hasSorts() == other.hasSorts()
                && Objects.equals(sorts(), other.sorts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricsRequest").add("Conditions", hasConditions() ? conditions() : null)
                .add("DataSource", dataSource()).add("Fields", hasFields() ? fields() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Sorts", hasSorts() ? sorts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sorts":
            return Optional.ofNullable(clazz.cast(sorts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conditions", CONDITIONS_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sorts", SORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetricsRequest, T> g) {
        return obj -> g.apply((ListMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMetricsRequest> {
        /**
         * <p>
         * Indicates the list of all the conditions that were applied on the metrics.
         * </p>
         * 
         * @param conditions
         *        Indicates the list of all the conditions that were applied on the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<Condition> conditions);

        /**
         * <p>
         * Indicates the list of all the conditions that were applied on the metrics.
         * </p>
         * 
         * @param conditions
         *        Indicates the list of all the conditions that were applied on the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Condition... conditions);

        /**
         * <p>
         * Indicates the list of all the conditions that were applied on the metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.Condition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.resiliencehub.model.Condition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.Condition.Builder#build()} is called immediately
         * and its result is passed to {@link #conditions(List<Condition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<Condition>)
         */
        Builder conditions(Consumer<Condition.Builder>... conditions);

        /**
         * <p>
         * Indicates the data source of the metrics.
         * </p>
         * 
         * @param dataSource
         *        Indicates the data source of the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * Indicates the list of fields in the data source.
         * </p>
         * 
         * @param fields
         *        Indicates the list of fields in the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<Field> fields);

        /**
         * <p>
         * Indicates the list of fields in the data source.
         * </p>
         * 
         * @param fields
         *        Indicates the list of fields in the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Field... fields);

        /**
         * <p>
         * Indicates the list of fields in the data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.Field.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.resiliencehub.model.Field#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.Field.Builder#build()} is called immediately and
         * its result is passed to {@link #fields(List<Field>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.Field.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<Field>)
         */
        Builder fields(Consumer<Field.Builder>... fields);

        /**
         * <p>
         * Maximum number of results to include in the response. If more results exist than the specified
         * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to include in the response. If more results exist than the specified
         *        <code>MaxResults</code> value, a token is included in the response so that the remaining results can
         *        be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Null, or the token from a previous call to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Null, or the token from a previous call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * (Optional) Indicates the order in which you want to sort the fields in the metrics. By default, the fields
         * are sorted in the ascending order.
         * </p>
         * 
         * @param sorts
         *        (Optional) Indicates the order in which you want to sort the fields in the metrics. By default, the
         *        fields are sorted in the ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sorts(Collection<Sort> sorts);

        /**
         * <p>
         * (Optional) Indicates the order in which you want to sort the fields in the metrics. By default, the fields
         * are sorted in the ascending order.
         * </p>
         * 
         * @param sorts
         *        (Optional) Indicates the order in which you want to sort the fields in the metrics. By default, the
         *        fields are sorted in the ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sorts(Sort... sorts);

        /**
         * <p>
         * (Optional) Indicates the order in which you want to sort the fields in the metrics. By default, the fields
         * are sorted in the ascending order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.Sort.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.resiliencehub.model.Sort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.Sort.Builder#build()} is called immediately and
         * its result is passed to {@link #sorts(List<Sort>)}.
         * 
         * @param sorts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.Sort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sorts(java.util.Collection<Sort>)
         */
        Builder sorts(Consumer<Sort.Builder>... sorts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private String dataSource;

        private List<Field> fields = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<Sort> sorts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricsRequest model) {
            super(model);
            conditions(model.conditions);
            dataSource(model.dataSource);
            fields(model.fields);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sorts(model.sorts);
        }

        public final List<Condition.Builder> getConditions() {
            List<Condition.Builder> result = ConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> Condition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final List<Field.Builder> getFields() {
            List<Field.Builder> result = FieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<Field.BuilderImpl> fields) {
            this.fields = FieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<Field> fields) {
            this.fields = FieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Field... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<Field.Builder>... fields) {
            fields(Stream.of(fields).map(c -> Field.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Sort.Builder> getSorts() {
            List<Sort.Builder> result = SortListCopier.copyToBuilder(this.sorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSorts(Collection<Sort.BuilderImpl> sorts) {
            this.sorts = SortListCopier.copyFromBuilder(sorts);
        }

        @Override
        public final Builder sorts(Collection<Sort> sorts) {
            this.sorts = SortListCopier.copy(sorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Sort... sorts) {
            sorts(Arrays.asList(sorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Consumer<Sort.Builder>... sorts) {
            sorts(Stream.of(sorts).map(c -> Sort.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMetricsRequest build() {
            return new ListMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
