/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a logical resource identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogicalResourceId implements SdkPojo, Serializable,
        ToCopyableBuilder<LogicalResourceId.Builder, LogicalResourceId> {
    private static final SdkField<String> EKS_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eksSourceName").getter(getter(LogicalResourceId::eksSourceName)).setter(setter(Builder::eksSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSourceName").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(LogicalResourceId::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> LOGICAL_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logicalStackName").getter(getter(LogicalResourceId::logicalStackName))
            .setter(setter(Builder::logicalStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackName").build()).build();

    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGroupName").getter(getter(LogicalResourceId::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupName").build()).build();

    private static final SdkField<String> TERRAFORM_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("terraformSourceName").getter(getter(LogicalResourceId::terraformSourceName))
            .setter(setter(Builder::terraformSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSourceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_SOURCE_NAME_FIELD,
            IDENTIFIER_FIELD, LOGICAL_STACK_NAME_FIELD, RESOURCE_GROUP_NAME_FIELD, TERRAFORM_SOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eksSourceName;

    private final String identifier;

    private final String logicalStackName;

    private final String resourceGroupName;

    private final String terraformSourceName;

    private LogicalResourceId(BuilderImpl builder) {
        this.eksSourceName = builder.eksSourceName;
        this.identifier = builder.identifier;
        this.logicalStackName = builder.logicalStackName;
        this.resourceGroupName = builder.resourceGroupName;
        this.terraformSourceName = builder.terraformSourceName;
    }

    /**
     * <p>
     * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     * </p>
     * <note>
     * <p>
     * This parameter accepts values in "eks-cluster/namespace" format.
     * </p>
     * </note>
     * 
     * @return Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p> <note>
     *         <p>
     *         This parameter accepts values in "eks-cluster/namespace" format.
     *         </p>
     */
    public final String eksSourceName() {
        return eksSourceName;
    }

    /**
     * <p>
     * Identifier of the resource.
     * </p>
     * 
     * @return Identifier of the resource.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the CloudFormation stack this resource belongs to.
     * </p>
     * 
     * @return The name of the CloudFormation stack this resource belongs to.
     */
    public final String logicalStackName() {
        return logicalStackName;
    }

    /**
     * <p>
     * The name of the resource group that this resource belongs to.
     * </p>
     * 
     * @return The name of the resource group that this resource belongs to.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the Terraform S3 state file this resource belongs to.
     * </p>
     * 
     * @return The name of the Terraform S3 state file this resource belongs to.
     */
    public final String terraformSourceName() {
        return terraformSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(logicalStackName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(terraformSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalResourceId)) {
            return false;
        }
        LogicalResourceId other = (LogicalResourceId) obj;
        return Objects.equals(eksSourceName(), other.eksSourceName()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(logicalStackName(), other.logicalStackName())
                && Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(terraformSourceName(), other.terraformSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogicalResourceId").add("EksSourceName", eksSourceName()).add("Identifier", identifier())
                .add("LogicalStackName", logicalStackName()).add("ResourceGroupName", resourceGroupName())
                .add("TerraformSourceName", terraformSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eksSourceName":
            return Optional.ofNullable(clazz.cast(eksSourceName()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "logicalStackName":
            return Optional.ofNullable(clazz.cast(logicalStackName()));
        case "resourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "terraformSourceName":
            return Optional.ofNullable(clazz.cast(terraformSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eksSourceName", EKS_SOURCE_NAME_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("logicalStackName", LOGICAL_STACK_NAME_FIELD);
        map.put("resourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("terraformSourceName", TERRAFORM_SOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogicalResourceId, T> g) {
        return obj -> g.apply((LogicalResourceId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogicalResourceId> {
        /**
         * <p>
         * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
         * </p>
         * <note>
         * <p>
         * This parameter accepts values in "eks-cluster/namespace" format.
         * </p>
         * </note>
         * 
         * @param eksSourceName
         *        Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p>
         *        <note>
         *        <p>
         *        This parameter accepts values in "eks-cluster/namespace" format.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksSourceName(String eksSourceName);

        /**
         * <p>
         * Identifier of the resource.
         * </p>
         * 
         * @param identifier
         *        Identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the CloudFormation stack this resource belongs to.
         * </p>
         * 
         * @param logicalStackName
         *        The name of the CloudFormation stack this resource belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalStackName(String logicalStackName);

        /**
         * <p>
         * The name of the resource group that this resource belongs to.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group that this resource belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the Terraform S3 state file this resource belongs to.
         * </p>
         * 
         * @param terraformSourceName
         *        The name of the Terraform S3 state file this resource belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSourceName(String terraformSourceName);
    }

    static final class BuilderImpl implements Builder {
        private String eksSourceName;

        private String identifier;

        private String logicalStackName;

        private String resourceGroupName;

        private String terraformSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalResourceId model) {
            eksSourceName(model.eksSourceName);
            identifier(model.identifier);
            logicalStackName(model.logicalStackName);
            resourceGroupName(model.resourceGroupName);
            terraformSourceName(model.terraformSourceName);
        }

        public final String getEksSourceName() {
            return eksSourceName;
        }

        public final void setEksSourceName(String eksSourceName) {
            this.eksSourceName = eksSourceName;
        }

        @Override
        public final Builder eksSourceName(String eksSourceName) {
            this.eksSourceName = eksSourceName;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getLogicalStackName() {
            return logicalStackName;
        }

        public final void setLogicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
        }

        @Override
        public final Builder logicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
            return this;
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getTerraformSourceName() {
            return terraformSourceName;
        }

        public final void setTerraformSourceName(String terraformSourceName) {
            this.terraformSourceName = terraformSourceName;
        }

        @Override
        public final Builder terraformSourceName(String terraformSourceName) {
            this.terraformSourceName = terraformSourceName;
            return this;
        }

        @Override
        public LogicalResourceId build() {
            return new LogicalResourceId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
