/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the resources that have drifted in the current application version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDrift implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDrift.Builder, ResourceDrift> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(ResourceDrift::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(ResourceDrift::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<String> DIFF_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diffType").getter(getter(ResourceDrift::diffTypeAsString)).setter(setter(Builder::diffType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diffType").build()).build();

    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceId").getter(getter(ResourceDrift::referenceId)).setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()).build();

    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField
            .<ResourceIdentifier> builder(MarshallingType.SDK_POJO).memberName("resourceIdentifier")
            .getter(getter(ResourceDrift::resourceIdentifier)).setter(setter(Builder::resourceIdentifier))
            .constructor(ResourceIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, DIFF_TYPE_FIELD, REFERENCE_ID_FIELD, RESOURCE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appArn;

    private final String appVersion;

    private final String diffType;

    private final String referenceId;

    private final ResourceIdentifier resourceIdentifier;

    private ResourceDrift(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.diffType = builder.diffType;
        this.referenceId = builder.referenceId;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the application whose resources have drifted. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>.
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the application whose resources have drifted. The format for this ARN is:
     *         arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/
     *         <code>app-id</code>. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Version of the application whose resources have drifted.
     * </p>
     * 
     * @return Version of the application whose resources have drifted.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * Indicates if the resource was added or removed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diffType} will
     * return {@link DifferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #diffTypeAsString}.
     * </p>
     * 
     * @return Indicates if the resource was added or removed.
     * @see DifferenceType
     */
    public final DifferenceType diffType() {
        return DifferenceType.fromValue(diffType);
    }

    /**
     * <p>
     * Indicates if the resource was added or removed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diffType} will
     * return {@link DifferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #diffTypeAsString}.
     * </p>
     * 
     * @return Indicates if the resource was added or removed.
     * @see DifferenceType
     */
    public final String diffTypeAsString() {
        return diffType;
    }

    /**
     * <p>
     * Reference identifier of the resource drift.
     * </p>
     * 
     * @return Reference identifier of the resource drift.
     */
    public final String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * Identifier of the drifted resource.
     * </p>
     * 
     * @return Identifier of the drifted resource.
     */
    public final ResourceIdentifier resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(diffTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDrift)) {
            return false;
        }
        ResourceDrift other = (ResourceDrift) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(diffTypeAsString(), other.diffTypeAsString())
                && Objects.equals(referenceId(), other.referenceId())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDrift").add("AppArn", appArn()).add("AppVersion", appVersion())
                .add("DiffType", diffTypeAsString()).add("ReferenceId", referenceId())
                .add("ResourceIdentifier", resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "diffType":
            return Optional.ofNullable(clazz.cast(diffTypeAsString()));
        case "referenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("diffType", DIFF_TYPE_FIELD);
        map.put("referenceId", REFERENCE_ID_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDrift, T> g) {
        return obj -> g.apply((ResourceDrift) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDrift> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the application whose resources have drifted. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/
         * <code>app-id</code>. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the application whose resources have drifted. The format for this ARN
         *        is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/
         *        <code>app-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Version of the application whose resources have drifted.
         * </p>
         * 
         * @param appVersion
         *        Version of the application whose resources have drifted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * Indicates if the resource was added or removed.
         * </p>
         * 
         * @param diffType
         *        Indicates if the resource was added or removed.
         * @see DifferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceType
         */
        Builder diffType(String diffType);

        /**
         * <p>
         * Indicates if the resource was added or removed.
         * </p>
         * 
         * @param diffType
         *        Indicates if the resource was added or removed.
         * @see DifferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceType
         */
        Builder diffType(DifferenceType diffType);

        /**
         * <p>
         * Reference identifier of the resource drift.
         * </p>
         * 
         * @param referenceId
         *        Reference identifier of the resource drift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * Identifier of the drifted resource.
         * </p>
         * 
         * @param resourceIdentifier
         *        Identifier of the drifted resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(ResourceIdentifier resourceIdentifier);

        /**
         * <p>
         * Identifier of the drifted resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceIdentifier.Builder} avoiding the
         * need to create one manually via {@link ResourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceIdentifier(ResourceIdentifier)}.
         * 
         * @param resourceIdentifier
         *        a consumer that will call methods on {@link ResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifier(ResourceIdentifier)
         */
        default Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return resourceIdentifier(ResourceIdentifier.builder().applyMutation(resourceIdentifier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private String diffType;

        private String referenceId;

        private ResourceIdentifier resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDrift model) {
            appArn(model.appArn);
            appVersion(model.appVersion);
            diffType(model.diffType);
            referenceId(model.referenceId);
            resourceIdentifier(model.resourceIdentifier);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getDiffType() {
            return diffType;
        }

        public final void setDiffType(String diffType) {
            this.diffType = diffType;
        }

        @Override
        public final Builder diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        @Override
        public final Builder diffType(DifferenceType diffType) {
            this.diffType(diffType == null ? null : diffType.toString());
            return this;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return resourceIdentifier != null ? resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public ResourceDrift build() {
            return new ResourceDrift(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
