/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resiliency score of each scoring component. For more information about scoring component, see <a
 * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/calculate-score.html">Calculating resiliency
 * score</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScoringComponentResiliencyScore implements SdkPojo, Serializable,
        ToCopyableBuilder<ScoringComponentResiliencyScore.Builder, ScoringComponentResiliencyScore> {
    private static final SdkField<Long> EXCLUDED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("excludedCount").getter(getter(ScoringComponentResiliencyScore::excludedCount))
            .setter(setter(Builder::excludedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedCount").build()).build();

    private static final SdkField<Long> OUTSTANDING_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("outstandingCount").getter(getter(ScoringComponentResiliencyScore::outstandingCount))
            .setter(setter(Builder::outstandingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outstandingCount").build()).build();

    private static final SdkField<Double> POSSIBLE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("possibleScore").getter(getter(ScoringComponentResiliencyScore::possibleScore))
            .setter(setter(Builder::possibleScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("possibleScore").build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("score")
            .getter(getter(ScoringComponentResiliencyScore::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDED_COUNT_FIELD,
            OUTSTANDING_COUNT_FIELD, POSSIBLE_SCORE_FIELD, SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long excludedCount;

    private final Long outstandingCount;

    private final Double possibleScore;

    private final Double score;

    private ScoringComponentResiliencyScore(BuilderImpl builder) {
        this.excludedCount = builder.excludedCount;
        this.outstandingCount = builder.outstandingCount;
        this.possibleScore = builder.possibleScore;
        this.score = builder.score;
    }

    /**
     * <p>
     * Number of recommendations that were excluded from the assessment.
     * </p>
     * <p>
     * For example, if the <code>excludedCount</code> for Alarms coverage scoring component is 7, it indicates that 7
     * Amazon CloudWatch alarms are excluded from the assessment.
     * </p>
     * 
     * @return Number of recommendations that were excluded from the assessment.</p>
     *         <p>
     *         For example, if the <code>excludedCount</code> for Alarms coverage scoring component is 7, it indicates
     *         that 7 Amazon CloudWatch alarms are excluded from the assessment.
     */
    public final Long excludedCount() {
        return excludedCount;
    }

    /**
     * <p>
     * Number of recommendations that must be implemented to obtain the maximum possible score for the scoring
     * component. For SOPs, alarms, and tests, these are the number of recommendations that must be implemented. For
     * compliance, these are the number of Application Components that have breached the resiliency policy.
     * </p>
     * <p>
     * For example, if the <code>outstandingCount</code> for Alarms coverage scoring component is 5, it indicates that 5
     * Amazon CloudWatch alarms need to be implemented to achieve the maximum possible score.
     * </p>
     * 
     * @return Number of recommendations that must be implemented to obtain the maximum possible score for the scoring
     *         component. For SOPs, alarms, and tests, these are the number of recommendations that must be implemented.
     *         For compliance, these are the number of Application Components that have breached the resiliency
     *         policy.</p>
     *         <p>
     *         For example, if the <code>outstandingCount</code> for Alarms coverage scoring component is 5, it
     *         indicates that 5 Amazon CloudWatch alarms need to be implemented to achieve the maximum possible score.
     */
    public final Long outstandingCount() {
        return outstandingCount;
    }

    /**
     * <p>
     * Maximum possible score that can be obtained for the scoring component.
     * </p>
     * <p>
     * For example, if the <code>possibleScore</code> is 20 points, it indicates the maximum possible score you can
     * achieve for the scoring component when you run a new assessment after implementing all the Resilience Hub
     * recommendations.
     * </p>
     * 
     * @return Maximum possible score that can be obtained for the scoring component. </p>
     *         <p>
     *         For example, if the <code>possibleScore</code> is 20 points, it indicates the maximum possible score you
     *         can achieve for the scoring component when you run a new assessment after implementing all the Resilience
     *         Hub recommendations.
     */
    public final Double possibleScore() {
        return possibleScore;
    }

    /**
     * <p>
     * Resiliency score points given for the scoring component. The score is always less than or equal to the
     * <code>possibleScore</code>.
     * </p>
     * 
     * @return Resiliency score points given for the scoring component. The score is always less than or equal to the
     *         <code>possibleScore</code>.
     */
    public final Double score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludedCount());
        hashCode = 31 * hashCode + Objects.hashCode(outstandingCount());
        hashCode = 31 * hashCode + Objects.hashCode(possibleScore());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScoringComponentResiliencyScore)) {
            return false;
        }
        ScoringComponentResiliencyScore other = (ScoringComponentResiliencyScore) obj;
        return Objects.equals(excludedCount(), other.excludedCount())
                && Objects.equals(outstandingCount(), other.outstandingCount())
                && Objects.equals(possibleScore(), other.possibleScore()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScoringComponentResiliencyScore").add("ExcludedCount", excludedCount())
                .add("OutstandingCount", outstandingCount()).add("PossibleScore", possibleScore()).add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludedCount":
            return Optional.ofNullable(clazz.cast(excludedCount()));
        case "outstandingCount":
            return Optional.ofNullable(clazz.cast(outstandingCount()));
        case "possibleScore":
            return Optional.ofNullable(clazz.cast(possibleScore()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("excludedCount", EXCLUDED_COUNT_FIELD);
        map.put("outstandingCount", OUTSTANDING_COUNT_FIELD);
        map.put("possibleScore", POSSIBLE_SCORE_FIELD);
        map.put("score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScoringComponentResiliencyScore, T> g) {
        return obj -> g.apply((ScoringComponentResiliencyScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScoringComponentResiliencyScore> {
        /**
         * <p>
         * Number of recommendations that were excluded from the assessment.
         * </p>
         * <p>
         * For example, if the <code>excludedCount</code> for Alarms coverage scoring component is 7, it indicates that
         * 7 Amazon CloudWatch alarms are excluded from the assessment.
         * </p>
         * 
         * @param excludedCount
         *        Number of recommendations that were excluded from the assessment.</p>
         *        <p>
         *        For example, if the <code>excludedCount</code> for Alarms coverage scoring component is 7, it
         *        indicates that 7 Amazon CloudWatch alarms are excluded from the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedCount(Long excludedCount);

        /**
         * <p>
         * Number of recommendations that must be implemented to obtain the maximum possible score for the scoring
         * component. For SOPs, alarms, and tests, these are the number of recommendations that must be implemented. For
         * compliance, these are the number of Application Components that have breached the resiliency policy.
         * </p>
         * <p>
         * For example, if the <code>outstandingCount</code> for Alarms coverage scoring component is 5, it indicates
         * that 5 Amazon CloudWatch alarms need to be implemented to achieve the maximum possible score.
         * </p>
         * 
         * @param outstandingCount
         *        Number of recommendations that must be implemented to obtain the maximum possible score for the
         *        scoring component. For SOPs, alarms, and tests, these are the number of recommendations that must be
         *        implemented. For compliance, these are the number of Application Components that have breached the
         *        resiliency policy.</p>
         *        <p>
         *        For example, if the <code>outstandingCount</code> for Alarms coverage scoring component is 5, it
         *        indicates that 5 Amazon CloudWatch alarms need to be implemented to achieve the maximum possible
         *        score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outstandingCount(Long outstandingCount);

        /**
         * <p>
         * Maximum possible score that can be obtained for the scoring component.
         * </p>
         * <p>
         * For example, if the <code>possibleScore</code> is 20 points, it indicates the maximum possible score you can
         * achieve for the scoring component when you run a new assessment after implementing all the Resilience Hub
         * recommendations.
         * </p>
         * 
         * @param possibleScore
         *        Maximum possible score that can be obtained for the scoring component. </p>
         *        <p>
         *        For example, if the <code>possibleScore</code> is 20 points, it indicates the maximum possible score
         *        you can achieve for the scoring component when you run a new assessment after implementing all the
         *        Resilience Hub recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder possibleScore(Double possibleScore);

        /**
         * <p>
         * Resiliency score points given for the scoring component. The score is always less than or equal to the
         * <code>possibleScore</code>.
         * </p>
         * 
         * @param score
         *        Resiliency score points given for the scoring component. The score is always less than or equal to the
         *        <code>possibleScore</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);
    }

    static final class BuilderImpl implements Builder {
        private Long excludedCount;

        private Long outstandingCount;

        private Double possibleScore;

        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(ScoringComponentResiliencyScore model) {
            excludedCount(model.excludedCount);
            outstandingCount(model.outstandingCount);
            possibleScore(model.possibleScore);
            score(model.score);
        }

        public final Long getExcludedCount() {
            return excludedCount;
        }

        public final void setExcludedCount(Long excludedCount) {
            this.excludedCount = excludedCount;
        }

        @Override
        public final Builder excludedCount(Long excludedCount) {
            this.excludedCount = excludedCount;
            return this;
        }

        public final Long getOutstandingCount() {
            return outstandingCount;
        }

        public final void setOutstandingCount(Long outstandingCount) {
            this.outstandingCount = outstandingCount;
        }

        @Override
        public final Builder outstandingCount(Long outstandingCount) {
            this.outstandingCount = outstandingCount;
            return this;
        }

        public final Double getPossibleScore() {
            return possibleScore;
        }

        public final void setPossibleScore(Double possibleScore) {
            this.possibleScore = possibleScore;
        }

        @Override
        public final Builder possibleScore(Double possibleScore) {
            this.possibleScore = possibleScore;
            return this;
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        @Override
        public ScoringComponentResiliencyScore build() {
            return new ScoringComponentResiliencyScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
