/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.RowListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListMetricsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMetricsResponse.getter(ListMetricsResponse::nextToken)).setter(ListMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<List<String>>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rows").getter(ListMetricsResponse.getter(ListMetricsResponse::rows)).setter(ListMetricsResponse.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ROWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMetricsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<List<String>> rows;

    private ListMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.rows = builder.rows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<List<String>> rows() {
        return this.rows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsResponse)) {
            return false;
        }
        ListMetricsResponse other = (ListMetricsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetricsResponse").add("NextToken", (Object)this.nextToken()).add("Rows", this.hasRows() ? this.rows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("rows", ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetricsResponse, T> g) {
        return obj -> g.apply((ListMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<List<String>> rows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.rows(model.rows);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<? extends Collection<String>> getRows() {
            if (this.rows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rows;
        }

        public final void setRows(Collection<? extends Collection<String>> rows) {
            this.rows = RowListCopier.copy(rows);
        }

        @Override
        public final Builder rows(Collection<? extends Collection<String>> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Collection<String> ... rows) {
            this.rows((Collection<? extends Collection<String>>)Arrays.asList(rows));
            return this;
        }

        @Override
        public ListMetricsResponse build() {
            return new ListMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetricsResponse> {
        public Builder nextToken(String var1);

        public Builder rows(Collection<? extends Collection<String>> var1);

        public Builder rows(Collection<String> ... var1);
    }
}

