/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an Resilience Hub application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class App implements SdkPojo, Serializable, ToCopyableBuilder<App.Builder, App> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(App::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> ASSESSMENT_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentSchedule").getter(getter(App::assessmentScheduleAsString))
            .setter(setter(Builder::assessmentSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSchedule").build())
            .build();

    private static final SdkField<String> AWS_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsApplicationArn").getter(getter(App::awsApplicationArn)).setter(setter(Builder::awsApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsApplicationArn").build()).build();

    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceStatus").getter(getter(App::complianceStatusAsString))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(App::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(App::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("driftStatus").getter(getter(App::driftStatusAsString)).setter(setter(Builder::driftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()).build();

    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_FIELD = SdkField
            .<List<EventSubscription>> builder(MarshallingType.LIST)
            .memberName("eventSubscriptions")
            .getter(getter(App::eventSubscriptions))
            .setter(setter(Builder::eventSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAppComplianceEvaluationTime")
            .getter(getter(App::lastAppComplianceEvaluationTime))
            .setter(setter(Builder::lastAppComplianceEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAppComplianceEvaluationTime")
                    .build()).build();

    private static final SdkField<Instant> LAST_DRIFT_EVALUATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastDriftEvaluationTime").getter(getter(App::lastDriftEvaluationTime))
            .setter(setter(Builder::lastDriftEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDriftEvaluationTime").build())
            .build();

    private static final SdkField<Instant> LAST_RESILIENCY_SCORE_EVALUATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastResiliencyScoreEvaluationTime")
            .getter(getter(App::lastResiliencyScoreEvaluationTime))
            .setter(setter(Builder::lastResiliencyScoreEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastResiliencyScoreEvaluationTime")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(App::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PermissionModel> PERMISSION_MODEL_FIELD = SdkField
            .<PermissionModel> builder(MarshallingType.SDK_POJO).memberName("permissionModel")
            .getter(getter(App::permissionModel)).setter(setter(Builder::permissionModel)).constructor(PermissionModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionModel").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(App::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<Double> RESILIENCY_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("resiliencyScore").getter(getter(App::resiliencyScore)).setter(setter(Builder::resiliencyScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()).build();

    private static final SdkField<Integer> RPO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("rpoInSecs").getter(getter(App::rpoInSecs)).setter(setter(Builder::rpoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rpoInSecs").build()).build();

    private static final SdkField<Integer> RTO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("rtoInSecs").getter(getter(App::rtoInSecs)).setter(setter(Builder::rtoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtoInSecs").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(App::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(App::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            ASSESSMENT_SCHEDULE_FIELD, AWS_APPLICATION_ARN_FIELD, COMPLIANCE_STATUS_FIELD, CREATION_TIME_FIELD,
            DESCRIPTION_FIELD, DRIFT_STATUS_FIELD, EVENT_SUBSCRIPTIONS_FIELD, LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD,
            LAST_DRIFT_EVALUATION_TIME_FIELD, LAST_RESILIENCY_SCORE_EVALUATION_TIME_FIELD, NAME_FIELD, PERMISSION_MODEL_FIELD,
            POLICY_ARN_FIELD, RESILIENCY_SCORE_FIELD, RPO_IN_SECS_FIELD, RTO_IN_SECS_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appArn;

    private final String assessmentSchedule;

    private final String awsApplicationArn;

    private final String complianceStatus;

    private final Instant creationTime;

    private final String description;

    private final String driftStatus;

    private final List<EventSubscription> eventSubscriptions;

    private final Instant lastAppComplianceEvaluationTime;

    private final Instant lastDriftEvaluationTime;

    private final Instant lastResiliencyScoreEvaluationTime;

    private final String name;

    private final PermissionModel permissionModel;

    private final String policyArn;

    private final Double resiliencyScore;

    private final Integer rpoInSecs;

    private final Integer rtoInSecs;

    private final String status;

    private final Map<String, String> tags;

    private App(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.assessmentSchedule = builder.assessmentSchedule;
        this.awsApplicationArn = builder.awsApplicationArn;
        this.complianceStatus = builder.complianceStatus;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.driftStatus = builder.driftStatus;
        this.eventSubscriptions = builder.eventSubscriptions;
        this.lastAppComplianceEvaluationTime = builder.lastAppComplianceEvaluationTime;
        this.lastDriftEvaluationTime = builder.lastDriftEvaluationTime;
        this.lastResiliencyScoreEvaluationTime = builder.lastResiliencyScoreEvaluationTime;
        this.name = builder.name;
        this.permissionModel = builder.permissionModel;
        this.policyArn = builder.policyArn;
        this.resiliencyScore = builder.resiliencyScore;
        this.rpoInSecs = builder.rpoInSecs;
        this.rtoInSecs = builder.rtoInSecs;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final AppAssessmentScheduleType assessmentSchedule() {
        return AppAssessmentScheduleType.fromValue(assessmentSchedule);
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final String assessmentScheduleAsString() {
        return assessmentSchedule;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String awsApplicationArn() {
        return awsApplicationArn;
    }

    /**
     * <p>
     * Current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link AppComplianceStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return Current status of compliance for the resiliency policy.
     * @see AppComplianceStatusType
     */
    public final AppComplianceStatusType complianceStatus() {
        return AppComplianceStatusType.fromValue(complianceStatus);
    }

    /**
     * <p>
     * Current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link AppComplianceStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return Current status of compliance for the resiliency policy.
     * @see AppComplianceStatusType
     */
    public final String complianceStatusAsString() {
        return complianceStatus;
    }

    /**
     * <p>
     * Date and time when the application was created.
     * </p>
     * 
     * @return Date and time when the application was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Optional description for an application.
     * </p>
     * 
     * @return Optional description for an application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link AppDriftStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return Indicates if compliance drifts (deviations) were detected while running an assessment for your
     *         application.
     * @see AppDriftStatusType
     */
    public final AppDriftStatusType driftStatus() {
        return AppDriftStatusType.fromValue(driftStatus);
    }

    /**
     * <p>
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link AppDriftStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return Indicates if compliance drifts (deviations) were detected while running an assessment for your
     *         application.
     * @see AppDriftStatusType
     */
    public final String driftStatusAsString() {
        return driftStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSubscriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSubscriptions() {
        return eventSubscriptions != null && !(eventSubscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
     * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSubscriptions} method.
     * </p>
     * 
     * @return The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
     *         supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
     */
    public final List<EventSubscription> eventSubscriptions() {
        return eventSubscriptions;
    }

    /**
     * <p>
     * Date and time the most recent compliance evaluation.
     * </p>
     * 
     * @return Date and time the most recent compliance evaluation.
     */
    public final Instant lastAppComplianceEvaluationTime() {
        return lastAppComplianceEvaluationTime;
    }

    /**
     * <p>
     * Indicates the last time that a drift was evaluated.
     * </p>
     * 
     * @return Indicates the last time that a drift was evaluated.
     */
    public final Instant lastDriftEvaluationTime() {
        return lastDriftEvaluationTime;
    }

    /**
     * <p>
     * Date and time the most recent resiliency score evaluation.
     * </p>
     * 
     * @return Date and time the most recent resiliency score evaluation.
     */
    public final Instant lastResiliencyScoreEvaluationTime() {
        return lastResiliencyScoreEvaluationTime;
    }

    /**
     * <p>
     * Name for the application.
     * </p>
     * 
     * @return Name for the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its
     * resources, and running an assessment.
     * </p>
     * 
     * @return Defines the roles and credentials that Resilience Hub would use while creating the application, importing
     *         its resources, and running an assessment.
     */
    public final PermissionModel permissionModel() {
        return permissionModel;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
     *         <code>policy-id</code>. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * Current resiliency score for the application.
     * </p>
     * 
     * @return Current resiliency score for the application.
     */
    public final Double resiliencyScore() {
        return resiliencyScore;
    }

    /**
     * <p>
     * Recovery Point Objective (RPO) in seconds.
     * </p>
     * 
     * @return Recovery Point Objective (RPO) in seconds.
     */
    public final Integer rpoInSecs() {
        return rpoInSecs;
    }

    /**
     * <p>
     * Recovery Time Objective (RTO) in seconds.
     * </p>
     * 
     * @return Recovery Time Objective (RTO) in seconds.
     */
    public final Integer rtoInSecs() {
        return rtoInSecs;
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see AppStatusType
     */
    public final AppStatusType status() {
        return AppStatusType.fromValue(status);
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see AppStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key/value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each
     *         tag consists of a key/value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSubscriptions() ? eventSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastAppComplianceEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastDriftEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastResiliencyScoreEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(permissionModel());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(rpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(rtoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App) obj;
        return Objects.equals(appArn(), other.appArn())
                && Objects.equals(assessmentScheduleAsString(), other.assessmentScheduleAsString())
                && Objects.equals(awsApplicationArn(), other.awsApplicationArn())
                && Objects.equals(complianceStatusAsString(), other.complianceStatusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(driftStatusAsString(), other.driftStatusAsString())
                && hasEventSubscriptions() == other.hasEventSubscriptions()
                && Objects.equals(eventSubscriptions(), other.eventSubscriptions())
                && Objects.equals(lastAppComplianceEvaluationTime(), other.lastAppComplianceEvaluationTime())
                && Objects.equals(lastDriftEvaluationTime(), other.lastDriftEvaluationTime())
                && Objects.equals(lastResiliencyScoreEvaluationTime(), other.lastResiliencyScoreEvaluationTime())
                && Objects.equals(name(), other.name()) && Objects.equals(permissionModel(), other.permissionModel())
                && Objects.equals(policyArn(), other.policyArn()) && Objects.equals(resiliencyScore(), other.resiliencyScore())
                && Objects.equals(rpoInSecs(), other.rpoInSecs()) && Objects.equals(rtoInSecs(), other.rtoInSecs())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("App").add("AppArn", appArn()).add("AssessmentSchedule", assessmentScheduleAsString())
                .add("AwsApplicationArn", awsApplicationArn()).add("ComplianceStatus", complianceStatusAsString())
                .add("CreationTime", creationTime()).add("Description", description()).add("DriftStatus", driftStatusAsString())
                .add("EventSubscriptions", hasEventSubscriptions() ? eventSubscriptions() : null)
                .add("LastAppComplianceEvaluationTime", lastAppComplianceEvaluationTime())
                .add("LastDriftEvaluationTime", lastDriftEvaluationTime())
                .add("LastResiliencyScoreEvaluationTime", lastResiliencyScoreEvaluationTime()).add("Name", name())
                .add("PermissionModel", permissionModel()).add("PolicyArn", policyArn())
                .add("ResiliencyScore", resiliencyScore()).add("RpoInSecs", rpoInSecs()).add("RtoInSecs", rtoInSecs())
                .add("Status", statusAsString()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "assessmentSchedule":
            return Optional.ofNullable(clazz.cast(assessmentScheduleAsString()));
        case "awsApplicationArn":
            return Optional.ofNullable(clazz.cast(awsApplicationArn()));
        case "complianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "driftStatus":
            return Optional.ofNullable(clazz.cast(driftStatusAsString()));
        case "eventSubscriptions":
            return Optional.ofNullable(clazz.cast(eventSubscriptions()));
        case "lastAppComplianceEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastAppComplianceEvaluationTime()));
        case "lastDriftEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastDriftEvaluationTime()));
        case "lastResiliencyScoreEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastResiliencyScoreEvaluationTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "permissionModel":
            return Optional.ofNullable(clazz.cast(permissionModel()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "resiliencyScore":
            return Optional.ofNullable(clazz.cast(resiliencyScore()));
        case "rpoInSecs":
            return Optional.ofNullable(clazz.cast(rpoInSecs()));
        case "rtoInSecs":
            return Optional.ofNullable(clazz.cast(rtoInSecs()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("assessmentSchedule", ASSESSMENT_SCHEDULE_FIELD);
        map.put("awsApplicationArn", AWS_APPLICATION_ARN_FIELD);
        map.put("complianceStatus", COMPLIANCE_STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("driftStatus", DRIFT_STATUS_FIELD);
        map.put("eventSubscriptions", EVENT_SUBSCRIPTIONS_FIELD);
        map.put("lastAppComplianceEvaluationTime", LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD);
        map.put("lastDriftEvaluationTime", LAST_DRIFT_EVALUATION_TIME_FIELD);
        map.put("lastResiliencyScoreEvaluationTime", LAST_RESILIENCY_SCORE_EVALUATION_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("permissionModel", PERMISSION_MODEL_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("resiliencyScore", RESILIENCY_SCORE_FIELD);
        map.put("rpoInSecs", RPO_IN_SECS_FIELD);
        map.put("rtoInSecs", RTO_IN_SECS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, App> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(String assessmentSchedule);

        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule);

        /**
         * <p>
         * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param awsApplicationArn
         *        Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry
         *        application. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApplicationArn(String awsApplicationArn);

        /**
         * <p>
         * Current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        Current status of compliance for the resiliency policy.
         * @see AppComplianceStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppComplianceStatusType
         */
        Builder complianceStatus(String complianceStatus);

        /**
         * <p>
         * Current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        Current status of compliance for the resiliency policy.
         * @see AppComplianceStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppComplianceStatusType
         */
        Builder complianceStatus(AppComplianceStatusType complianceStatus);

        /**
         * <p>
         * Date and time when the application was created.
         * </p>
         * 
         * @param creationTime
         *        Date and time when the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Optional description for an application.
         * </p>
         * 
         * @param description
         *        Optional description for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         * </p>
         * 
         * @param driftStatus
         *        Indicates if compliance drifts (deviations) were detected while running an assessment for your
         *        application.
         * @see AppDriftStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppDriftStatusType
         */
        Builder driftStatus(String driftStatus);

        /**
         * <p>
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         * </p>
         * 
         * @param driftStatus
         *        Indicates if compliance drifts (deviations) were detected while running an assessment for your
         *        application.
         * @see AppDriftStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppDriftStatusType
         */
        Builder driftStatus(AppDriftStatusType driftStatus);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(EventSubscription... eventSubscriptions);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder#build()} is called
         * immediately and its result is passed to {@link #eventSubscriptions(List<EventSubscription>)}.
         * 
         * @param eventSubscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSubscriptions(java.util.Collection<EventSubscription>)
         */
        Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions);

        /**
         * <p>
         * Date and time the most recent compliance evaluation.
         * </p>
         * 
         * @param lastAppComplianceEvaluationTime
         *        Date and time the most recent compliance evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime);

        /**
         * <p>
         * Indicates the last time that a drift was evaluated.
         * </p>
         * 
         * @param lastDriftEvaluationTime
         *        Indicates the last time that a drift was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDriftEvaluationTime(Instant lastDriftEvaluationTime);

        /**
         * <p>
         * Date and time the most recent resiliency score evaluation.
         * </p>
         * 
         * @param lastResiliencyScoreEvaluationTime
         *        Date and time the most recent resiliency score evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime);

        /**
         * <p>
         * Name for the application.
         * </p>
         * 
         * @param name
         *        Name for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its
         * resources, and running an assessment.
         * </p>
         * 
         * @param permissionModel
         *        Defines the roles and credentials that Resilience Hub would use while creating the application,
         *        importing its resources, and running an assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionModel(PermissionModel permissionModel);

        /**
         * <p>
         * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its
         * resources, and running an assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionModel.Builder} avoiding the
         * need to create one manually via {@link PermissionModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionModel.Builder#build()} is called immediately and its
         * result is passed to {@link #permissionModel(PermissionModel)}.
         * 
         * @param permissionModel
         *        a consumer that will call methods on {@link PermissionModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionModel(PermissionModel)
         */
        default Builder permissionModel(Consumer<PermissionModel.Builder> permissionModel) {
            return permissionModel(PermissionModel.builder().applyMutation(permissionModel).build());
        }

        /**
         * <p>
         * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param policyArn
         *        Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
         *        <code>policy-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * Current resiliency score for the application.
         * </p>
         * 
         * @param resiliencyScore
         *        Current resiliency score for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resiliencyScore(Double resiliencyScore);

        /**
         * <p>
         * Recovery Point Objective (RPO) in seconds.
         * </p>
         * 
         * @param rpoInSecs
         *        Recovery Point Objective (RPO) in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rpoInSecs(Integer rpoInSecs);

        /**
         * <p>
         * Recovery Time Objective (RTO) in seconds.
         * </p>
         * 
         * @param rtoInSecs
         *        Recovery Time Objective (RTO) in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtoInSecs(Integer rtoInSecs);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param status
         *        Status of the application.
         * @see AppStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param status
         *        Status of the application.
         * @see AppStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatusType
         */
        Builder status(AppStatusType status);

        /**
         * <p>
         * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
         * consists of a key/value pair.
         * </p>
         * 
         * @param tags
         *        Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
         *        Each tag consists of a key/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String appArn;

        private String assessmentSchedule;

        private String awsApplicationArn;

        private String complianceStatus;

        private Instant creationTime;

        private String description;

        private String driftStatus;

        private List<EventSubscription> eventSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private Instant lastAppComplianceEvaluationTime;

        private Instant lastDriftEvaluationTime;

        private Instant lastResiliencyScoreEvaluationTime;

        private String name;

        private PermissionModel permissionModel;

        private String policyArn;

        private Double resiliencyScore;

        private Integer rpoInSecs;

        private Integer rtoInSecs;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            appArn(model.appArn);
            assessmentSchedule(model.assessmentSchedule);
            awsApplicationArn(model.awsApplicationArn);
            complianceStatus(model.complianceStatus);
            creationTime(model.creationTime);
            description(model.description);
            driftStatus(model.driftStatus);
            eventSubscriptions(model.eventSubscriptions);
            lastAppComplianceEvaluationTime(model.lastAppComplianceEvaluationTime);
            lastDriftEvaluationTime(model.lastDriftEvaluationTime);
            lastResiliencyScoreEvaluationTime(model.lastResiliencyScoreEvaluationTime);
            name(model.name);
            permissionModel(model.permissionModel);
            policyArn(model.policyArn);
            resiliencyScore(model.resiliencyScore);
            rpoInSecs(model.rpoInSecs);
            rtoInSecs(model.rtoInSecs);
            status(model.status);
            tags(model.tags);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentSchedule() {
            return assessmentSchedule;
        }

        public final void setAssessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
        }

        @Override
        public final Builder assessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
            return this;
        }

        @Override
        public final Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
            this.assessmentSchedule(assessmentSchedule == null ? null : assessmentSchedule.toString());
            return this;
        }

        public final String getAwsApplicationArn() {
            return awsApplicationArn;
        }

        public final void setAwsApplicationArn(String awsApplicationArn) {
            this.awsApplicationArn = awsApplicationArn;
        }

        @Override
        public final Builder awsApplicationArn(String awsApplicationArn) {
            this.awsApplicationArn = awsApplicationArn;
            return this;
        }

        public final String getComplianceStatus() {
            return complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(AppComplianceStatusType complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDriftStatus() {
            return driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(AppDriftStatusType driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptions() {
            List<EventSubscription.Builder> result = EventSubscriptionListCopier.copyToBuilder(this.eventSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptions(Collection<EventSubscription.BuilderImpl> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copyFromBuilder(eventSubscriptions);
        }

        @Override
        public final Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copy(eventSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(EventSubscription... eventSubscriptions) {
            eventSubscriptions(Arrays.asList(eventSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions) {
            eventSubscriptions(Stream.of(eventSubscriptions).map(c -> EventSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastAppComplianceEvaluationTime() {
            return lastAppComplianceEvaluationTime;
        }

        public final void setLastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
        }

        @Override
        public final Builder lastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
            return this;
        }

        public final Instant getLastDriftEvaluationTime() {
            return lastDriftEvaluationTime;
        }

        public final void setLastDriftEvaluationTime(Instant lastDriftEvaluationTime) {
            this.lastDriftEvaluationTime = lastDriftEvaluationTime;
        }

        @Override
        public final Builder lastDriftEvaluationTime(Instant lastDriftEvaluationTime) {
            this.lastDriftEvaluationTime = lastDriftEvaluationTime;
            return this;
        }

        public final Instant getLastResiliencyScoreEvaluationTime() {
            return lastResiliencyScoreEvaluationTime;
        }

        public final void setLastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime) {
            this.lastResiliencyScoreEvaluationTime = lastResiliencyScoreEvaluationTime;
        }

        @Override
        public final Builder lastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime) {
            this.lastResiliencyScoreEvaluationTime = lastResiliencyScoreEvaluationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PermissionModel.Builder getPermissionModel() {
            return permissionModel != null ? permissionModel.toBuilder() : null;
        }

        public final void setPermissionModel(PermissionModel.BuilderImpl permissionModel) {
            this.permissionModel = permissionModel != null ? permissionModel.build() : null;
        }

        @Override
        public final Builder permissionModel(PermissionModel permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Double getResiliencyScore() {
            return resiliencyScore;
        }

        public final void setResiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
        }

        @Override
        public final Builder resiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final Integer getRpoInSecs() {
            return rpoInSecs;
        }

        public final void setRpoInSecs(Integer rpoInSecs) {
            this.rpoInSecs = rpoInSecs;
        }

        @Override
        public final Builder rpoInSecs(Integer rpoInSecs) {
            this.rpoInSecs = rpoInSecs;
            return this;
        }

        public final Integer getRtoInSecs() {
            return rtoInSecs;
        }

        public final void setRtoInSecs(Integer rtoInSecs) {
            this.rtoInSecs = rtoInSecs;
        }

        @Override
        public final Builder rtoInSecs(Integer rtoInSecs) {
            this.rtoInSecs = rtoInSecs;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public App build() {
            return new App(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
