/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDraftAppVersionResourcesImportStatusResponse extends ResiliencehubResponse
        implements
        ToCopyableBuilder<DescribeDraftAppVersionResourcesImportStatusResponse.Builder, DescribeDraftAppVersionResourcesImportStatusResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(DescribeDraftAppVersionResourcesImportStatusResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(DescribeDraftAppVersionResourcesImportStatusResponse::appVersion))
            .setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField
            .<List<ErrorDetail>> builder(MarshallingType.LIST)
            .memberName("errorDetails")
            .getter(getter(DescribeDraftAppVersionResourcesImportStatusResponse::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(DescribeDraftAppVersionResourcesImportStatusResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeDraftAppVersionResourcesImportStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STATUS_CHANGE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("statusChangeTime")
            .getter(getter(DescribeDraftAppVersionResourcesImportStatusResponse::statusChangeTime))
            .setter(setter(Builder::statusChangeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusChangeTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, ERROR_DETAILS_FIELD, ERROR_MESSAGE_FIELD, STATUS_FIELD, STATUS_CHANGE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appArn;

    private final String appVersion;

    private final List<ErrorDetail> errorDetails;

    private final String errorMessage;

    private final String status;

    private final Instant statusChangeTime;

    private DescribeDraftAppVersionResourcesImportStatusResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.status = builder.status;
        this.statusChangeTime = builder.statusChangeTime;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorDetails() {
        return errorDetails != null && !(errorDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of errors that were encountered while importing resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorDetails} method.
     * </p>
     * 
     * @return List of errors that were encountered while importing resources.
     */
    public final List<ErrorDetail> errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The error message returned for the resource request.
     * </p>
     * 
     * @return The error message returned for the resource request.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceImportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the action.
     * @see ResourceImportStatusType
     */
    public final ResourceImportStatusType status() {
        return ResourceImportStatusType.fromValue(status);
    }

    /**
     * <p>
     * Status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceImportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the action.
     * @see ResourceImportStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the status last changed.
     * </p>
     * 
     * @return The time when the status last changed.
     */
    public final Instant statusChangeTime() {
        return statusChangeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorDetails() ? errorDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusChangeTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDraftAppVersionResourcesImportStatusResponse)) {
            return false;
        }
        DescribeDraftAppVersionResourcesImportStatusResponse other = (DescribeDraftAppVersionResourcesImportStatusResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && hasErrorDetails() == other.hasErrorDetails() && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusChangeTime(), other.statusChangeTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDraftAppVersionResourcesImportStatusResponse").add("AppArn", appArn())
                .add("AppVersion", appVersion()).add("ErrorDetails", hasErrorDetails() ? errorDetails() : null)
                .add("ErrorMessage", errorMessage()).add("Status", statusAsString()).add("StatusChangeTime", statusChangeTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusChangeTime":
            return Optional.ofNullable(clazz.cast(statusChangeTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("errorDetails", ERROR_DETAILS_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusChangeTime", STATUS_CHANGE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDraftAppVersionResourcesImportStatusResponse, T> g) {
        return obj -> g.apply((DescribeDraftAppVersionResourcesImportStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDraftAppVersionResourcesImportStatusResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param appVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * List of errors that were encountered while importing resources.
         * </p>
         * 
         * @param errorDetails
         *        List of errors that were encountered while importing resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(Collection<ErrorDetail> errorDetails);

        /**
         * <p>
         * List of errors that were encountered while importing resources.
         * </p>
         * 
         * @param errorDetails
         *        List of errors that were encountered while importing resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetail... errorDetails);

        /**
         * <p>
         * List of errors that were encountered while importing resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.ErrorDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.resiliencehub.model.ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.ErrorDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #errorDetails(List<ErrorDetail>)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(java.util.Collection<ErrorDetail>)
         */
        Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails);

        /**
         * <p>
         * The error message returned for the resource request.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned for the resource request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Status of the action.
         * </p>
         * 
         * @param status
         *        Status of the action.
         * @see ResourceImportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceImportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the action.
         * </p>
         * 
         * @param status
         *        Status of the action.
         * @see ResourceImportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceImportStatusType
         */
        Builder status(ResourceImportStatusType status);

        /**
         * <p>
         * The time when the status last changed.
         * </p>
         * 
         * @param statusChangeTime
         *        The time when the status last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusChangeTime(Instant statusChangeTime);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private String errorMessage;

        private String status;

        private Instant statusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDraftAppVersionResourcesImportStatusResponse model) {
            super(model);
            appArn(model.appArn);
            appVersion(model.appVersion);
            errorDetails(model.errorDetails);
            errorMessage(model.errorMessage);
            status(model.status);
            statusChangeTime(model.statusChangeTime);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetails() {
            List<ErrorDetail.Builder> result = ErrorDetailListCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailListCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailListCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail... errorDetails) {
            errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails) {
            errorDetails(Stream.of(errorDetails).map(c -> ErrorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceImportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStatusChangeTime() {
            return statusChangeTime;
        }

        public final void setStatusChangeTime(Instant statusChangeTime) {
            this.statusChangeTime = statusChangeTime;
        }

        @Override
        public final Builder statusChangeTime(Instant statusChangeTime) {
            this.statusChangeTime = statusChangeTime;
            return this;
        }

        @Override
        public DescribeDraftAppVersionResourcesImportStatusResponse build() {
            return new DescribeDraftAppVersionResourcesImportStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
