/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetricsExportRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<DescribeMetricsExportRequest.Builder, DescribeMetricsExportRequest> {
    private static final SdkField<String> METRICS_EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsExportId").getter(getter(DescribeMetricsExportRequest::metricsExportId))
            .setter(setter(Builder::metricsExportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsExportId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_EXPORT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metricsExportId;

    private DescribeMetricsExportRequest(BuilderImpl builder) {
        super(builder);
        this.metricsExportId = builder.metricsExportId;
    }

    /**
     * <p>
     * Identifier of the metrics export task.
     * </p>
     * 
     * @return Identifier of the metrics export task.
     */
    public final String metricsExportId() {
        return metricsExportId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricsExportId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricsExportRequest)) {
            return false;
        }
        DescribeMetricsExportRequest other = (DescribeMetricsExportRequest) obj;
        return Objects.equals(metricsExportId(), other.metricsExportId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetricsExportRequest").add("MetricsExportId", metricsExportId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricsExportId":
            return Optional.ofNullable(clazz.cast(metricsExportId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricsExportId", METRICS_EXPORT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricsExportRequest, T> g) {
        return obj -> g.apply((DescribeMetricsExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetricsExportRequest> {
        /**
         * <p>
         * Identifier of the metrics export task.
         * </p>
         * 
         * @param metricsExportId
         *        Identifier of the metrics export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsExportId(String metricsExportId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String metricsExportId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricsExportRequest model) {
            super(model);
            metricsExportId(model.metricsExportId);
        }

        public final String getMetricsExportId() {
            return metricsExportId;
        }

        public final void setMetricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
        }

        @Override
        public final Builder metricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMetricsExportRequest build() {
            return new DescribeMetricsExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
