/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResiliencyPolicyResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<DescribeResiliencyPolicyResponse.Builder, DescribeResiliencyPolicyResponse> {
    private static final SdkField<ResiliencyPolicy> POLICY_FIELD = SdkField.<ResiliencyPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("policy").getter(getter(DescribeResiliencyPolicyResponse::policy)).setter(setter(Builder::policy))
            .constructor(ResiliencyPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResiliencyPolicy policy;

    private DescribeResiliencyPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
    }

    /**
     * <p>
     * Information about the specific resiliency policy, returned as an object. This object includes creation time, data
     * location constraints, its name, description, tags, the recovery time objective (RTO) and recovery point objective
     * (RPO) in seconds, and more.
     * </p>
     * 
     * @return Information about the specific resiliency policy, returned as an object. This object includes creation
     *         time, data location constraints, its name, description, tags, the recovery time objective (RTO) and
     *         recovery point objective (RPO) in seconds, and more.
     */
    public final ResiliencyPolicy policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResiliencyPolicyResponse)) {
            return false;
        }
        DescribeResiliencyPolicyResponse other = (DescribeResiliencyPolicyResponse) obj;
        return Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResiliencyPolicyResponse").add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policy", POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResiliencyPolicyResponse, T> g) {
        return obj -> g.apply((DescribeResiliencyPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResiliencyPolicyResponse> {
        /**
         * <p>
         * Information about the specific resiliency policy, returned as an object. This object includes creation time,
         * data location constraints, its name, description, tags, the recovery time objective (RTO) and recovery point
         * objective (RPO) in seconds, and more.
         * </p>
         * 
         * @param policy
         *        Information about the specific resiliency policy, returned as an object. This object includes creation
         *        time, data location constraints, its name, description, tags, the recovery time objective (RTO) and
         *        recovery point objective (RPO) in seconds, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(ResiliencyPolicy policy);

        /**
         * <p>
         * Information about the specific resiliency policy, returned as an object. This object includes creation time,
         * data location constraints, its name, description, tags, the recovery time objective (RTO) and recovery point
         * objective (RPO) in seconds, and more.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResiliencyPolicy.Builder} avoiding the
         * need to create one manually via {@link ResiliencyPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResiliencyPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #policy(ResiliencyPolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link ResiliencyPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(ResiliencyPolicy)
         */
        default Builder policy(Consumer<ResiliencyPolicy.Builder> policy) {
            return policy(ResiliencyPolicy.builder().applyMutation(policy).build());
        }
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private ResiliencyPolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResiliencyPolicyResponse model) {
            super(model);
            policy(model.policy);
        }

        public final ResiliencyPolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(ResiliencyPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(ResiliencyPolicy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public DescribeResiliencyPolicyResponse build() {
            return new DescribeResiliencyPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
