/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceGroupingRecommendationTaskResponse extends ResiliencehubResponse
        implements
        ToCopyableBuilder<DescribeResourceGroupingRecommendationTaskResponse.Builder, DescribeResourceGroupingRecommendationTaskResponse> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(DescribeResourceGroupingRecommendationTaskResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> GROUPING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupingId").getter(getter(DescribeResourceGroupingRecommendationTaskResponse::groupingId))
            .setter(setter(Builder::groupingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeResourceGroupingRecommendationTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            GROUPING_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String errorMessage;

    private final String groupingId;

    private final String status;

    private DescribeResourceGroupingRecommendationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.groupingId = builder.groupingId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Error that occurred while generating a grouping recommendation.
     * </p>
     * 
     * @return Error that occurred while generating a grouping recommendation.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Identifier of the grouping recommendation task.
     * </p>
     * 
     * @return Identifier of the grouping recommendation task.
     */
    public final String groupingId() {
        return groupingId;
    }

    /**
     * <p>
     * Status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourcesGroupingRecGenStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the action.
     * @see ResourcesGroupingRecGenStatusType
     */
    public final ResourcesGroupingRecGenStatusType status() {
        return ResourcesGroupingRecGenStatusType.fromValue(status);
    }

    /**
     * <p>
     * Status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourcesGroupingRecGenStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the action.
     * @see ResourcesGroupingRecGenStatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(groupingId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupingRecommendationTaskResponse)) {
            return false;
        }
        DescribeResourceGroupingRecommendationTaskResponse other = (DescribeResourceGroupingRecommendationTaskResponse) obj;
        return Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(groupingId(), other.groupingId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourceGroupingRecommendationTaskResponse").add("ErrorMessage", errorMessage())
                .add("GroupingId", groupingId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "groupingId":
            return Optional.ofNullable(clazz.cast(groupingId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("groupingId", GROUPING_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceGroupingRecommendationTaskResponse, T> g) {
        return obj -> g.apply((DescribeResourceGroupingRecommendationTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourceGroupingRecommendationTaskResponse> {
        /**
         * <p>
         * Error that occurred while generating a grouping recommendation.
         * </p>
         * 
         * @param errorMessage
         *        Error that occurred while generating a grouping recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Identifier of the grouping recommendation task.
         * </p>
         * 
         * @param groupingId
         *        Identifier of the grouping recommendation task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingId(String groupingId);

        /**
         * <p>
         * Status of the action.
         * </p>
         * 
         * @param status
         *        Status of the action.
         * @see ResourcesGroupingRecGenStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcesGroupingRecGenStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the action.
         * </p>
         * 
         * @param status
         *        Status of the action.
         * @see ResourcesGroupingRecGenStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcesGroupingRecGenStatusType
         */
        Builder status(ResourcesGroupingRecGenStatusType status);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String errorMessage;

        private String groupingId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceGroupingRecommendationTaskResponse model) {
            super(model);
            errorMessage(model.errorMessage);
            groupingId(model.groupingId);
            status(model.status);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getGroupingId() {
            return groupingId;
        }

        public final void setGroupingId(String groupingId) {
            this.groupingId = groupingId;
        }

        @Override
        public final Builder groupingId(String groupingId) {
            this.groupingId = groupingId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourcesGroupingRecGenStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeResourceGroupingRecommendationTaskResponse build() {
            return new DescribeResourceGroupingRecommendationTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
