/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the field or attribute of a resource or data structure on which a condition is being applied or evaluated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Field implements SdkPojo, Serializable, ToCopyableBuilder<Field.Builder, Field> {
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregation").getter(getter(Field::aggregationAsString)).setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregation").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Field::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AGGREGATION_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aggregation;

    private final String name;

    private Field(BuilderImpl builder) {
        this.aggregation = builder.aggregation;
        this.name = builder.name;
    }

    /**
     * <p>
     * (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to be
     * performed on a particular field or set of data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link FieldAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationAsString}.
     * </p>
     * 
     * @return (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to be
     *         performed on a particular field or set of data.
     * @see FieldAggregationType
     */
    public final FieldAggregationType aggregation() {
        return FieldAggregationType.fromValue(aggregation);
    }

    /**
     * <p>
     * (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to be
     * performed on a particular field or set of data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link FieldAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationAsString}.
     * </p>
     * 
     * @return (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to be
     *         performed on a particular field or set of data.
     * @see FieldAggregationType
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    /**
     * <p>
     * Name of the field.
     * </p>
     * 
     * @return Name of the field.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field) obj;
        return Objects.equals(aggregationAsString(), other.aggregationAsString()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Field").add("Aggregation", aggregationAsString()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aggregation", AGGREGATION_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Field> {
        /**
         * <p>
         * (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to be
         * performed on a particular field or set of data.
         * </p>
         * 
         * @param aggregation
         *        (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to
         *        be performed on a particular field or set of data.
         * @see FieldAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldAggregationType
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to be
         * performed on a particular field or set of data.
         * </p>
         * 
         * @param aggregation
         *        (Optional) Indicates the type of aggregation or summary operation (such as Sum, Average, and so on) to
         *        be performed on a particular field or set of data.
         * @see FieldAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldAggregationType
         */
        Builder aggregation(FieldAggregationType aggregation);

        /**
         * <p>
         * Name of the field.
         * </p>
         * 
         * @param name
         *        Name of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String aggregation;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            aggregation(model.aggregation);
            name(model.name);
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(FieldAggregationType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Field build() {
            return new Field(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
