/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportResourcesToDraftAppVersionRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<ImportResourcesToDraftAppVersionRequest.Builder, ImportResourcesToDraftAppVersionRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(ImportResourcesToDraftAppVersionRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<List<EksSource>> EKS_SOURCES_FIELD = SdkField
            .<List<EksSource>> builder(MarshallingType.LIST)
            .memberName("eksSources")
            .getter(getter(ImportResourcesToDraftAppVersionRequest::eksSources))
            .setter(setter(Builder::eksSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EksSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(EksSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMPORT_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importStrategy").getter(getter(ImportResourcesToDraftAppVersionRequest::importStrategyAsString))
            .setter(setter(Builder::importStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStrategy").build()).build();

    private static final SdkField<List<String>> SOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceArns")
            .getter(getter(ImportResourcesToDraftAppVersionRequest::sourceArns))
            .setter(setter(Builder::sourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TerraformSource>> TERRAFORM_SOURCES_FIELD = SdkField
            .<List<TerraformSource>> builder(MarshallingType.LIST)
            .memberName("terraformSources")
            .getter(getter(ImportResourcesToDraftAppVersionRequest::terraformSources))
            .setter(setter(Builder::terraformSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TerraformSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TerraformSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            EKS_SOURCES_FIELD, IMPORT_STRATEGY_FIELD, SOURCE_ARNS_FIELD, TERRAFORM_SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appArn;

    private final List<EksSource> eksSources;

    private final String importStrategy;

    private final List<String> sourceArns;

    private final List<TerraformSource> terraformSources;

    private ImportResourcesToDraftAppVersionRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.eksSources = builder.eksSources;
        this.importStrategy = builder.importStrategy;
        this.sourceArns = builder.sourceArns;
        this.terraformSources = builder.terraformSources;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EksSources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEksSources() {
        return eksSources != null && !(eksSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEksSources} method.
     * </p>
     * 
     * @return The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
     */
    public final List<EksSource> eksSources() {
        return eksSources;
    }

    /**
     * <p>
     * The import strategy you would like to set to import resources into Resilience Hub application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStrategy}
     * will return {@link ResourceImportStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #importStrategyAsString}.
     * </p>
     * 
     * @return The import strategy you would like to set to import resources into Resilience Hub application.
     * @see ResourceImportStrategyType
     */
    public final ResourceImportStrategyType importStrategy() {
        return ResourceImportStrategyType.fromValue(importStrategy);
    }

    /**
     * <p>
     * The import strategy you would like to set to import resources into Resilience Hub application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStrategy}
     * will return {@link ResourceImportStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #importStrategyAsString}.
     * </p>
     * 
     * @return The import strategy you would like to set to import resources into Resilience Hub application.
     * @see ResourceImportStrategyType
     */
    public final String importStrategyAsString() {
        return importStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSourceArns() {
        return sourceArns != null && !(sourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for the resources.
     */
    public final List<String> sourceArns() {
        return sourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerraformSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerraformSources() {
        return terraformSources != null && !(terraformSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of terraform file s3 URLs you need to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerraformSources} method.
     * </p>
     * 
     * @return A list of terraform file s3 URLs you need to import.
     */
    public final List<TerraformSource> terraformSources() {
        return terraformSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEksSources() ? eksSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(importStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceArns() ? sourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTerraformSources() ? terraformSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourcesToDraftAppVersionRequest)) {
            return false;
        }
        ImportResourcesToDraftAppVersionRequest other = (ImportResourcesToDraftAppVersionRequest) obj;
        return Objects.equals(appArn(), other.appArn()) && hasEksSources() == other.hasEksSources()
                && Objects.equals(eksSources(), other.eksSources())
                && Objects.equals(importStrategyAsString(), other.importStrategyAsString())
                && hasSourceArns() == other.hasSourceArns() && Objects.equals(sourceArns(), other.sourceArns())
                && hasTerraformSources() == other.hasTerraformSources()
                && Objects.equals(terraformSources(), other.terraformSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportResourcesToDraftAppVersionRequest").add("AppArn", appArn())
                .add("EksSources", hasEksSources() ? eksSources() : null).add("ImportStrategy", importStrategyAsString())
                .add("SourceArns", hasSourceArns() ? sourceArns() : null)
                .add("TerraformSources", hasTerraformSources() ? terraformSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "eksSources":
            return Optional.ofNullable(clazz.cast(eksSources()));
        case "importStrategy":
            return Optional.ofNullable(clazz.cast(importStrategyAsString()));
        case "sourceArns":
            return Optional.ofNullable(clazz.cast(sourceArns()));
        case "terraformSources":
            return Optional.ofNullable(clazz.cast(terraformSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("eksSources", EKS_SOURCES_FIELD);
        map.put("importStrategy", IMPORT_STRATEGY_FIELD);
        map.put("sourceArns", SOURCE_ARNS_FIELD);
        map.put("terraformSources", TERRAFORM_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportResourcesToDraftAppVersionRequest, T> g) {
        return obj -> g.apply((ImportResourcesToDraftAppVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportResourcesToDraftAppVersionRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
         * </p>
         * 
         * @param eksSources
         *        The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksSources(Collection<EksSource> eksSources);

        /**
         * <p>
         * The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
         * </p>
         * 
         * @param eksSources
         *        The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksSources(EksSource... eksSources);

        /**
         * <p>
         * The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.EksSource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.resiliencehub.model.EksSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.EksSource.Builder#build()} is called immediately
         * and its result is passed to {@link #eksSources(List<EksSource>)}.
         * 
         * @param eksSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.EksSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksSources(java.util.Collection<EksSource>)
         */
        Builder eksSources(Consumer<EksSource.Builder>... eksSources);

        /**
         * <p>
         * The import strategy you would like to set to import resources into Resilience Hub application.
         * </p>
         * 
         * @param importStrategy
         *        The import strategy you would like to set to import resources into Resilience Hub application.
         * @see ResourceImportStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceImportStrategyType
         */
        Builder importStrategy(String importStrategy);

        /**
         * <p>
         * The import strategy you would like to set to import resources into Resilience Hub application.
         * </p>
         * 
         * @param importStrategy
         *        The import strategy you would like to set to import resources into Resilience Hub application.
         * @see ResourceImportStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceImportStrategyType
         */
        Builder importStrategy(ResourceImportStrategyType importStrategy);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the resources.
         * </p>
         * 
         * @param sourceArns
         *        The Amazon Resource Names (ARNs) for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArns(Collection<String> sourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the resources.
         * </p>
         * 
         * @param sourceArns
         *        The Amazon Resource Names (ARNs) for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArns(String... sourceArns);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * 
         * @param terraformSources
         *        A list of terraform file s3 URLs you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSources(Collection<TerraformSource> terraformSources);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * 
         * @param terraformSources
         *        A list of terraform file s3 URLs you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSources(TerraformSource... terraformSources);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource.Builder#build()} is called
         * immediately and its result is passed to {@link #terraformSources(List<TerraformSource>)}.
         * 
         * @param terraformSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terraformSources(java.util.Collection<TerraformSource>)
         */
        Builder terraformSources(Consumer<TerraformSource.Builder>... terraformSources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private List<EksSource> eksSources = DefaultSdkAutoConstructList.getInstance();

        private String importStrategy;

        private List<String> sourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<TerraformSource> terraformSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourcesToDraftAppVersionRequest model) {
            super(model);
            appArn(model.appArn);
            eksSources(model.eksSources);
            importStrategy(model.importStrategy);
            sourceArns(model.sourceArns);
            terraformSources(model.terraformSources);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<EksSource.Builder> getEksSources() {
            List<EksSource.Builder> result = EksSourceListCopier.copyToBuilder(this.eksSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEksSources(Collection<EksSource.BuilderImpl> eksSources) {
            this.eksSources = EksSourceListCopier.copyFromBuilder(eksSources);
        }

        @Override
        public final Builder eksSources(Collection<EksSource> eksSources) {
            this.eksSources = EksSourceListCopier.copy(eksSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksSources(EksSource... eksSources) {
            eksSources(Arrays.asList(eksSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksSources(Consumer<EksSource.Builder>... eksSources) {
            eksSources(Stream.of(eksSources).map(c -> EksSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImportStrategy() {
            return importStrategy;
        }

        public final void setImportStrategy(String importStrategy) {
            this.importStrategy = importStrategy;
        }

        @Override
        public final Builder importStrategy(String importStrategy) {
            this.importStrategy = importStrategy;
            return this;
        }

        @Override
        public final Builder importStrategy(ResourceImportStrategyType importStrategy) {
            this.importStrategy(importStrategy == null ? null : importStrategy.toString());
            return this;
        }

        public final Collection<String> getSourceArns() {
            if (sourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceArns;
        }

        public final void setSourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
        }

        @Override
        public final Builder sourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceArns(String... sourceArns) {
            sourceArns(Arrays.asList(sourceArns));
            return this;
        }

        public final List<TerraformSource.Builder> getTerraformSources() {
            List<TerraformSource.Builder> result = TerraformSourceListCopier.copyToBuilder(this.terraformSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerraformSources(Collection<TerraformSource.BuilderImpl> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copyFromBuilder(terraformSources);
        }

        @Override
        public final Builder terraformSources(Collection<TerraformSource> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copy(terraformSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(TerraformSource... terraformSources) {
            terraformSources(Arrays.asList(terraformSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(Consumer<TerraformSource.Builder>... terraformSources) {
            terraformSources(Stream.of(terraformSources).map(c -> TerraformSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportResourcesToDraftAppVersionRequest build() {
            return new ImportResourcesToDraftAppVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
