/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppVersionAppComponentsResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListAppVersionAppComponentsResponse.Builder, ListAppVersionAppComponentsResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(ListAppVersionAppComponentsResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<List<AppComponent>> APP_COMPONENTS_FIELD = SdkField
            .<List<AppComponent>> builder(MarshallingType.LIST)
            .memberName("appComponents")
            .getter(getter(ListAppVersionAppComponentsResponse::appComponents))
            .setter(setter(Builder::appComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(ListAppVersionAppComponentsResponse::appVersion))
            .setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppVersionAppComponentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_COMPONENTS_FIELD, APP_VERSION_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appArn;

    private final List<AppComponent> appComponents;

    private final String appVersion;

    private final String nextToken;

    private ListAppVersionAppComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appComponents = builder.appComponents;
        this.appVersion = builder.appVersion;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppComponents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppComponents() {
        return appComponents != null && !(appComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines an Application Component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppComponents} method.
     * </p>
     * 
     * @return Defines an Application Component.
     */
    public final List<AppComponent> appComponents() {
        return appComponents;
    }

    /**
     * <p>
     * Resilience Hub application version.
     * </p>
     * 
     * @return Resilience Hub application version.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * Token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return Token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppComponents() ? appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionAppComponentsResponse)) {
            return false;
        }
        ListAppVersionAppComponentsResponse other = (ListAppVersionAppComponentsResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && hasAppComponents() == other.hasAppComponents()
                && Objects.equals(appComponents(), other.appComponents()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppVersionAppComponentsResponse").add("AppArn", appArn())
                .add("AppComponents", hasAppComponents() ? appComponents() : null).add("AppVersion", appVersion())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appComponents":
            return Optional.ofNullable(clazz.cast(appComponents()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("appComponents", APP_COMPONENTS_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionAppComponentsResponse, T> g) {
        return obj -> g.apply((ListAppVersionAppComponentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAppVersionAppComponentsResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Defines an Application Component.
         * </p>
         * 
         * @param appComponents
         *        Defines an Application Component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponents(Collection<AppComponent> appComponents);

        /**
         * <p>
         * Defines an Application Component.
         * </p>
         * 
         * @param appComponents
         *        Defines an Application Component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponents(AppComponent... appComponents);

        /**
         * <p>
         * Defines an Application Component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #appComponents(List<AppComponent>)}.
         * 
         * @param appComponents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appComponents(java.util.Collection<AppComponent>)
         */
        Builder appComponents(Consumer<AppComponent.Builder>... appComponents);

        /**
         * <p>
         * Resilience Hub application version.
         * </p>
         * 
         * @param appVersion
         *        Resilience Hub application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * Token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private List<AppComponent> appComponents = DefaultSdkAutoConstructList.getInstance();

        private String appVersion;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionAppComponentsResponse model) {
            super(model);
            appArn(model.appArn);
            appComponents(model.appComponents);
            appVersion(model.appVersion);
            nextToken(model.nextToken);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<AppComponent.Builder> getAppComponents() {
            List<AppComponent.Builder> result = AppComponentListCopier.copyToBuilder(this.appComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppComponents(Collection<AppComponent.BuilderImpl> appComponents) {
            this.appComponents = AppComponentListCopier.copyFromBuilder(appComponents);
        }

        @Override
        public final Builder appComponents(Collection<AppComponent> appComponents) {
            this.appComponents = AppComponentListCopier.copy(appComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(AppComponent... appComponents) {
            appComponents(Arrays.asList(appComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(Consumer<AppComponent.Builder>... appComponents) {
            appComponents(Stream.of(appComponents).map(c -> AppComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppVersionAppComponentsResponse build() {
            return new ListAppVersionAppComponentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
