/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a physical resource identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhysicalResourceId implements SdkPojo, Serializable,
        ToCopyableBuilder<PhysicalResourceId.Builder, PhysicalResourceId> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(PhysicalResourceId::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsRegion").getter(getter(PhysicalResourceId::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(PhysicalResourceId::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PhysicalResourceId::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_REGION_FIELD, IDENTIFIER_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String awsRegion;

    private final String identifier;

    private final String type;

    private PhysicalResourceId(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsRegion = builder.awsRegion;
        this.identifier = builder.identifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Web Services account that owns the physical resource.
     * </p>
     * 
     * @return The Amazon Web Services account that owns the physical resource.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region that the physical resource is located in.
     * </p>
     * 
     * @return The Amazon Web Services Region that the physical resource is located in.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * Identifier of the physical resource.
     * </p>
     * 
     * @return Identifier of the physical resource.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Specifies the type of physical resource identifier.
     * </p>
     * <dl>
     * <dt>Arn</dt>
     * <dd>
     * <p>
     * The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::ECS::Service</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EFS::FileSystem</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Lambda::Function</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::SNS::Topic</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Native</dt>
     * <dd>
     * <p>
     * The resource identifier is an Resilience Hub-native identifier and it can identify the following list of
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::ApiGateway::RestApi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::ApiGatewayV2::Api</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::AutoScaling::AutoScalingGroup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DocDB::DBCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DocDB::DBGlobalCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DocDB::DBInstance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::GlobalTable</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::EC2Fleet</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::Instance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::NatGateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::Volume</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBInstance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::GlobalCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Route53::RecordSet</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3::Bucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::SQS::Queue</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PhysicalIdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of physical resource identifier.</p>
     *         <dl>
     *         <dt>Arn</dt>
     *         <dd>
     *         <p>
     *         The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of
     *         resources:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS::ECS::Service</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EFS::FileSystem</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::Lambda::Function</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::SNS::Topic</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Native</dt>
     *         <dd>
     *         <p>
     *         The resource identifier is an Resilience Hub-native identifier and it can identify the following list of
     *         resources:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS::ApiGateway::RestApi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::ApiGatewayV2::Api</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::AutoScaling::AutoScalingGroup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DocDB::DBCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DocDB::DBGlobalCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DocDB::DBInstance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::GlobalTable</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::EC2Fleet</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::Instance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::NatGateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::Volume</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBInstance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::GlobalCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::Route53::RecordSet</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3::Bucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::SQS::Queue</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     * @see PhysicalIdentifierType
     */
    public final PhysicalIdentifierType type() {
        return PhysicalIdentifierType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of physical resource identifier.
     * </p>
     * <dl>
     * <dt>Arn</dt>
     * <dd>
     * <p>
     * The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::ECS::Service</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EFS::FileSystem</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Lambda::Function</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::SNS::Topic</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Native</dt>
     * <dd>
     * <p>
     * The resource identifier is an Resilience Hub-native identifier and it can identify the following list of
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::ApiGateway::RestApi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::ApiGatewayV2::Api</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::AutoScaling::AutoScalingGroup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DocDB::DBCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DocDB::DBGlobalCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DocDB::DBInstance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::GlobalTable</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::EC2Fleet</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::Instance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::NatGateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::Volume</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::DBInstance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::RDS::GlobalCluster</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Route53::RecordSet</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3::Bucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::SQS::Queue</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PhysicalIdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of physical resource identifier.</p>
     *         <dl>
     *         <dt>Arn</dt>
     *         <dd>
     *         <p>
     *         The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of
     *         resources:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS::ECS::Service</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EFS::FileSystem</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::Lambda::Function</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::SNS::Topic</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Native</dt>
     *         <dd>
     *         <p>
     *         The resource identifier is an Resilience Hub-native identifier and it can identify the following list of
     *         resources:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS::ApiGateway::RestApi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::ApiGatewayV2::Api</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::AutoScaling::AutoScalingGroup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DocDB::DBCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DocDB::DBGlobalCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DocDB::DBInstance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::GlobalTable</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::EC2Fleet</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::Instance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::NatGateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::Volume</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::DBInstance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::RDS::GlobalCluster</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::Route53::RecordSet</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3::Bucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::SQS::Queue</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     * @see PhysicalIdentifierType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalResourceId)) {
            return false;
        }
        PhysicalResourceId other = (PhysicalResourceId) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhysicalResourceId").add("AwsAccountId", awsAccountId()).add("AwsRegion", awsRegion())
                .add("Identifier", identifier()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalResourceId, T> g) {
        return obj -> g.apply((PhysicalResourceId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhysicalResourceId> {
        /**
         * <p>
         * The Amazon Web Services account that owns the physical resource.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account that owns the physical resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services Region that the physical resource is located in.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services Region that the physical resource is located in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * Identifier of the physical resource.
         * </p>
         * 
         * @param identifier
         *        Identifier of the physical resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Specifies the type of physical resource identifier.
         * </p>
         * <dl>
         * <dt>Arn</dt>
         * <dd>
         * <p>
         * The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::ECS::Service</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EFS::FileSystem</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::Lambda::Function</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::SNS::Topic</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Native</dt>
         * <dd>
         * <p>
         * The resource identifier is an Resilience Hub-native identifier and it can identify the following list of
         * resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::ApiGateway::RestApi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::ApiGatewayV2::Api</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::AutoScaling::AutoScalingGroup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DocDB::DBCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DocDB::DBGlobalCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DocDB::DBInstance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::GlobalTable</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::EC2Fleet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::Instance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::NatGateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::Volume</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBInstance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::GlobalCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::Route53::RecordSet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3::Bucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::SQS::Queue</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param type
         *        Specifies the type of physical resource identifier.</p>
         *        <dl>
         *        <dt>Arn</dt>
         *        <dd>
         *        <p>
         *        The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of
         *        resources:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::ECS::Service</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EFS::FileSystem</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::Lambda::Function</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::SNS::Topic</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Native</dt>
         *        <dd>
         *        <p>
         *        The resource identifier is an Resilience Hub-native identifier and it can identify the following list
         *        of resources:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::ApiGateway::RestApi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::ApiGatewayV2::Api</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::AutoScaling::AutoScalingGroup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DocDB::DBCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DocDB::DBGlobalCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DocDB::DBInstance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::GlobalTable</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::EC2Fleet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::Instance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::NatGateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::Volume</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBInstance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::GlobalCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::Route53::RecordSet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3::Bucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::SQS::Queue</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @see PhysicalIdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhysicalIdentifierType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of physical resource identifier.
         * </p>
         * <dl>
         * <dt>Arn</dt>
         * <dd>
         * <p>
         * The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::ECS::Service</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EFS::FileSystem</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::Lambda::Function</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::SNS::Topic</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Native</dt>
         * <dd>
         * <p>
         * The resource identifier is an Resilience Hub-native identifier and it can identify the following list of
         * resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::ApiGateway::RestApi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::ApiGatewayV2::Api</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::AutoScaling::AutoScalingGroup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DocDB::DBCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DocDB::DBGlobalCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DocDB::DBInstance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::GlobalTable</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::EC2Fleet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::Instance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::NatGateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::Volume</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::DBInstance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::RDS::GlobalCluster</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::Route53::RecordSet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3::Bucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::SQS::Queue</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param type
         *        Specifies the type of physical resource identifier.</p>
         *        <dl>
         *        <dt>Arn</dt>
         *        <dd>
         *        <p>
         *        The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of
         *        resources:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::ECS::Service</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EFS::FileSystem</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::Lambda::Function</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::SNS::Topic</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Native</dt>
         *        <dd>
         *        <p>
         *        The resource identifier is an Resilience Hub-native identifier and it can identify the following list
         *        of resources:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::ApiGateway::RestApi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::ApiGatewayV2::Api</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::AutoScaling::AutoScalingGroup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DocDB::DBCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DocDB::DBGlobalCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DocDB::DBInstance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::GlobalTable</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::EC2Fleet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::Instance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::NatGateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::Volume</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::ElasticLoadBalancing::LoadBalancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::DBInstance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::RDS::GlobalCluster</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::Route53::RecordSet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3::Bucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::SQS::Queue</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @see PhysicalIdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhysicalIdentifierType
         */
        Builder type(PhysicalIdentifierType type);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsRegion;

        private String identifier;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalResourceId model) {
            awsAccountId(model.awsAccountId);
            awsRegion(model.awsRegion);
            identifier(model.identifier);
            type(model.type);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PhysicalIdentifierType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public PhysicalResourceId build() {
            return new PhysicalResourceId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
