/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the sorting order of the fields in the metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sort implements SdkPojo, Serializable, ToCopyableBuilder<Sort.Builder, Sort> {
    private static final SdkField<Boolean> ASCENDING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ascending").getter(getter(Sort::ascending)).setter(setter(Builder::ascending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ascending").build()).build();

    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(Sort::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASCENDING_FIELD, FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean ascending;

    private final String field;

    private Sort(BuilderImpl builder) {
        this.ascending = builder.ascending;
        this.field = builder.field;
    }

    /**
     * <p>
     * Indicates the name or identifier of the field or attribute that should be used as the basis for sorting the
     * metrics.
     * </p>
     * 
     * @return Indicates the name or identifier of the field or attribute that should be used as the basis for sorting
     *         the metrics.
     */
    public final Boolean ascending() {
        return ascending;
    }

    /**
     * <p>
     * Indicates the order in which you want to sort the metrics. By default, the list is sorted in ascending order. To
     * sort the list in descending order, set this field to False.
     * </p>
     * 
     * @return Indicates the order in which you want to sort the metrics. By default, the list is sorted in ascending
     *         order. To sort the list in descending order, set this field to False.
     */
    public final String field() {
        return field;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ascending());
        hashCode = 31 * hashCode + Objects.hashCode(field());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort) obj;
        return Objects.equals(ascending(), other.ascending()) && Objects.equals(field(), other.field());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Sort").add("Ascending", ascending()).add("Field", field()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ascending":
            return Optional.ofNullable(clazz.cast(ascending()));
        case "field":
            return Optional.ofNullable(clazz.cast(field()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ascending", ASCENDING_FIELD);
        map.put("field", FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sort, T> g) {
        return obj -> g.apply((Sort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sort> {
        /**
         * <p>
         * Indicates the name or identifier of the field or attribute that should be used as the basis for sorting the
         * metrics.
         * </p>
         * 
         * @param ascending
         *        Indicates the name or identifier of the field or attribute that should be used as the basis for
         *        sorting the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascending(Boolean ascending);

        /**
         * <p>
         * Indicates the order in which you want to sort the metrics. By default, the list is sorted in ascending order.
         * To sort the list in descending order, set this field to False.
         * </p>
         * 
         * @param field
         *        Indicates the order in which you want to sort the metrics. By default, the list is sorted in ascending
         *        order. To sort the list in descending order, set this field to False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);
    }

    static final class BuilderImpl implements Builder {
        private Boolean ascending;

        private String field;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            ascending(model.ascending);
            field(model.field);
        }

        public final Boolean getAscending() {
            return ascending;
        }

        public final void setAscending(Boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public final Builder ascending(Boolean ascending) {
            this.ascending = ascending;
            return this;
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public Sort build() {
            return new Sort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
