/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMetricsExportResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<StartMetricsExportResponse.Builder, StartMetricsExportResponse> {
    private static final SdkField<String> METRICS_EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsExportId").getter(getter(StartMetricsExportResponse::metricsExportId))
            .setter(setter(Builder::metricsExportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsExportId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StartMetricsExportResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_EXPORT_ID_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metricsExportId;

    private final String status;

    private StartMetricsExportResponse(BuilderImpl builder) {
        super(builder);
        this.metricsExportId = builder.metricsExportId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Identifier of the metrics export task.
     * </p>
     * 
     * @return Identifier of the metrics export task.
     */
    public final String metricsExportId() {
        return metricsExportId;
    }

    /**
     * <p>
     * Indicates the status of the metrics export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetricsExportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the metrics export task.
     * @see MetricsExportStatusType
     */
    public final MetricsExportStatusType status() {
        return MetricsExportStatusType.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the metrics export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetricsExportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the metrics export task.
     * @see MetricsExportStatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricsExportId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetricsExportResponse)) {
            return false;
        }
        StartMetricsExportResponse other = (StartMetricsExportResponse) obj;
        return Objects.equals(metricsExportId(), other.metricsExportId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMetricsExportResponse").add("MetricsExportId", metricsExportId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricsExportId":
            return Optional.ofNullable(clazz.cast(metricsExportId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricsExportId", METRICS_EXPORT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMetricsExportResponse, T> g) {
        return obj -> g.apply((StartMetricsExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartMetricsExportResponse> {
        /**
         * <p>
         * Identifier of the metrics export task.
         * </p>
         * 
         * @param metricsExportId
         *        Identifier of the metrics export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsExportId(String metricsExportId);

        /**
         * <p>
         * Indicates the status of the metrics export task.
         * </p>
         * 
         * @param status
         *        Indicates the status of the metrics export task.
         * @see MetricsExportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsExportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the metrics export task.
         * </p>
         * 
         * @param status
         *        Indicates the status of the metrics export task.
         * @see MetricsExportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsExportStatusType
         */
        Builder status(MetricsExportStatusType status);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String metricsExportId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetricsExportResponse model) {
            super(model);
            metricsExportId(model.metricsExportId);
            status(model.status);
        }

        public final String getMetricsExportId() {
            return metricsExportId;
        }

        public final void setMetricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
        }

        @Override
        public final Builder metricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetricsExportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StartMetricsExportResponse build() {
            return new StartMetricsExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
