/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Terraform s3 state file you need to import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerraformSource implements SdkPojo, Serializable, ToCopyableBuilder<TerraformSource.Builder, TerraformSource> {
    private static final SdkField<String> S3_STATE_FILE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3StateFileUrl").getter(getter(TerraformSource::s3StateFileUrl)).setter(setter(Builder::s3StateFileUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3StateFileUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_STATE_FILE_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3StateFileUrl;

    private TerraformSource(BuilderImpl builder) {
        this.s3StateFileUrl = builder.s3StateFileUrl;
    }

    /**
     * <p>
     * The URL of the Terraform s3 state file you need to import.
     * </p>
     * 
     * @return The URL of the Terraform s3 state file you need to import.
     */
    public final String s3StateFileUrl() {
        return s3StateFileUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3StateFileUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerraformSource)) {
            return false;
        }
        TerraformSource other = (TerraformSource) obj;
        return Objects.equals(s3StateFileUrl(), other.s3StateFileUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerraformSource").add("S3StateFileUrl", s3StateFileUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3StateFileUrl":
            return Optional.ofNullable(clazz.cast(s3StateFileUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3StateFileUrl", S3_STATE_FILE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TerraformSource, T> g) {
        return obj -> g.apply((TerraformSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TerraformSource> {
        /**
         * <p>
         * The URL of the Terraform s3 state file you need to import.
         * </p>
         * 
         * @param s3StateFileUrl
         *        The URL of the Terraform s3 state file you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3StateFileUrl(String s3StateFileUrl);
    }

    static final class BuilderImpl implements Builder {
        private String s3StateFileUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(TerraformSource model) {
            s3StateFileUrl(model.s3StateFileUrl);
        }

        public final String getS3StateFileUrl() {
            return s3StateFileUrl;
        }

        public final void setS3StateFileUrl(String s3StateFileUrl) {
            this.s3StateFileUrl = s3StateFileUrl;
        }

        @Override
        public final Builder s3StateFileUrl(String s3StateFileUrl) {
            this.s3StateFileUrl = s3StateFileUrl;
            return this;
        }

        @Override
        public TerraformSource build() {
            return new TerraformSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
