/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<UpdateAppRequest.Builder, UpdateAppRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(UpdateAppRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> ASSESSMENT_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentSchedule").getter(getter(UpdateAppRequest::assessmentScheduleAsString))
            .setter(setter(Builder::assessmentSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSchedule").build())
            .build();

    private static final SdkField<Boolean> CLEAR_RESILIENCY_POLICY_ARN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("clearResiliencyPolicyArn")
            .getter(getter(UpdateAppRequest::clearResiliencyPolicyArn)).setter(setter(Builder::clearResiliencyPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clearResiliencyPolicyArn").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_FIELD = SdkField
            .<List<EventSubscription>> builder(MarshallingType.LIST)
            .memberName("eventSubscriptions")
            .getter(getter(UpdateAppRequest::eventSubscriptions))
            .setter(setter(Builder::eventSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PermissionModel> PERMISSION_MODEL_FIELD = SdkField
            .<PermissionModel> builder(MarshallingType.SDK_POJO).memberName("permissionModel")
            .getter(getter(UpdateAppRequest::permissionModel)).setter(setter(Builder::permissionModel))
            .constructor(PermissionModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionModel").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(UpdateAppRequest::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            ASSESSMENT_SCHEDULE_FIELD, CLEAR_RESILIENCY_POLICY_ARN_FIELD, DESCRIPTION_FIELD, EVENT_SUBSCRIPTIONS_FIELD,
            PERMISSION_MODEL_FIELD, POLICY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appArn;

    private final String assessmentSchedule;

    private final Boolean clearResiliencyPolicyArn;

    private final String description;

    private final List<EventSubscription> eventSubscriptions;

    private final PermissionModel permissionModel;

    private final String policyArn;

    private UpdateAppRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.assessmentSchedule = builder.assessmentSchedule;
        this.clearResiliencyPolicyArn = builder.clearResiliencyPolicyArn;
        this.description = builder.description;
        this.eventSubscriptions = builder.eventSubscriptions;
        this.permissionModel = builder.permissionModel;
        this.policyArn = builder.policyArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final AppAssessmentScheduleType assessmentSchedule() {
        return AppAssessmentScheduleType.fromValue(assessmentSchedule);
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final String assessmentScheduleAsString() {
        return assessmentSchedule;
    }

    /**
     * <p>
     * Specifies if the resiliency policy ARN should be cleared.
     * </p>
     * 
     * @return Specifies if the resiliency policy ARN should be cleared.
     */
    public final Boolean clearResiliencyPolicyArn() {
        return clearResiliencyPolicyArn;
    }

    /**
     * <p>
     * The optional description for an app.
     * </p>
     * 
     * @return The optional description for an app.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSubscriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSubscriptions() {
        return eventSubscriptions != null && !(eventSubscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
     * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSubscriptions} method.
     * </p>
     * 
     * @return The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
     *         supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
     */
    public final List<EventSubscription> eventSubscriptions() {
        return eventSubscriptions;
    }

    /**
     * <p>
     * Defines the roles and credentials that Resilience Hub would use while creating an application, importing its
     * resources, and running an assessment.
     * </p>
     * 
     * @return Defines the roles and credentials that Resilience Hub would use while creating an application, importing
     *         its resources, and running an assessment.
     */
    public final PermissionModel permissionModel() {
        return permissionModel;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
     *         <code>policy-id</code>. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String policyArn() {
        return policyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clearResiliencyPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSubscriptions() ? eventSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(permissionModel());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest) obj;
        return Objects.equals(appArn(), other.appArn())
                && Objects.equals(assessmentScheduleAsString(), other.assessmentScheduleAsString())
                && Objects.equals(clearResiliencyPolicyArn(), other.clearResiliencyPolicyArn())
                && Objects.equals(description(), other.description()) && hasEventSubscriptions() == other.hasEventSubscriptions()
                && Objects.equals(eventSubscriptions(), other.eventSubscriptions())
                && Objects.equals(permissionModel(), other.permissionModel()) && Objects.equals(policyArn(), other.policyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppRequest").add("AppArn", appArn())
                .add("AssessmentSchedule", assessmentScheduleAsString())
                .add("ClearResiliencyPolicyArn", clearResiliencyPolicyArn()).add("Description", description())
                .add("EventSubscriptions", hasEventSubscriptions() ? eventSubscriptions() : null)
                .add("PermissionModel", permissionModel()).add("PolicyArn", policyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "assessmentSchedule":
            return Optional.ofNullable(clazz.cast(assessmentScheduleAsString()));
        case "clearResiliencyPolicyArn":
            return Optional.ofNullable(clazz.cast(clearResiliencyPolicyArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "eventSubscriptions":
            return Optional.ofNullable(clazz.cast(eventSubscriptions()));
        case "permissionModel":
            return Optional.ofNullable(clazz.cast(permissionModel()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("assessmentSchedule", ASSESSMENT_SCHEDULE_FIELD);
        map.put("clearResiliencyPolicyArn", CLEAR_RESILIENCY_POLICY_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("eventSubscriptions", EVENT_SUBSCRIPTIONS_FIELD);
        map.put("permissionModel", PERMISSION_MODEL_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppRequest, T> g) {
        return obj -> g.apply((UpdateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAppRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(String assessmentSchedule);

        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule);

        /**
         * <p>
         * Specifies if the resiliency policy ARN should be cleared.
         * </p>
         * 
         * @param clearResiliencyPolicyArn
         *        Specifies if the resiliency policy ARN should be cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clearResiliencyPolicyArn(Boolean clearResiliencyPolicyArn);

        /**
         * <p>
         * The optional description for an app.
         * </p>
         * 
         * @param description
         *        The optional description for an app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(EventSubscription... eventSubscriptions);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder#build()} is called
         * immediately and its result is passed to {@link #eventSubscriptions(List<EventSubscription>)}.
         * 
         * @param eventSubscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSubscriptions(java.util.Collection<EventSubscription>)
         */
        Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions);

        /**
         * <p>
         * Defines the roles and credentials that Resilience Hub would use while creating an application, importing its
         * resources, and running an assessment.
         * </p>
         * 
         * @param permissionModel
         *        Defines the roles and credentials that Resilience Hub would use while creating an application,
         *        importing its resources, and running an assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionModel(PermissionModel permissionModel);

        /**
         * <p>
         * Defines the roles and credentials that Resilience Hub would use while creating an application, importing its
         * resources, and running an assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionModel.Builder} avoiding the
         * need to create one manually via {@link PermissionModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionModel.Builder#build()} is called immediately and its
         * result is passed to {@link #permissionModel(PermissionModel)}.
         * 
         * @param permissionModel
         *        a consumer that will call methods on {@link PermissionModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionModel(PermissionModel)
         */
        default Builder permissionModel(Consumer<PermissionModel.Builder> permissionModel) {
            return permissionModel(PermissionModel.builder().applyMutation(permissionModel).build());
        }

        /**
         * <p>
         * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param policyArn
         *        Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
         *        <code>policy-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private String assessmentSchedule;

        private Boolean clearResiliencyPolicyArn;

        private String description;

        private List<EventSubscription> eventSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private PermissionModel permissionModel;

        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppRequest model) {
            super(model);
            appArn(model.appArn);
            assessmentSchedule(model.assessmentSchedule);
            clearResiliencyPolicyArn(model.clearResiliencyPolicyArn);
            description(model.description);
            eventSubscriptions(model.eventSubscriptions);
            permissionModel(model.permissionModel);
            policyArn(model.policyArn);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentSchedule() {
            return assessmentSchedule;
        }

        public final void setAssessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
        }

        @Override
        public final Builder assessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
            return this;
        }

        @Override
        public final Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
            this.assessmentSchedule(assessmentSchedule == null ? null : assessmentSchedule.toString());
            return this;
        }

        public final Boolean getClearResiliencyPolicyArn() {
            return clearResiliencyPolicyArn;
        }

        public final void setClearResiliencyPolicyArn(Boolean clearResiliencyPolicyArn) {
            this.clearResiliencyPolicyArn = clearResiliencyPolicyArn;
        }

        @Override
        public final Builder clearResiliencyPolicyArn(Boolean clearResiliencyPolicyArn) {
            this.clearResiliencyPolicyArn = clearResiliencyPolicyArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptions() {
            List<EventSubscription.Builder> result = EventSubscriptionListCopier.copyToBuilder(this.eventSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptions(Collection<EventSubscription.BuilderImpl> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copyFromBuilder(eventSubscriptions);
        }

        @Override
        public final Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copy(eventSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(EventSubscription... eventSubscriptions) {
            eventSubscriptions(Arrays.asList(eventSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions) {
            eventSubscriptions(Stream.of(eventSubscriptions).map(c -> EventSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PermissionModel.Builder getPermissionModel() {
            return permissionModel != null ? permissionModel.toBuilder() : null;
        }

        public final void setPermissionModel(PermissionModel.BuilderImpl permissionModel) {
            this.permissionModel = permissionModel != null ? permissionModel.build() : null;
        }

        @Override
        public final Builder permissionModel(PermissionModel permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppRequest build() {
            return new UpdateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
