/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.SopRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.SopRecommendationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSopRecommendationsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListSopRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSopRecommendationsResponse.getter(ListSopRecommendationsResponse::nextToken)).setter(ListSopRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SopRecommendation>> SOP_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sopRecommendations").getter(ListSopRecommendationsResponse.getter(ListSopRecommendationsResponse::sopRecommendations)).setter(ListSopRecommendationsResponse.setter(Builder::sopRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sopRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SopRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SOP_RECOMMENDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSopRecommendationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SopRecommendation> sopRecommendations;

    private ListSopRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sopRecommendations = builder.sopRecommendations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSopRecommendations() {
        return this.sopRecommendations != null && !(this.sopRecommendations instanceof SdkAutoConstructList);
    }

    public final List<SopRecommendation> sopRecommendations() {
        return this.sopRecommendations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSopRecommendations() ? this.sopRecommendations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSopRecommendationsResponse)) {
            return false;
        }
        ListSopRecommendationsResponse other = (ListSopRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSopRecommendations() == other.hasSopRecommendations() && Objects.equals(this.sopRecommendations(), other.sopRecommendations());
    }

    public final String toString() {
        return ToString.builder((String)"ListSopRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("SopRecommendations", this.hasSopRecommendations() ? this.sopRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sopRecommendations": {
                return Optional.ofNullable(clazz.cast(this.sopRecommendations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sopRecommendations", SOP_RECOMMENDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSopRecommendationsResponse, T> g) {
        return obj -> g.apply((ListSopRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SopRecommendation> sopRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSopRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sopRecommendations(model.sopRecommendations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SopRecommendation.Builder> getSopRecommendations() {
            List<SopRecommendation.Builder> result = SopRecommendationListCopier.copyToBuilder(this.sopRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSopRecommendations(Collection<SopRecommendation.BuilderImpl> sopRecommendations) {
            this.sopRecommendations = SopRecommendationListCopier.copyFromBuilder(sopRecommendations);
        }

        @Override
        public final Builder sopRecommendations(Collection<SopRecommendation> sopRecommendations) {
            this.sopRecommendations = SopRecommendationListCopier.copy(sopRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sopRecommendations(SopRecommendation ... sopRecommendations) {
            this.sopRecommendations(Arrays.asList(sopRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sopRecommendations(Consumer<SopRecommendation.Builder> ... sopRecommendations) {
            this.sopRecommendations(Stream.of(sopRecommendations).map(c -> (SopRecommendation)((SopRecommendation.Builder)SopRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSopRecommendationsResponse build() {
            return new ListSopRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSopRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder sopRecommendations(Collection<SopRecommendation> var1);

        public Builder sopRecommendations(SopRecommendation ... var1);

        public Builder sopRecommendations(Consumer<SopRecommendation.Builder> ... var1);
    }
}

