/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppComponent;
import software.amazon.awssdk.services.resiliencehub.model.AppComponentListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppVersionAppComponentsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppVersionAppComponentsResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ListAppVersionAppComponentsResponse.getter(ListAppVersionAppComponentsResponse::appArn)).setter(ListAppVersionAppComponentsResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<AppComponent>> APP_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appComponents").getter(ListAppVersionAppComponentsResponse.getter(ListAppVersionAppComponentsResponse::appComponents)).setter(ListAppVersionAppComponentsResponse.setter(Builder::appComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(ListAppVersionAppComponentsResponse.getter(ListAppVersionAppComponentsResponse::appVersion)).setter(ListAppVersionAppComponentsResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppVersionAppComponentsResponse.getter(ListAppVersionAppComponentsResponse::nextToken)).setter(ListAppVersionAppComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_COMPONENTS_FIELD, APP_VERSION_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAppVersionAppComponentsResponse.memberNameToFieldInitializer();
    private final String appArn;
    private final List<AppComponent> appComponents;
    private final String appVersion;
    private final String nextToken;

    private ListAppVersionAppComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appComponents = builder.appComponents;
        this.appVersion = builder.appVersion;
        this.nextToken = builder.nextToken;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasAppComponents() {
        return this.appComponents != null && !(this.appComponents instanceof SdkAutoConstructList);
    }

    public final List<AppComponent> appComponents() {
        return this.appComponents;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppComponents() ? this.appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionAppComponentsResponse)) {
            return false;
        }
        ListAppVersionAppComponentsResponse other = (ListAppVersionAppComponentsResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && this.hasAppComponents() == other.hasAppComponents() && Objects.equals(this.appComponents(), other.appComponents()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppVersionAppComponentsResponse").add("AppArn", (Object)this.appArn()).add("AppComponents", this.hasAppComponents() ? this.appComponents() : null).add("AppVersion", (Object)this.appVersion()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appComponents": {
                return Optional.ofNullable(clazz.cast(this.appComponents()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("appComponents", APP_COMPONENTS_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionAppComponentsResponse, T> g) {
        return obj -> g.apply((ListAppVersionAppComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private List<AppComponent> appComponents = DefaultSdkAutoConstructList.getInstance();
        private String appVersion;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionAppComponentsResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appComponents(model.appComponents);
            this.appVersion(model.appVersion);
            this.nextToken(model.nextToken);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<AppComponent.Builder> getAppComponents() {
            List<AppComponent.Builder> result = AppComponentListCopier.copyToBuilder(this.appComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppComponents(Collection<AppComponent.BuilderImpl> appComponents) {
            this.appComponents = AppComponentListCopier.copyFromBuilder(appComponents);
        }

        @Override
        public final Builder appComponents(Collection<AppComponent> appComponents) {
            this.appComponents = AppComponentListCopier.copy(appComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(AppComponent ... appComponents) {
            this.appComponents(Arrays.asList(appComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(Consumer<AppComponent.Builder> ... appComponents) {
            this.appComponents(Stream.of(appComponents).map(c -> (AppComponent)((AppComponent.Builder)AppComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppVersionAppComponentsResponse build() {
            return new ListAppVersionAppComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppVersionAppComponentsResponse> {
        public Builder appArn(String var1);

        public Builder appComponents(Collection<AppComponent> var1);

        public Builder appComponents(AppComponent ... var1);

        public Builder appComponents(Consumer<AppComponent.Builder> ... var1);

        public Builder appVersion(String var1);

        public Builder nextToken(String var1);
    }
}

