/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.DataLocationConstraint;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionPolicyCopier;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.FailurePolicy;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyPolicyTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResiliencyPolicyRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, UpdateResiliencyPolicyRequest> {
    private static final SdkField<String> DATA_LOCATION_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataLocationConstraint").getter(UpdateResiliencyPolicyRequest.getter(UpdateResiliencyPolicyRequest::dataLocationConstraintAsString)).setter(UpdateResiliencyPolicyRequest.setter(Builder::dataLocationConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocationConstraint").build()}).build();
    private static final SdkField<Map<String, FailurePolicy>> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("policy").getter(UpdateResiliencyPolicyRequest.getter(UpdateResiliencyPolicyRequest::policyAsStrings)).setter(UpdateResiliencyPolicyRequest.setter(Builder::policyWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailurePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(UpdateResiliencyPolicyRequest.getter(UpdateResiliencyPolicyRequest::policyArn)).setter(UpdateResiliencyPolicyRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> POLICY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDescription").getter(UpdateResiliencyPolicyRequest.getter(UpdateResiliencyPolicyRequest::policyDescription)).setter(UpdateResiliencyPolicyRequest.setter(Builder::policyDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDescription").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(UpdateResiliencyPolicyRequest.getter(UpdateResiliencyPolicyRequest::policyName)).setter(UpdateResiliencyPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(UpdateResiliencyPolicyRequest.getter(UpdateResiliencyPolicyRequest::tierAsString)).setter(UpdateResiliencyPolicyRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LOCATION_CONSTRAINT_FIELD, POLICY_FIELD, POLICY_ARN_FIELD, POLICY_DESCRIPTION_FIELD, POLICY_NAME_FIELD, TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResiliencyPolicyRequest.memberNameToFieldInitializer();
    private final String dataLocationConstraint;
    private final Map<String, FailurePolicy> policy;
    private final String policyArn;
    private final String policyDescription;
    private final String policyName;
    private final String tier;

    private UpdateResiliencyPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.dataLocationConstraint = builder.dataLocationConstraint;
        this.policy = builder.policy;
        this.policyArn = builder.policyArn;
        this.policyDescription = builder.policyDescription;
        this.policyName = builder.policyName;
        this.tier = builder.tier;
    }

    public final DataLocationConstraint dataLocationConstraint() {
        return DataLocationConstraint.fromValue(this.dataLocationConstraint);
    }

    public final String dataLocationConstraintAsString() {
        return this.dataLocationConstraint;
    }

    public final Map<DisruptionType, FailurePolicy> policy() {
        return DisruptionPolicyCopier.copyStringToEnum(this.policy);
    }

    public final boolean hasPolicy() {
        return this.policy != null && !(this.policy instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailurePolicy> policyAsStrings() {
        return this.policy;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String policyDescription() {
        return this.policyDescription;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final ResiliencyPolicyTier tier() {
        return ResiliencyPolicyTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocationConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicy() ? this.policyAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResiliencyPolicyRequest)) {
            return false;
        }
        UpdateResiliencyPolicyRequest other = (UpdateResiliencyPolicyRequest)((Object)obj);
        return Objects.equals(this.dataLocationConstraintAsString(), other.dataLocationConstraintAsString()) && this.hasPolicy() == other.hasPolicy() && Objects.equals(this.policyAsStrings(), other.policyAsStrings()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyDescription(), other.policyDescription()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.tierAsString(), other.tierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResiliencyPolicyRequest").add("DataLocationConstraint", (Object)this.dataLocationConstraintAsString()).add("Policy", this.hasPolicy() ? this.policyAsStrings() : null).add("PolicyArn", (Object)this.policyArn()).add("PolicyDescription", (Object)this.policyDescription()).add("PolicyName", (Object)this.policyName()).add("Tier", (Object)this.tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataLocationConstraint": {
                return Optional.ofNullable(clazz.cast(this.dataLocationConstraintAsString()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policyAsStrings()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "policyDescription": {
                return Optional.ofNullable(clazz.cast(this.policyDescription()));
            }
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataLocationConstraint", DATA_LOCATION_CONSTRAINT_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("policyDescription", POLICY_DESCRIPTION_FIELD);
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("tier", TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResiliencyPolicyRequest, T> g) {
        return obj -> g.apply((UpdateResiliencyPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String dataLocationConstraint;
        private Map<String, FailurePolicy> policy = DefaultSdkAutoConstructMap.getInstance();
        private String policyArn;
        private String policyDescription;
        private String policyName;
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResiliencyPolicyRequest model) {
            super(model);
            this.dataLocationConstraint(model.dataLocationConstraint);
            this.policyWithStrings(model.policy);
            this.policyArn(model.policyArn);
            this.policyDescription(model.policyDescription);
            this.policyName(model.policyName);
            this.tier(model.tier);
        }

        public final String getDataLocationConstraint() {
            return this.dataLocationConstraint;
        }

        public final void setDataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
        }

        @Override
        public final Builder dataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
            return this;
        }

        @Override
        public final Builder dataLocationConstraint(DataLocationConstraint dataLocationConstraint) {
            this.dataLocationConstraint(dataLocationConstraint == null ? null : dataLocationConstraint.toString());
            return this;
        }

        public final Map<String, FailurePolicy.Builder> getPolicy() {
            Map<String, FailurePolicy.Builder> result = DisruptionPolicyCopier.copyToBuilder(this.policy);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPolicy(Map<String, FailurePolicy.BuilderImpl> policy) {
            this.policy = DisruptionPolicyCopier.copyFromBuilder(policy);
        }

        @Override
        public final Builder policyWithStrings(Map<String, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copy(policy);
            return this;
        }

        @Override
        public final Builder policy(Map<DisruptionType, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copyEnumToString(policy);
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyDescription() {
            return this.policyDescription;
        }

        public final void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        @Override
        public final Builder policyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(ResiliencyPolicyTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResiliencyPolicyRequest build() {
            return new UpdateResiliencyPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResiliencyPolicyRequest> {
        public Builder dataLocationConstraint(String var1);

        public Builder dataLocationConstraint(DataLocationConstraint var1);

        public Builder policyWithStrings(Map<String, FailurePolicy> var1);

        public Builder policy(Map<DisruptionType, FailurePolicy> var1);

        public Builder policyArn(String var1);

        public Builder policyDescription(String var1);

        public Builder policyName(String var1);

        public Builder tier(String var1);

        public Builder tier(ResiliencyPolicyTier var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

