/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Experiment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Experiment> {
    private static final SdkField<String> EXPERIMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experimentArn").getter(Experiment.getter(Experiment::experimentArn)).setter(Experiment.setter(Builder::experimentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentArn").build()}).build();
    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experimentTemplateId").getter(Experiment.getter(Experiment::experimentTemplateId)).setter(Experiment.setter(Builder::experimentTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ARN_FIELD, EXPERIMENT_TEMPLATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Experiment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String experimentArn;
    private final String experimentTemplateId;

    private Experiment(BuilderImpl builder) {
        this.experimentArn = builder.experimentArn;
        this.experimentTemplateId = builder.experimentTemplateId;
    }

    public final String experimentArn() {
        return this.experimentArn;
    }

    public final String experimentTemplateId() {
        return this.experimentTemplateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentTemplateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment)obj;
        return Objects.equals(this.experimentArn(), other.experimentArn()) && Objects.equals(this.experimentTemplateId(), other.experimentTemplateId());
    }

    public final String toString() {
        return ToString.builder((String)"Experiment").add("ExperimentArn", (Object)this.experimentArn()).add("ExperimentTemplateId", (Object)this.experimentTemplateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "experimentArn": {
                return Optional.ofNullable(clazz.cast(this.experimentArn()));
            }
            case "experimentTemplateId": {
                return Optional.ofNullable(clazz.cast(this.experimentTemplateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("experimentArn", EXPERIMENT_ARN_FIELD);
        map.put("experimentTemplateId", EXPERIMENT_TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Experiment, T> g) {
        return obj -> g.apply((Experiment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String experimentArn;
        private String experimentTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(Experiment model) {
            this.experimentArn(model.experimentArn);
            this.experimentTemplateId(model.experimentTemplateId);
        }

        public final String getExperimentArn() {
            return this.experimentArn;
        }

        public final void setExperimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
        }

        @Override
        public final Builder experimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
            return this;
        }

        public final String getExperimentTemplateId() {
            return this.experimentTemplateId;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        public Experiment build() {
            return new Experiment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Experiment> {
        public Builder experimentArn(String var1);

        public Builder experimentTemplateId(String var1);
    }
}

