/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Sort> {
    private static final SdkField<Boolean> ASCENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ascending").getter(Sort.getter(Sort::ascending)).setter(Sort.setter(Builder::ascending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ascending").build()}).build();
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("field").getter(Sort.getter(Sort::field)).setter(Sort.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASCENDING_FIELD, FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Sort.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean ascending;
    private final String field;

    private Sort(BuilderImpl builder) {
        this.ascending = builder.ascending;
        this.field = builder.field;
    }

    public final Boolean ascending() {
        return this.ascending;
    }

    public final String field() {
        return this.field;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ascending());
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)obj;
        return Objects.equals(this.ascending(), other.ascending()) && Objects.equals(this.field(), other.field());
    }

    public final String toString() {
        return ToString.builder((String)"Sort").add("Ascending", (Object)this.ascending()).add("Field", (Object)this.field()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ascending": {
                return Optional.ofNullable(clazz.cast(this.ascending()));
            }
            case "field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ascending", ASCENDING_FIELD);
        map.put("field", FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sort, T> g) {
        return obj -> g.apply((Sort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean ascending;
        private String field;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            this.ascending(model.ascending);
            this.field(model.field);
        }

        public final Boolean getAscending() {
            return this.ascending;
        }

        public final void setAscending(Boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public final Builder ascending(Boolean ascending) {
            this.ascending = ascending;
            return this;
        }

        public final String getField() {
            return this.field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public Sort build() {
            return new Sort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Sort> {
        public Builder ascending(Boolean var1);

        public Builder field(String var1);
    }
}

