/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentComplianceCopier;
import software.amazon.awssdk.services.resiliencehub.model.ConfigRecommendationOptimizationType;
import software.amazon.awssdk.services.resiliencehub.model.Cost;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionCompliance;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.HaArchitecture;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationComplianceCopier;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationDisruptionCompliance;
import software.amazon.awssdk.services.resiliencehub.model.SuggestedChangesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appComponentName").getter(ConfigRecommendation.getter(ConfigRecommendation::appComponentName)).setter(ConfigRecommendation.setter(Builder::appComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()}).build();
    private static final SdkField<Map<String, DisruptionCompliance>> COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("compliance").getter(ConfigRecommendation.getter(ConfigRecommendation::complianceAsStrings)).setter(ConfigRecommendation.setter(Builder::complianceWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliance").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisruptionCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Cost> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cost").getter(ConfigRecommendation.getter(ConfigRecommendation::cost)).setter(ConfigRecommendation.setter(Builder::cost)).constructor(Cost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ConfigRecommendation.getter(ConfigRecommendation::description)).setter(ConfigRecommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> HA_ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("haArchitecture").getter(ConfigRecommendation.getter(ConfigRecommendation::haArchitectureAsString)).setter(ConfigRecommendation.setter(Builder::haArchitecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("haArchitecture").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfigRecommendation.getter(ConfigRecommendation::name)).setter(ConfigRecommendation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OPTIMIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("optimizationType").getter(ConfigRecommendation.getter(ConfigRecommendation::optimizationTypeAsString)).setter(ConfigRecommendation.setter(Builder::optimizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optimizationType").build()}).build();
    private static final SdkField<Map<String, RecommendationDisruptionCompliance>> RECOMMENDATION_COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("recommendationCompliance").getter(ConfigRecommendation.getter(ConfigRecommendation::recommendationComplianceAsStrings)).setter(ConfigRecommendation.setter(Builder::recommendationComplianceWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationCompliance").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationDisruptionCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(ConfigRecommendation.getter(ConfigRecommendation::referenceId)).setter(ConfigRecommendation.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final SdkField<List<String>> SUGGESTED_CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suggestedChanges").getter(ConfigRecommendation.getter(ConfigRecommendation::suggestedChanges)).setter(ConfigRecommendation.setter(Builder::suggestedChanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedChanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD, COMPLIANCE_FIELD, COST_FIELD, DESCRIPTION_FIELD, HA_ARCHITECTURE_FIELD, NAME_FIELD, OPTIMIZATION_TYPE_FIELD, RECOMMENDATION_COMPLIANCE_FIELD, REFERENCE_ID_FIELD, SUGGESTED_CHANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appComponentName;
    private final Map<String, DisruptionCompliance> compliance;
    private final Cost cost;
    private final String description;
    private final String haArchitecture;
    private final String name;
    private final String optimizationType;
    private final Map<String, RecommendationDisruptionCompliance> recommendationCompliance;
    private final String referenceId;
    private final List<String> suggestedChanges;

    private ConfigRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.compliance = builder.compliance;
        this.cost = builder.cost;
        this.description = builder.description;
        this.haArchitecture = builder.haArchitecture;
        this.name = builder.name;
        this.optimizationType = builder.optimizationType;
        this.recommendationCompliance = builder.recommendationCompliance;
        this.referenceId = builder.referenceId;
        this.suggestedChanges = builder.suggestedChanges;
    }

    public final String appComponentName() {
        return this.appComponentName;
    }

    public final Map<DisruptionType, DisruptionCompliance> compliance() {
        return AssessmentComplianceCopier.copyStringToEnum(this.compliance);
    }

    public final boolean hasCompliance() {
        return this.compliance != null && !(this.compliance instanceof SdkAutoConstructMap);
    }

    public final Map<String, DisruptionCompliance> complianceAsStrings() {
        return this.compliance;
    }

    public final Cost cost() {
        return this.cost;
    }

    public final String description() {
        return this.description;
    }

    public final HaArchitecture haArchitecture() {
        return HaArchitecture.fromValue(this.haArchitecture);
    }

    public final String haArchitectureAsString() {
        return this.haArchitecture;
    }

    public final String name() {
        return this.name;
    }

    public final ConfigRecommendationOptimizationType optimizationType() {
        return ConfigRecommendationOptimizationType.fromValue(this.optimizationType);
    }

    public final String optimizationTypeAsString() {
        return this.optimizationType;
    }

    public final Map<DisruptionType, RecommendationDisruptionCompliance> recommendationCompliance() {
        return RecommendationComplianceCopier.copyStringToEnum(this.recommendationCompliance);
    }

    public final boolean hasRecommendationCompliance() {
        return this.recommendationCompliance != null && !(this.recommendationCompliance instanceof SdkAutoConstructMap);
    }

    public final Map<String, RecommendationDisruptionCompliance> recommendationComplianceAsStrings() {
        return this.recommendationCompliance;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final boolean hasSuggestedChanges() {
        return this.suggestedChanges != null && !(this.suggestedChanges instanceof SdkAutoConstructList);
    }

    public final List<String> suggestedChanges() {
        return this.suggestedChanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompliance() ? this.complianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.haArchitectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationCompliance() ? this.recommendationComplianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestedChanges() ? this.suggestedChanges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRecommendation)) {
            return false;
        }
        ConfigRecommendation other = (ConfigRecommendation)obj;
        return Objects.equals(this.appComponentName(), other.appComponentName()) && this.hasCompliance() == other.hasCompliance() && Objects.equals(this.complianceAsStrings(), other.complianceAsStrings()) && Objects.equals(this.cost(), other.cost()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.haArchitectureAsString(), other.haArchitectureAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.optimizationTypeAsString(), other.optimizationTypeAsString()) && this.hasRecommendationCompliance() == other.hasRecommendationCompliance() && Objects.equals(this.recommendationComplianceAsStrings(), other.recommendationComplianceAsStrings()) && Objects.equals(this.referenceId(), other.referenceId()) && this.hasSuggestedChanges() == other.hasSuggestedChanges() && Objects.equals(this.suggestedChanges(), other.suggestedChanges());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigRecommendation").add("AppComponentName", (Object)this.appComponentName()).add("Compliance", this.hasCompliance() ? this.complianceAsStrings() : null).add("Cost", (Object)this.cost()).add("Description", (Object)this.description()).add("HaArchitecture", (Object)this.haArchitectureAsString()).add("Name", (Object)this.name()).add("OptimizationType", (Object)this.optimizationTypeAsString()).add("RecommendationCompliance", this.hasRecommendationCompliance() ? this.recommendationComplianceAsStrings() : null).add("ReferenceId", (Object)this.referenceId()).add("SuggestedChanges", this.hasSuggestedChanges() ? this.suggestedChanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponentName": {
                return Optional.ofNullable(clazz.cast(this.appComponentName()));
            }
            case "compliance": {
                return Optional.ofNullable(clazz.cast(this.complianceAsStrings()));
            }
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "haArchitecture": {
                return Optional.ofNullable(clazz.cast(this.haArchitectureAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "optimizationType": {
                return Optional.ofNullable(clazz.cast(this.optimizationTypeAsString()));
            }
            case "recommendationCompliance": {
                return Optional.ofNullable(clazz.cast(this.recommendationComplianceAsStrings()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "suggestedChanges": {
                return Optional.ofNullable(clazz.cast(this.suggestedChanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appComponentName", APP_COMPONENT_NAME_FIELD);
        map.put("compliance", COMPLIANCE_FIELD);
        map.put("cost", COST_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("haArchitecture", HA_ARCHITECTURE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("optimizationType", OPTIMIZATION_TYPE_FIELD);
        map.put("recommendationCompliance", RECOMMENDATION_COMPLIANCE_FIELD);
        map.put("referenceId", REFERENCE_ID_FIELD);
        map.put("suggestedChanges", SUGGESTED_CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigRecommendation, T> g) {
        return obj -> g.apply((ConfigRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appComponentName;
        private Map<String, DisruptionCompliance> compliance = DefaultSdkAutoConstructMap.getInstance();
        private Cost cost;
        private String description;
        private String haArchitecture;
        private String name;
        private String optimizationType;
        private Map<String, RecommendationDisruptionCompliance> recommendationCompliance = DefaultSdkAutoConstructMap.getInstance();
        private String referenceId;
        private List<String> suggestedChanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRecommendation model) {
            this.appComponentName(model.appComponentName);
            this.complianceWithStrings(model.compliance);
            this.cost(model.cost);
            this.description(model.description);
            this.haArchitecture(model.haArchitecture);
            this.name(model.name);
            this.optimizationType(model.optimizationType);
            this.recommendationComplianceWithStrings(model.recommendationCompliance);
            this.referenceId(model.referenceId);
            this.suggestedChanges(model.suggestedChanges);
        }

        public final String getAppComponentName() {
            return this.appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getCompliance() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.compliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompliance(Map<String, DisruptionCompliance.BuilderImpl> compliance) {
            this.compliance = AssessmentComplianceCopier.copyFromBuilder(compliance);
        }

        @Override
        public final Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copy(compliance);
            return this;
        }

        @Override
        public final Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copyEnumToString(compliance);
            return this;
        }

        public final Cost.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHaArchitecture() {
            return this.haArchitecture;
        }

        public final void setHaArchitecture(String haArchitecture) {
            this.haArchitecture = haArchitecture;
        }

        @Override
        public final Builder haArchitecture(String haArchitecture) {
            this.haArchitecture = haArchitecture;
            return this;
        }

        @Override
        public final Builder haArchitecture(HaArchitecture haArchitecture) {
            this.haArchitecture(haArchitecture == null ? null : haArchitecture.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOptimizationType() {
            return this.optimizationType;
        }

        public final void setOptimizationType(String optimizationType) {
            this.optimizationType = optimizationType;
        }

        @Override
        public final Builder optimizationType(String optimizationType) {
            this.optimizationType = optimizationType;
            return this;
        }

        @Override
        public final Builder optimizationType(ConfigRecommendationOptimizationType optimizationType) {
            this.optimizationType(optimizationType == null ? null : optimizationType.toString());
            return this;
        }

        public final Map<String, RecommendationDisruptionCompliance.Builder> getRecommendationCompliance() {
            Map<String, RecommendationDisruptionCompliance.Builder> result = RecommendationComplianceCopier.copyToBuilder(this.recommendationCompliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRecommendationCompliance(Map<String, RecommendationDisruptionCompliance.BuilderImpl> recommendationCompliance) {
            this.recommendationCompliance = RecommendationComplianceCopier.copyFromBuilder(recommendationCompliance);
        }

        @Override
        public final Builder recommendationComplianceWithStrings(Map<String, RecommendationDisruptionCompliance> recommendationCompliance) {
            this.recommendationCompliance = RecommendationComplianceCopier.copy(recommendationCompliance);
            return this;
        }

        @Override
        public final Builder recommendationCompliance(Map<DisruptionType, RecommendationDisruptionCompliance> recommendationCompliance) {
            this.recommendationCompliance = RecommendationComplianceCopier.copyEnumToString(recommendationCompliance);
            return this;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final Collection<String> getSuggestedChanges() {
            if (this.suggestedChanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suggestedChanges;
        }

        public final void setSuggestedChanges(Collection<String> suggestedChanges) {
            this.suggestedChanges = SuggestedChangesListCopier.copy(suggestedChanges);
        }

        @Override
        public final Builder suggestedChanges(Collection<String> suggestedChanges) {
            this.suggestedChanges = SuggestedChangesListCopier.copy(suggestedChanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedChanges(String ... suggestedChanges) {
            this.suggestedChanges(Arrays.asList(suggestedChanges));
            return this;
        }

        public ConfigRecommendation build() {
            return new ConfigRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigRecommendation> {
        public Builder appComponentName(String var1);

        public Builder complianceWithStrings(Map<String, DisruptionCompliance> var1);

        public Builder compliance(Map<DisruptionType, DisruptionCompliance> var1);

        public Builder cost(Cost var1);

        default public Builder cost(Consumer<Cost.Builder> cost) {
            return this.cost((Cost)((Cost.Builder)Cost.builder().applyMutation(cost)).build());
        }

        public Builder description(String var1);

        public Builder haArchitecture(String var1);

        public Builder haArchitecture(HaArchitecture var1);

        public Builder name(String var1);

        public Builder optimizationType(String var1);

        public Builder optimizationType(ConfigRecommendationOptimizationType var1);

        public Builder recommendationComplianceWithStrings(Map<String, RecommendationDisruptionCompliance> var1);

        public Builder recommendationCompliance(Map<DisruptionType, RecommendationDisruptionCompliance> var1);

        public Builder referenceId(String var1);

        public Builder suggestedChanges(Collection<String> var1);

        public Builder suggestedChanges(String ... var1);
    }
}

