/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTagsRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<GetTagsRequest.Builder, GetTagsRequest> {
    private final String arn;

    private GetTagsRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ARN of the resource for which you want a list of tags. The resource must exist within the account you are
     * using.
     * </p>
     * 
     * @return The ARN of the resource for which you want a list of tags. The resource must exist within the account you
     *         are using.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagsRequest)) {
            return false;
        }
        GetTagsRequest other = (GetTagsRequest) obj;
        return Objects.equals(arn(), other.arn());
    }

    @Override
    public String toString() {
        return ToString.builder("GetTagsRequest").add("Arn", arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ResourceGroupsRequest.Builder, CopyableBuilder<Builder, GetTagsRequest> {
        /**
         * <p>
         * The ARN of the resource for which you want a list of tags. The resource must exist within the account you are
         * using.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource for which you want a list of tags. The resource must exist within the account
         *        you are using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagsRequest model) {
            super(model);
            arn(model.arn);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTagsRequest build() {
            return new GetTagsRequest(this);
        }
    }
}
