/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.resourcegroups.transform.GroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Group implements StructuredPojo, ToCopyableBuilder<Group.Builder, Group> {
    private final String groupArn;

    private final String name;

    private final String description;

    private Group(BuilderImpl builder) {
        this.groupArn = builder.groupArn;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ARN of a resource group.
     * </p>
     * 
     * @return The ARN of a resource group.
     */
    public String groupArn() {
        return groupArn;
    }

    /**
     * <p>
     * The name of a resource group.
     * </p>
     * 
     * @return The name of a resource group.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the resource group.
     * </p>
     * 
     * @return The description of the resource group.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group) obj;
        return Objects.equals(groupArn(), other.groupArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("Group").add("GroupArn", groupArn()).add("Name", name()).add("Description", description())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Group> {
        /**
         * <p>
         * The ARN of a resource group.
         * </p>
         * 
         * @param groupArn
         *        The ARN of a resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);

        /**
         * <p>
         * The name of a resource group.
         * </p>
         * 
         * @param name
         *        The name of a resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the resource group.
         * </p>
         * 
         * @param description
         *        The description of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String groupArn;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            groupArn(model.groupArn);
            name(model.name);
            description(model.description);
        }

        public final String getGroupArn() {
            return groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Group build() {
            return new Group(this);
        }
    }
}
