/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.resourcegroups.transform.GroupQueryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The underlying resource query of a resource group. Resources that match query results are part of the group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupQuery implements StructuredPojo, ToCopyableBuilder<GroupQuery.Builder, GroupQuery> {
    private final String groupName;

    private final ResourceQuery resourceQuery;

    private GroupQuery(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.resourceQuery = builder.resourceQuery;
    }

    /**
     * <p>
     * The name of a resource group that is associated with a specific resource query.
     * </p>
     * 
     * @return The name of a resource group that is associated with a specific resource query.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The resource query which determines which AWS resources are members of the associated resource group.
     * </p>
     * 
     * @return The resource query which determines which AWS resources are members of the associated resource group.
     */
    public ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupQuery)) {
            return false;
        }
        GroupQuery other = (GroupQuery) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(resourceQuery(), other.resourceQuery());
    }

    @Override
    public String toString() {
        return ToString.builder("GroupQuery").add("GroupName", groupName()).add("ResourceQuery", resourceQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupQueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, GroupQuery> {
        /**
         * <p>
         * The name of a resource group that is associated with a specific resource query.
         * </p>
         * 
         * @param groupName
         *        The name of a resource group that is associated with a specific resource query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The resource query which determines which AWS resources are members of the associated resource group.
         * </p>
         * 
         * @param resourceQuery
         *        The resource query which determines which AWS resources are members of the associated resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The resource query which determines which AWS resources are members of the associated resource group.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuery.Builder} avoiding the need to
         * create one manually via {@link ResourceQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private ResourceQuery resourceQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupQuery model) {
            groupName(model.groupName);
            resourceQuery(model.resourceQuery);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public GroupQuery build() {
            return new GroupQuery(this);
        }
    }
}
