/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.resourcegroups.transform.ResourceIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ARN of a resource, and its resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIdentifier implements StructuredPojo,
        ToCopyableBuilder<ResourceIdentifier.Builder, ResourceIdentifier> {
    private final String resourceArn;

    private final String resourceType;

    private ResourceIdentifier(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The ARN of a resource.
     * </p>
     * 
     * @return The ARN of a resource.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The resource type of a resource, such as <code>AWS::EC2::Instance</code>.
     * </p>
     * 
     * @return The resource type of a resource, such as <code>AWS::EC2::Instance</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceType(), other.resourceType());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceIdentifier").add("ResourceArn", resourceArn()).add("ResourceType", resourceType())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceIdentifier> {
        /**
         * <p>
         * The ARN of a resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The resource type of a resource, such as <code>AWS::EC2::Instance</code>.
         * </p>
         * 
         * @param resourceType
         *        The resource type of a resource, such as <code>AWS::EC2::Instance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }
    }
}
