/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.resourcegroups.transform.ResourceQueryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The query that is used to define a resource group or a search for resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceQuery implements StructuredPojo, ToCopyableBuilder<ResourceQuery.Builder, ResourceQuery> {
    private final String type;

    private final String query;

    private ResourceQuery(BuilderImpl builder) {
        this.type = builder.type;
        this.query = builder.query;
    }

    /**
     * <p>
     * The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.
     * </p>
     * <p>
     * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters for
     * resource types and tags, as supported by the AWS Tagging API GetResources operation. When more than one element
     * is present, only resources that match all filters are part of the result. If a filter specifies more than one
     * value for a key, a resource matches the filter if its tag value matches any of the specified values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.</p>
     *         <p>
     *         <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
     *         filters for resource types and tags, as supported by the AWS Tagging API GetResources operation. When
     *         more than one element is present, only resources that match all filters are part of the result. If a
     *         filter specifies more than one value for a key, a resource matches the filter if its tag value matches
     *         any of the specified values.
     * @see QueryType
     */
    public QueryType type() {
        return QueryType.fromValue(type);
    }

    /**
     * <p>
     * The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.
     * </p>
     * <p>
     * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters for
     * resource types and tags, as supported by the AWS Tagging API GetResources operation. When more than one element
     * is present, only resources that match all filters are part of the result. If a filter specifies more than one
     * value for a key, a resource matches the filter if its tag value matches any of the specified values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.</p>
     *         <p>
     *         <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
     *         filters for resource types and tags, as supported by the AWS Tagging API GetResources operation. When
     *         more than one element is present, only resources that match all filters are part of the result. If a
     *         filter specifies more than one value for a key, a resource matches the filter if its tag value matches
     *         any of the specified values.
     * @see QueryType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The query that defines a group or a search.
     * </p>
     * 
     * @return The query that defines a group or a search.
     */
    public String query() {
        return query;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(query());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceQuery)) {
            return false;
        }
        ResourceQuery other = (ResourceQuery) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(query(), other.query());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceQuery").add("Type", typeAsString()).add("Query", query()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Query":
            return Optional.ofNullable(clazz.cast(query()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceQueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceQuery> {
        /**
         * <p>
         * The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.
         * </p>
         * <p>
         * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters
         * for resource types and tags, as supported by the AWS Tagging API GetResources operation. When more than one
         * element is present, only resources that match all filters are part of the result. If a filter specifies more
         * than one value for a key, a resource matches the filter if its tag value matches any of the specified values.
         * </p>
         * 
         * @param type
         *        The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.</p>
         *        <p>
         *        <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
         *        filters for resource types and tags, as supported by the AWS Tagging API GetResources operation. When
         *        more than one element is present, only resources that match all filters are part of the result. If a
         *        filter specifies more than one value for a key, a resource matches the filter if its tag value matches
         *        any of the specified values.
         * @see QueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.
         * </p>
         * <p>
         * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters
         * for resource types and tags, as supported by the AWS Tagging API GetResources operation. When more than one
         * element is present, only resources that match all filters are part of the result. If a filter specifies more
         * than one value for a key, a resource matches the filter if its tag value matches any of the specified values.
         * </p>
         * 
         * @param type
         *        The type of the query. The valid value in this release is <code>TAG_FILTERS_1_0</code>.</p>
         *        <p>
         *        <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
         *        filters for resource types and tags, as supported by the AWS Tagging API GetResources operation. When
         *        more than one element is present, only resources that match all filters are part of the result. If a
         *        filter specifies more than one value for a key, a resource matches the filter if its tag value matches
         *        any of the specified values.
         * @see QueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryType
         */
        Builder type(QueryType type);

        /**
         * <p>
         * The query that defines a group or a search.
         * </p>
         * 
         * @param query
         *        The query that defines a group or a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String query;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceQuery model) {
            type(model.type);
            query(model.query);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getQuery() {
            return query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public ResourceQuery build() {
            return new ResourceQuery(this);
        }
    }
}
