/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourcesResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<SearchResourcesResponse.Builder, SearchResourcesResponse> {
    private final List<ResourceIdentifier> resourceIdentifiers;

    private final String nextToken;

    private SearchResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARNs and resource types of resources that are members of the group that you specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ARNs and resource types of resources that are members of the group that you specified.
     */
    public List<ResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    /**
     * <p>
     * The NextToken value to include in a subsequent <code>SearchResources</code> request, to get more results.
     * </p>
     * 
     * @return The NextToken value to include in a subsequent <code>SearchResources</code> request, to get more results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesResponse)) {
            return false;
        }
        SearchResourcesResponse other = (SearchResourcesResponse) obj;
        return Objects.equals(resourceIdentifiers(), other.resourceIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchResourcesResponse").add("ResourceIdentifiers", resourceIdentifiers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(resourceIdentifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ResourceGroupsResponse.Builder, CopyableBuilder<Builder, SearchResourcesResponse> {
        /**
         * <p>
         * The ARNs and resource types of resources that are members of the group that you specified.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The ARNs and resource types of resources that are members of the group that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * The ARNs and resource types of resources that are members of the group that you specified.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The ARNs and resource types of resources that are members of the group that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * The ARNs and resource types of resources that are members of the group that you specified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceIdentifier>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceIdentifier>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceIdentifiers(List<ResourceIdentifier>)}.
         * 
         * @param resourceIdentifiers
         *        a consumer that will call methods on {@link List<ResourceIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifiers(List<ResourceIdentifier>)
         */
        Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers);

        /**
         * <p>
         * The NextToken value to include in a subsequent <code>SearchResources</code> request, to get more results.
         * </p>
         * 
         * @param nextToken
         *        The NextToken value to include in a subsequent <code>SearchResources</code> request, to get more
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private List<ResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesResponse model) {
            super(model);
            resourceIdentifiers(model.resourceIdentifiers);
            nextToken(model.nextToken);
        }

        public final Collection<ResourceIdentifier.Builder> getResourceIdentifiers() {
            return resourceIdentifiers != null ? resourceIdentifiers.stream().map(ResourceIdentifier::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers) {
            resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> ResourceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceIdentifiers(Collection<ResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchResourcesResponse build() {
            return new SearchResourcesResponse(this);
        }
    }
}
