/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagRequest extends ResourceGroupsRequest implements ToCopyableBuilder<TagRequest.Builder, TagRequest> {
    private final String arn;

    private final Map<String, String> tags;

    private TagRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the resource to which to add tags.
     * </p>
     * 
     * @return The ARN of the resource to which to add tags.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The tags to add to the specified resource. A tag is a string-to-string map of key-value pairs. Tag keys can have
     * a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to add to the specified resource. A tag is a string-to-string map of key-value pairs. Tag keys
     *         can have a maximum character length of 128 characters, and tag values can have a maximum length of 256
     *         characters.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagRequest)) {
            return false;
        }
        TagRequest other = (TagRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("TagRequest").add("Arn", arn()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ResourceGroupsRequest.Builder, CopyableBuilder<Builder, TagRequest> {
        /**
         * <p>
         * The ARN of the resource to which to add tags.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource to which to add tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The tags to add to the specified resource. A tag is a string-to-string map of key-value pairs. Tag keys can
         * have a maximum character length of 128 characters, and tag values can have a maximum length of 256
         * characters.
         * </p>
         * 
         * @param tags
         *        The tags to add to the specified resource. A tag is a string-to-string map of key-value pairs. Tag
         *        keys can have a maximum character length of 128 characters, and tag values can have a maximum length
         *        of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String arn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagRequest model) {
            super(model);
            arn(model.arn);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TagRequest build() {
            return new TagRequest(this);
        }
    }
}
