/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.resourcegroups.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateGroupQueryResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateGroupQueryResponseUnmarshaller implements Unmarshaller<UpdateGroupQueryResponse, JsonUnmarshallerContext> {

    public UpdateGroupQueryResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateGroupQueryResponse.Builder updateGroupQueryResponseBuilder = UpdateGroupQueryResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return updateGroupQueryResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("GroupQuery", targetDepth)) {
                    context.nextToken();
                    updateGroupQueryResponseBuilder.groupQuery(GroupQueryUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return updateGroupQueryResponseBuilder.build();
    }

    private static final UpdateGroupQueryResponseUnmarshaller INSTANCE = new UpdateGroupQueryResponseUnmarshaller();

    public static UpdateGroupQueryResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
